/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.PyramidFloat;

public class PyramidFloatGaussianScale<T extends ImageGray<T>>
extends PyramidFloat<T> {
    protected InterpolatePixelS<T> interpolate;
    protected T tempImage;
    protected float[] sigmaLayers;
    protected double[] sigma;

    public PyramidFloatGaussianScale(InterpolatePixelS<T> interpolate, double[] scales, double[] sigmaLayers, Class<T> imageType) {
        super(ImageType.single(imageType), scales);
        int i;
        if (scales.length != sigmaLayers.length) {
            throw new IllegalArgumentException("Number of scales and sigmas must be the same");
        }
        this.interpolate = interpolate;
        this.sigmaLayers = new float[sigmaLayers.length];
        for (i = 0; i < sigmaLayers.length; ++i) {
            this.sigmaLayers[i] = (float)sigmaLayers[i];
        }
        this.sigma = new double[sigmaLayers.length];
        this.sigma[0] = sigmaLayers[0];
        for (i = 1; i < scales.length; ++i) {
            double effectiveSigma = sigmaLayers[i] * scales[i - 1];
            this.sigma[i] = Math.sqrt(this.sigma[i - 1] * this.sigma[i - 1] + effectiveSigma * effectiveSigma);
        }
    }

    public void process(T input) {
        super.initialize(((ImageGray)input).width, ((ImageGray)input).height);
        if (this.isSaveOriginalReference()) {
            throw new IllegalArgumentException("The original reference cannot be saved");
        }
        if (this.tempImage == null) {
            this.tempImage = (ImageGray)input.createNew(((ImageGray)input).width, ((ImageGray)input).height);
        }
        for (int i = 0; i < this.scale.length; ++i) {
            T prev = i == 0 ? input : (ImageGray)this.getLayer(i - 1);
            ImageGray layer = (ImageGray)this.getLayer(i);
            BlurStorageFilter<T> blur = FactoryBlurFilter.gaussian(layer.getImageType(), (double)this.sigmaLayers[i], -1);
            this.tempImage.reshape(((ImageGray)prev).width, ((ImageGray)prev).height);
            blur.process(prev, this.tempImage);
            if (this.scale[i] == 1.0) {
                layer.setTo(this.tempImage);
                continue;
            }
            PixelTransformAffine_F32 model = DistortSupport.transformScale((ImageBase)layer, this.tempImage, null);
            DistortImageOps.distortSingle(this.tempImage, layer, true, model, this.interpolate);
        }
    }

    public InterpolatePixelS<T> getInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(InterpolatePixelS<T> interpolate) {
        this.interpolate = interpolate;
    }

    public double getSampleOffset(int layer) {
        return 0.0;
    }

    public double getSigma(int layer) {
        return this.sigma[layer];
    }

    public float[] getSigmaLayers() {
        return this.sigmaLayers;
    }
}

