/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class ImplConvertPlanarToGray {
    public static void average(Planar<GrayU8> from, GrayU8 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            GrayU8 band0 = (GrayU8)from.getBand(0);
            GrayU8 band1 = (GrayU8)from.getBand(1);
            GrayU8 band2 = (GrayU8)from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom] & 0xFF;
                    sum += band1.data[indexFrom] & 0xFF;
                    to.data[indexTo++] = (byte)((sum += band2.data[indexFrom] & 0xFF) / 3);
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((GrayU8[])from.bands)[b].data[indexFrom] & 0xFF;
                    }
                    to.data[indexTo++] = (byte)(sum / numBands);
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(Planar<GrayS8> from, GrayS8 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            GrayS8 band0 = (GrayS8)from.getBand(0);
            GrayS8 band1 = (GrayS8)from.getBand(1);
            GrayS8 band2 = (GrayS8)from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (byte)((sum += band2.data[indexFrom]) / 3);
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((GrayS8[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = (byte)(sum / numBands);
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(Planar<GrayU16> from, GrayU16 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            GrayU16 band0 = (GrayU16)from.getBand(0);
            GrayU16 band1 = (GrayU16)from.getBand(1);
            GrayU16 band2 = (GrayU16)from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom] & 0xFFFF;
                    sum += band1.data[indexFrom] & 0xFFFF;
                    to.data[indexTo++] = (short)((sum += band2.data[indexFrom] & 0xFFFF) / 3);
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((GrayU16[])from.bands)[b].data[indexFrom] & 0xFFFF;
                    }
                    to.data[indexTo++] = (short)(sum / numBands);
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(Planar<GrayS16> from, GrayS16 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            GrayS16 band0 = (GrayS16)from.getBand(0);
            GrayS16 band1 = (GrayS16)from.getBand(1);
            GrayS16 band2 = (GrayS16)from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (short)((sum += band2.data[indexFrom]) / 3);
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((GrayS16[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = (short)(sum / numBands);
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(Planar<GrayS32> from, GrayS32 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            GrayS32 band0 = (GrayS32)from.getBand(0);
            GrayS32 band1 = (GrayS32)from.getBand(1);
            GrayS32 band2 = (GrayS32)from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (sum += band2.data[indexFrom]) / 3;
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((GrayS32[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = sum / numBands;
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(Planar<GrayS64> from, GrayS64 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            GrayS64 band0 = (GrayS64)from.getBand(0);
            GrayS64 band1 = (GrayS64)from.getBand(1);
            GrayS64 band2 = (GrayS64)from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    long sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (sum += band2.data[indexFrom]) / 3L;
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    long sum = 0L;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((GrayS64[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = sum / (long)numBands;
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(Planar<GrayF32> from, GrayF32 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            GrayF32 band0 = (GrayF32)from.getBand(0);
            GrayF32 band1 = (GrayF32)from.getBand(1);
            GrayF32 band2 = (GrayF32)from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    float sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (sum += band2.data[indexFrom]) / 3.0f;
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    float sum = 0.0f;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((GrayF32[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = sum / (float)numBands;
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(Planar<GrayF64> from, GrayF64 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            GrayF64 band0 = (GrayF64)from.getBand(0);
            GrayF64 band1 = (GrayF64)from.getBand(1);
            GrayF64 band2 = (GrayF64)from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    double sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (sum += band2.data[indexFrom]) / 3.0;
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    double sum = 0.0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((GrayF64[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = sum / (double)numBands;
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }
}

