/*
 * Copyright (c) 2011-2019, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.alg.filter.convolve.normalized;

import boofcv.struct.convolve.*;
import boofcv.struct.image.*;

import javax.annotation.Generated;
import java.util.Arrays;

/**
 * <p>
 * Convolution with kernel renormalization around image borders.  Unoptimized naive implementation.
 * </p>
 * 
 * <p>
 * NOTE: Do not modify.  Automatically generated by GenerateConvolveNormalizedNaive_IL.
 * </p>
 * @author Peter Abeles
 */
@Generated({"boofcv.alg.filter.convolve.normalized.GenerateConvolveNormalizedNaive_IL"})
public class ConvolveNormalizedNaive_IL {

	public static void horizontal(Kernel1D_F32 kernel, InterleavedF32 input, InterleavedF32 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();
		
		final float[] pixel = new float[ numBands ];
		final float[] total = new float[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				float weight = 0;

				int startX = x - offset;
				int endX = startX+kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				for( int j = startX; j < endX; j++ ) {
					float v = kernel.get(j-x+offset);
					input.get(j,y, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] /= weight;
				}
				output.set(x,y, total );
			}
		}
	}

	public static void vertical(Kernel1D_F32 kernel, InterleavedF32 input, InterleavedF32 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final float[] pixel = new float[ numBands ];
		final float[] total = new float[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				float weight = 0;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				for( int i = startY; i < endY; i++ ) {
					float v = kernel.get(i-y+offset);
					input.get(x,i, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] /= weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void convolve(Kernel2D_F32 kernel, InterleavedF32 input, InterleavedF32 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final float[] pixel = new float[ numBands ];
		final float[] total = new float[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {

				int startX = x - offset;
				int endX = startX + kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				Arrays.fill(total,0);
				float weight = 0;

				for( int i = startY; i < endY; i++ ) {
					for( int j = startX; j < endX; j++ ) {
						input.get(j,i, pixel);
						float v = kernel.get(j-x+offset,i-y+offset);
						for (int band = 0; band < numBands; band++) {
							total[band] += pixel[band]*v;
						}
						weight += v;
					}
				}
				for (int band = 0; band < numBands; band++) {
					total[band] /= weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void horizontal(Kernel1D_F64 kernel, InterleavedF64 input, InterleavedF64 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();
		
		final double[] pixel = new double[ numBands ];
		final double[] total = new double[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				double weight = 0;

				int startX = x - offset;
				int endX = startX+kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				for( int j = startX; j < endX; j++ ) {
					double v = kernel.get(j-x+offset);
					input.get(j,y, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] /= weight;
				}
				output.set(x,y, total );
			}
		}
	}

	public static void vertical(Kernel1D_F64 kernel, InterleavedF64 input, InterleavedF64 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final double[] pixel = new double[ numBands ];
		final double[] total = new double[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				double weight = 0;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				for( int i = startY; i < endY; i++ ) {
					double v = kernel.get(i-y+offset);
					input.get(x,i, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] /= weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void convolve(Kernel2D_F64 kernel, InterleavedF64 input, InterleavedF64 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final double[] pixel = new double[ numBands ];
		final double[] total = new double[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {

				int startX = x - offset;
				int endX = startX + kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				Arrays.fill(total,0);
				double weight = 0;

				for( int i = startY; i < endY; i++ ) {
					for( int j = startX; j < endX; j++ ) {
						input.get(j,i, pixel);
						double v = kernel.get(j-x+offset,i-y+offset);
						for (int band = 0; band < numBands; band++) {
							total[band] += pixel[band]*v;
						}
						weight += v;
					}
				}
				for (int band = 0; band < numBands; band++) {
					total[band] /= weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void horizontal(Kernel1D_S32 kernel, InterleavedU8 input, InterleavedI8 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();
		
		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				int weight = 0;

				int startX = x - offset;
				int endX = startX+kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				for( int j = startX; j < endX; j++ ) {
					int v = kernel.get(j-x+offset);
					input.get(j,y, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total );
			}
		}
	}

	public static void vertical(Kernel1D_S32 kernel, InterleavedU8 input, InterleavedI8 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				int weight = 0;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				for( int i = startY; i < endY; i++ ) {
					int v = kernel.get(i-y+offset);
					input.get(x,i, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void convolve(Kernel2D_S32 kernel, InterleavedU8 input, InterleavedI8 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {

				int startX = x - offset;
				int endX = startX + kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				Arrays.fill(total,0);
				int weight = 0;

				for( int i = startY; i < endY; i++ ) {
					for( int j = startX; j < endX; j++ ) {
						input.get(j,i, pixel);
						int v = kernel.get(j-x+offset,i-y+offset);
						for (int band = 0; band < numBands; band++) {
							total[band] += pixel[band]*v;
						}
						weight += v;
					}
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void horizontal(Kernel1D_S32 kernel, InterleavedS16 input, InterleavedI16 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();
		
		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				int weight = 0;

				int startX = x - offset;
				int endX = startX+kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				for( int j = startX; j < endX; j++ ) {
					int v = kernel.get(j-x+offset);
					input.get(j,y, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total );
			}
		}
	}

	public static void vertical(Kernel1D_S32 kernel, InterleavedS16 input, InterleavedI16 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				int weight = 0;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				for( int i = startY; i < endY; i++ ) {
					int v = kernel.get(i-y+offset);
					input.get(x,i, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void convolve(Kernel2D_S32 kernel, InterleavedS16 input, InterleavedI16 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {

				int startX = x - offset;
				int endX = startX + kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				Arrays.fill(total,0);
				int weight = 0;

				for( int i = startY; i < endY; i++ ) {
					for( int j = startX; j < endX; j++ ) {
						input.get(j,i, pixel);
						int v = kernel.get(j-x+offset,i-y+offset);
						for (int band = 0; band < numBands; band++) {
							total[band] += pixel[band]*v;
						}
						weight += v;
					}
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void horizontal(Kernel1D_S32 kernel, InterleavedU16 input, InterleavedI16 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();
		
		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				int weight = 0;

				int startX = x - offset;
				int endX = startX+kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				for( int j = startX; j < endX; j++ ) {
					int v = kernel.get(j-x+offset);
					input.get(j,y, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total );
			}
		}
	}

	public static void vertical(Kernel1D_S32 kernel, InterleavedU16 input, InterleavedI16 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				int weight = 0;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				for( int i = startY; i < endY; i++ ) {
					int v = kernel.get(i-y+offset);
					input.get(x,i, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void convolve(Kernel2D_S32 kernel, InterleavedU16 input, InterleavedI16 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {

				int startX = x - offset;
				int endX = startX + kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				Arrays.fill(total,0);
				int weight = 0;

				for( int i = startY; i < endY; i++ ) {
					for( int j = startX; j < endX; j++ ) {
						input.get(j,i, pixel);
						int v = kernel.get(j-x+offset,i-y+offset);
						for (int band = 0; band < numBands; band++) {
							total[band] += pixel[band]*v;
						}
						weight += v;
					}
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void horizontal(Kernel1D_S32 kernel, InterleavedS32 input, InterleavedS32 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();
		
		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				int weight = 0;

				int startX = x - offset;
				int endX = startX+kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				for( int j = startX; j < endX; j++ ) {
					int v = kernel.get(j-x+offset);
					input.get(j,y, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total );
			}
		}
	}

	public static void vertical(Kernel1D_S32 kernel, InterleavedS32 input, InterleavedS32 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {
				Arrays.fill(total,0);
				int weight = 0;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				for( int i = startY; i < endY; i++ ) {
					int v = kernel.get(i-y+offset);
					input.get(x,i, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					weight += v;
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void convolve(Kernel2D_S32 kernel, InterleavedS32 input, InterleavedS32 output ) {

		final int offset = kernel.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for( int x = 0; x < width; x++ ) {

				int startX = x - offset;
				int endX = startX + kernel.getWidth();

				if( startX < 0 ) startX = 0;
				if( endX > width ) endX = width;

				int startY = y - offset;
				int endY = startY + kernel.getWidth();

				if( startY < 0 ) startY = 0;
				if( endY > height ) endY = height;

				Arrays.fill(total,0);
				int weight = 0;

				for( int i = startY; i < endY; i++ ) {
					for( int j = startX; j < endX; j++ ) {
						input.get(j,i, pixel);
						int v = kernel.get(j-x+offset,i-y+offset);
						for (int band = 0; band < numBands; band++) {
							total[band] += pixel[band]*v;
						}
						weight += v;
					}
				}
				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				output.set(x,y, total);
			}
		}
	}

	public static void vertical(Kernel1D_S32 kernelX, Kernel1D_S32 kernelY,
								InterleavedU16 input, InterleavedI8 output ) {

		final int offsetX = kernelX.getOffset();
		final int offsetY = kernelY.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				Arrays.fill(total,0);
				int weightY = 0;

				int startY = y - offsetY;
				int endY = startY + kernelY.getWidth();

				if (startY < 0) startY = 0;
				if (endY > height) endY = height;

				for (int i = startY; i < endY; i++) {
					int v = kernelY.get(i - y + offsetY);
					input.get(x, i, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					weightY += v;
				}

				int kerX0 = Math.max(0, offsetX - x);
				int kerX1 = Math.min(kernelX.getWidth(), width - x + offsetX);

				int weightX = 0;
				for (int i = kerX0; i < kerX1; i++) {
					weightX += kernelX.get(i);
				}

				int weight = weightX * weightY;

				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				
				output.set(x,y, total);
			}
		}
	}

	public static void vertical(Kernel1D_S32 kernelX, Kernel1D_S32 kernelY,
								InterleavedS32 input, InterleavedI16 output ) {

		final int offsetX = kernelX.getOffset();
		final int offsetY = kernelY.getOffset();

		final int width = input.getWidth();
		final int height = input.getHeight();
		final int numBands = input.getNumBands();

		final int[] pixel = new int[ numBands ];
		final int[] total = new int[ numBands ];

		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				Arrays.fill(total,0);
				int weightY = 0;

				int startY = y - offsetY;
				int endY = startY + kernelY.getWidth();

				if (startY < 0) startY = 0;
				if (endY > height) endY = height;

				for (int i = startY; i < endY; i++) {
					int v = kernelY.get(i - y + offsetY);
					input.get(x, i, pixel);
					for (int band = 0; band < numBands; band++) {
						total[band] += pixel[band]*v;
					}
					weightY += v;
				}

				int kerX0 = Math.max(0, offsetX - x);
				int kerX1 = Math.min(kernelX.getWidth(), width - x + offsetX);

				int weightX = 0;
				for (int i = kerX0; i < kerX1; i++) {
					weightX += kernelX.get(i);
				}

				int weight = weightX * weightY;

				for (int band = 0; band < numBands; band++) {
					total[band] = (total[band]+weight/2)/weight;
				}
				
				output.set(x,y, total);
			}
		}
	}

}
