/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;

public abstract class BinaryFilters
implements FilterImageInterface<GrayU8, GrayU8> {
    boolean outsideZero;
    int numTimes;
    ImageType<GrayU8> imageType = ImageType.single(GrayU8.class);

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<GrayU8> getInputType() {
        return this.imageType;
    }

    @Override
    public ImageType<GrayU8> getOutputType() {
        return this.imageType;
    }

    public boolean isOutsideZero() {
        return this.outsideZero;
    }

    public void setOutsideZero(boolean outsideZero) {
        this.outsideZero = outsideZero;
    }

    public int getNumTimes() {
        return this.numTimes;
    }

    public void setNumTimes(int numTimes) {
        this.numTimes = numTimes;
    }

    public static class Thin
    extends BinaryFilters {
        public Thin(int maxTimes) {
            this.numTimes = maxTimes;
        }

        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.thin(input, this.numTimes, output);
        }
    }

    public static class RemovePointNoise
    extends BinaryFilters {
        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.removePointNoise(input, output);
        }
    }

    public static class Edge8
    extends BinaryFilters {
        public Edge8(boolean outsideZero) {
            this.outsideZero = outsideZero;
        }

        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.edge8(input, output, this.outsideZero);
        }
    }

    public static class Dilate8
    extends BinaryFilters {
        public Dilate8(int numTimes) {
            this.numTimes = numTimes;
        }

        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.dilate8(input, this.numTimes, output);
        }
    }

    public static class Erode8
    extends BinaryFilters {
        public Erode8(int numTimes) {
            this.numTimes = numTimes;
        }

        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.erode8(input, this.numTimes, output);
        }
    }

    public static class Edge4
    extends BinaryFilters {
        public Edge4(boolean outsideZero) {
            this.outsideZero = outsideZero;
        }

        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.edge4(input, output, this.outsideZero);
        }
    }

    public static class Dilate4
    extends BinaryFilters {
        public Dilate4(int numTimes) {
            this.numTimes = numTimes;
        }

        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.dilate4(input, this.numTimes, output);
        }
    }

    public static class Erode4
    extends BinaryFilters {
        public Erode4(int numTimes) {
            this.numTimes = numTimes;
        }

        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.erode4(input, this.numTimes, output);
        }
    }

    public static class Invert
    extends BinaryFilters {
        @Override
        public void process(GrayU8 input, GrayU8 output) {
            BinaryImageOps.invert(input, output);
        }
    }
}

