/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.BoofDefaults;
import boofcv.abst.filter.derivative.ImageHessianDirect;
import boofcv.alg.filter.derivative.HessianSobel;
import boofcv.alg.filter.derivative.HessianThree;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public abstract class ImageHessianDirect_SB<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements ImageHessianDirect<Input, Output> {
    BorderType borderType = BoofDefaults.DERIV_BORDER_TYPE;
    ImageBorder<Input> border;
    Class<Input> inputType;
    Class<Output> derivType;

    public ImageHessianDirect_SB(Class<Input> inputType, Class<Output> derivType) {
        this.inputType = inputType;
        this.derivType = derivType;
        this.setBorderType(this.borderType);
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderType = type;
        this.border = FactoryImageBorder.single(this.inputType, this.borderType);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderType;
    }

    @Override
    public int getBorder() {
        if (this.borderType != BorderType.SKIP) {
            return 0;
        }
        return 1;
    }

    public ImageType<Input> getInputType() {
        return ImageType.single(this.inputType);
    }

    @Override
    public ImageType<Output> getDerivativeType() {
        return ImageType.single(this.derivType);
    }

    public static class Three<T extends ImageGray<T>, D extends ImageGray<D>>
    extends ImageHessianDirect_SB<T, D> {
        public Three(Class<T> inputType, Class<D> derivType) {
            super(inputType, derivType);
        }

        @Override
        public void process(T inputImage, D derivXX, D derivYY, D derivXY) {
            HessianThree.process(inputImage, derivXX, derivYY, derivXY, this.border);
        }
    }

    public static class Sobel<T extends ImageGray<T>, D extends ImageGray<D>>
    extends ImageHessianDirect_SB<T, D> {
        public Sobel(Class<T> inputType, Class<D> derivType) {
            super(inputType, derivType);
        }

        @Override
        public void process(T inputImage, D derivXX, D derivYY, D derivXY) {
            HessianSobel.process(inputImage, derivXX, derivYY, derivXY, this.border);
        }
    }
}

