/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.color.impl.ImplColorXyz;
import boofcv.alg.color.impl.ImplColorXyz_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class ColorXyz {
    public static void rgbToXyz(int r, int g, int b, double[] xyz) {
        ColorXyz.srgbToXyz((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, xyz);
    }

    public static void rgbToXyz(int r, int g, int b, float[] xyz) {
        ColorXyz.srgbToXyz((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, xyz);
    }

    public static void srgbToXyz(double r, double g, double b, double[] xyz) {
        xyz[0] = 0.412453 * r + 0.35758 * g + 0.180423 * b;
        xyz[1] = 0.212671 * r + 0.71516 * g + 0.072169 * b;
        xyz[2] = 0.019334 * r + 0.119193 * g + 0.950227 * b;
    }

    public static void srgbToXyz(float r, float g, float b, float[] xyz) {
        xyz[0] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
        xyz[1] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
        xyz[2] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
    }

    public static void xyzToSrgb(float x, float y, float z, float[] srgb) {
        srgb[0] = 3.240479f * x - 1.53715f * y - 0.498535f * z;
        srgb[1] = -0.969256f * x + 1.875991f * y + 0.041556f * z;
        srgb[2] = 0.055648f * x - 0.204043f * y + 1.057311f * z;
    }

    public static void xyzToSrgb(double x, double y, double z, double[] srgb) {
        srgb[0] = 3.240479 * x - 1.53715 * y - 0.498535 * z;
        srgb[1] = -0.969256 * x + 1.875991 * y + 0.041556 * z;
        srgb[2] = 0.055648 * x - 0.204043 * y + 1.057311 * z;
    }

    public static <T extends ImageGray<T>> void rgbToXyz(Planar<T> rgb, Planar<GrayF32> xyz) {
        xyz.reshape(rgb.width, rgb.height, 3);
        if (rgb.getBandType() == GrayU8.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorXyz_MT.rgbToXyz_U8(rgb, xyz);
            } else {
                ImplColorXyz.rgbToXyz_U8(rgb, xyz);
            }
        } else if (rgb.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorXyz_MT.rgbToXyz_F32(rgb, xyz);
            } else {
                ImplColorXyz.rgbToXyz_F32(rgb, xyz);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + rgb.getBandType().getSimpleName());
        }
    }
}

