/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ImplAverageDownSample2_MT {
    public static void down(GrayU8 input, GrayI8 output) {
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
            int indexOut = output.startIndex + y / 2 * output.stride;
            int indexIn0 = input.startIndex + y * input.stride;
            int indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++] & 0xFF;
                total += input.data[indexIn0++] & 0xFF;
                total += input.data[indexIn1++] & 0xFF;
                output.data[indexOut++] = (byte)(((total += input.data[indexIn1++] & 0xFF) + 2) / 4);
            }
        });
        if (maxX != input.width) {
            BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
                int indexOut = output.startIndex + y / 2 * output.stride + output.width - 1;
                int indexIn0 = input.startIndex + y * input.stride + maxX;
                int indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0] & 0xFF;
                output.data[indexOut] = (byte)(((total += input.data[indexIn1] & 0xFF) + 1) / 2);
            });
        }
        if (maxY != input.height) {
            BoofConcurrency.loopFor((int)0, (int)maxX, (int)2, x -> {
                int indexOut = output.startIndex + (output.height - 1) * output.stride + x / 2;
                int indexIn0 = input.startIndex + (input.height - 1) * input.stride + x;
                int total = input.data[indexIn0++] & 0xFF;
                output.data[indexOut++] = (byte)(((total += input.data[indexIn0++] & 0xFF) + 1) / 2);
            });
        }
        if (maxX != input.width && maxY != input.height) {
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(GrayS8 input, GrayI8 output) {
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
            int indexOut = output.startIndex + y / 2 * output.stride;
            int indexIn0 = input.startIndex + y * input.stride;
            int indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut++] = (byte)(((total += input.data[indexIn1++]) + 2) / 4);
            }
        });
        if (maxX != input.width) {
            BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
                int indexOut = output.startIndex + y / 2 * output.stride + output.width - 1;
                int indexIn0 = input.startIndex + y * input.stride + maxX;
                int indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0];
                output.data[indexOut] = (byte)(((total += input.data[indexIn1]) + 1) / 2);
            });
        }
        if (maxY != input.height) {
            BoofConcurrency.loopFor((int)0, (int)maxX, (int)2, x -> {
                int indexOut = output.startIndex + (output.height - 1) * output.stride + x / 2;
                int indexIn0 = input.startIndex + (input.height - 1) * input.stride + x;
                int total = input.data[indexIn0++];
                output.data[indexOut++] = (byte)(((total += input.data[indexIn0++]) + 1) / 2);
            });
        }
        if (maxX != input.width && maxY != input.height) {
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(GrayU16 input, GrayI16 output) {
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
            int indexOut = output.startIndex + y / 2 * output.stride;
            int indexIn0 = input.startIndex + y * input.stride;
            int indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++] & 0xFFFF;
                total += input.data[indexIn0++] & 0xFFFF;
                total += input.data[indexIn1++] & 0xFFFF;
                output.data[indexOut++] = (short)(((total += input.data[indexIn1++] & 0xFFFF) + 2) / 4);
            }
        });
        if (maxX != input.width) {
            BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
                int indexOut = output.startIndex + y / 2 * output.stride + output.width - 1;
                int indexIn0 = input.startIndex + y * input.stride + maxX;
                int indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0] & 0xFFFF;
                output.data[indexOut] = (short)(((total += input.data[indexIn1] & 0xFFFF) + 1) / 2);
            });
        }
        if (maxY != input.height) {
            BoofConcurrency.loopFor((int)0, (int)maxX, (int)2, x -> {
                int indexOut = output.startIndex + (output.height - 1) * output.stride + x / 2;
                int indexIn0 = input.startIndex + (input.height - 1) * input.stride + x;
                int total = input.data[indexIn0++] & 0xFFFF;
                output.data[indexOut++] = (short)(((total += input.data[indexIn0++] & 0xFFFF) + 1) / 2);
            });
        }
        if (maxX != input.width && maxY != input.height) {
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(GrayS16 input, GrayI16 output) {
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
            int indexOut = output.startIndex + y / 2 * output.stride;
            int indexIn0 = input.startIndex + y * input.stride;
            int indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut++] = (short)(((total += input.data[indexIn1++]) + 2) / 4);
            }
        });
        if (maxX != input.width) {
            BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
                int indexOut = output.startIndex + y / 2 * output.stride + output.width - 1;
                int indexIn0 = input.startIndex + y * input.stride + maxX;
                int indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0];
                output.data[indexOut] = (short)(((total += input.data[indexIn1]) + 1) / 2);
            });
        }
        if (maxY != input.height) {
            BoofConcurrency.loopFor((int)0, (int)maxX, (int)2, x -> {
                int indexOut = output.startIndex + (output.height - 1) * output.stride + x / 2;
                int indexIn0 = input.startIndex + (input.height - 1) * input.stride + x;
                int total = input.data[indexIn0++];
                output.data[indexOut++] = (short)(((total += input.data[indexIn0++]) + 1) / 2);
            });
        }
        if (maxX != input.width && maxY != input.height) {
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(GrayS32 input, GrayS32 output) {
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
            int indexOut = output.startIndex + y / 2 * output.stride;
            int indexIn0 = input.startIndex + y * input.stride;
            int indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut++] = ((total += input.data[indexIn1++]) + 2) / 4;
            }
        });
        if (maxX != input.width) {
            BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
                int indexOut = output.startIndex + y / 2 * output.stride + output.width - 1;
                int indexIn0 = input.startIndex + y * input.stride + maxX;
                int indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0];
                output.data[indexOut] = ((total += input.data[indexIn1]) + 1) / 2;
            });
        }
        if (maxY != input.height) {
            BoofConcurrency.loopFor((int)0, (int)maxX, (int)2, x -> {
                int indexOut = output.startIndex + (output.height - 1) * output.stride + x / 2;
                int indexIn0 = input.startIndex + (input.height - 1) * input.stride + x;
                int total = input.data[indexIn0++];
                output.data[indexOut++] = ((total += input.data[indexIn0++]) + 1) / 2;
            });
        }
        if (maxX != input.width && maxY != input.height) {
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(GrayF32 input, GrayF32 output) {
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
            int indexOut = output.startIndex + y / 2 * output.stride;
            int indexIn0 = input.startIndex + y * input.stride;
            int indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                float total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut++] = (total += input.data[indexIn1++]) / 4.0f;
            }
        });
        if (maxX != input.width) {
            BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
                int indexOut = output.startIndex + y / 2 * output.stride + output.width - 1;
                int indexIn0 = input.startIndex + y * input.stride + maxX;
                int indexIn1 = indexIn0 + input.stride;
                float total = input.data[indexIn0];
                output.data[indexOut] = (total += input.data[indexIn1]) / 2.0f;
            });
        }
        if (maxY != input.height) {
            BoofConcurrency.loopFor((int)0, (int)maxX, (int)2, x -> {
                int indexOut = output.startIndex + (output.height - 1) * output.stride + x / 2;
                int indexIn0 = input.startIndex + (input.height - 1) * input.stride + x;
                float total = input.data[indexIn0++];
                output.data[indexOut++] = (total += input.data[indexIn0++]) / 2.0f;
            });
        }
        if (maxX != input.width && maxY != input.height) {
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(GrayF64 input, GrayF64 output) {
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
            int indexOut = output.startIndex + y / 2 * output.stride;
            int indexIn0 = input.startIndex + y * input.stride;
            int indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                double total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut++] = (total += input.data[indexIn1++]) / 4.0;
            }
        });
        if (maxX != input.width) {
            BoofConcurrency.loopFor((int)0, (int)maxY, (int)2, y -> {
                int indexOut = output.startIndex + y / 2 * output.stride + output.width - 1;
                int indexIn0 = input.startIndex + y * input.stride + maxX;
                int indexIn1 = indexIn0 + input.stride;
                double total = input.data[indexIn0];
                output.data[indexOut] = (total += input.data[indexIn1]) / 2.0;
            });
        }
        if (maxY != input.height) {
            BoofConcurrency.loopFor((int)0, (int)maxX, (int)2, x -> {
                int indexOut = output.startIndex + (output.height - 1) * output.stride + x / 2;
                int indexIn0 = input.startIndex + (input.height - 1) * input.stride + x;
                double total = input.data[indexIn0++];
                output.data[indexOut++] = (total += input.data[indexIn0++]) / 2.0;
            });
        }
        if (maxX != input.width && maxY != input.height) {
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }
}

