/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class GImageStatistics {
    public static double maxAbs(ImageBase input) {
        if (input instanceof ImageGray) {
            if (GrayU8.class == input.getClass()) {
                return ImageStatistics.maxAbs((GrayU8)input);
            }
            if (GrayS8.class == input.getClass()) {
                return ImageStatistics.maxAbs((GrayS8)input);
            }
            if (GrayU16.class == input.getClass()) {
                return ImageStatistics.maxAbs((GrayU16)input);
            }
            if (GrayS16.class == input.getClass()) {
                return ImageStatistics.maxAbs((GrayS16)input);
            }
            if (GrayS32.class == input.getClass()) {
                return ImageStatistics.maxAbs((GrayS32)input);
            }
            if (GrayS64.class == input.getClass()) {
                return ImageStatistics.maxAbs((GrayS64)input);
            }
            if (GrayF32.class == input.getClass()) {
                return ImageStatistics.maxAbs((GrayF32)input);
            }
            if (GrayF64.class == input.getClass()) {
                return ImageStatistics.maxAbs((GrayF64)input);
            }
            throw new IllegalArgumentException("Unknown Image Type: " + input.getClass().getSimpleName());
        }
        if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                return ImageStatistics.maxAbs((InterleavedU8)input);
            }
            if (InterleavedS8.class == input.getClass()) {
                return ImageStatistics.maxAbs((InterleavedS8)input);
            }
            if (InterleavedU16.class == input.getClass()) {
                return ImageStatistics.maxAbs((InterleavedU16)input);
            }
            if (InterleavedS16.class == input.getClass()) {
                return ImageStatistics.maxAbs((InterleavedS16)input);
            }
            if (InterleavedS32.class == input.getClass()) {
                return ImageStatistics.maxAbs((InterleavedS32)input);
            }
            if (InterleavedS64.class == input.getClass()) {
                return ImageStatistics.maxAbs((InterleavedS64)input);
            }
            if (InterleavedF32.class == input.getClass()) {
                return ImageStatistics.maxAbs((InterleavedF32)input);
            }
            if (InterleavedF64.class == input.getClass()) {
                return ImageStatistics.maxAbs((InterleavedF64)input);
            }
            throw new IllegalArgumentException("Unknown Image Type: " + input.getClass().getSimpleName());
        }
        if (input instanceof Planar) {
            Planar pl = (Planar)input;
            int N = pl.getNumBands();
            if (N == 0) {
                throw new IllegalArgumentException("Must have at least one band");
            }
            double result = GImageStatistics.maxAbs((ImageBase)pl.bands[0]);
            for (int i = 1; i < N; ++i) {
                result = Math.max(result, GImageStatistics.maxAbs((ImageBase)pl.bands[i]));
            }
            return result;
        }
        throw new IllegalArgumentException("Image type not yet supported " + input.getClass().getSimpleName());
    }

    public static double max(ImageBase input) {
        if (input instanceof ImageGray) {
            if (GrayU8.class == input.getClass()) {
                return ImageStatistics.max((GrayU8)input);
            }
            if (GrayS8.class == input.getClass()) {
                return ImageStatistics.max((GrayS8)input);
            }
            if (GrayU16.class == input.getClass()) {
                return ImageStatistics.max((GrayU16)input);
            }
            if (GrayS16.class == input.getClass()) {
                return ImageStatistics.max((GrayS16)input);
            }
            if (GrayS32.class == input.getClass()) {
                return ImageStatistics.max((GrayS32)input);
            }
            if (GrayS64.class == input.getClass()) {
                return ImageStatistics.max((GrayS64)input);
            }
            if (GrayF32.class == input.getClass()) {
                return ImageStatistics.max((GrayF32)input);
            }
            if (GrayF64.class == input.getClass()) {
                return ImageStatistics.max((GrayF64)input);
            }
            throw new IllegalArgumentException("Unknown Image Type");
        }
        if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                return ImageStatistics.max((InterleavedU8)input);
            }
            if (InterleavedS8.class == input.getClass()) {
                return ImageStatistics.max((InterleavedS8)input);
            }
            if (InterleavedU16.class == input.getClass()) {
                return ImageStatistics.max((InterleavedU16)input);
            }
            if (InterleavedS16.class == input.getClass()) {
                return ImageStatistics.max((InterleavedS16)input);
            }
            if (InterleavedS32.class == input.getClass()) {
                return ImageStatistics.max((InterleavedS32)input);
            }
            if (InterleavedS64.class == input.getClass()) {
                return ImageStatistics.max((InterleavedS64)input);
            }
            if (InterleavedF32.class == input.getClass()) {
                return ImageStatistics.max((InterleavedF32)input);
            }
            if (InterleavedF64.class == input.getClass()) {
                return ImageStatistics.max((InterleavedF64)input);
            }
            throw new IllegalArgumentException("Unknown Image Type");
        }
        if (input instanceof Planar) {
            Planar pl = (Planar)input;
            int N = pl.getNumBands();
            if (N == 0) {
                throw new IllegalArgumentException("Must have at least one band");
            }
            double result = GImageStatistics.max((ImageBase)pl.bands[0]);
            for (int i = 1; i < N; ++i) {
                result = Math.max(result, GImageStatistics.max((ImageBase)pl.bands[i]));
            }
            return result;
        }
        throw new IllegalArgumentException("Image type not yet supported " + input.getClass().getSimpleName());
    }

    public static double min(ImageBase input) {
        if (input instanceof ImageGray) {
            if (GrayU8.class == input.getClass()) {
                return ImageStatistics.min((GrayU8)input);
            }
            if (GrayS8.class == input.getClass()) {
                return ImageStatistics.min((GrayS8)input);
            }
            if (GrayU16.class == input.getClass()) {
                return ImageStatistics.min((GrayU16)input);
            }
            if (GrayS16.class == input.getClass()) {
                return ImageStatistics.min((GrayS16)input);
            }
            if (GrayS32.class == input.getClass()) {
                return ImageStatistics.min((GrayS32)input);
            }
            if (GrayS64.class == input.getClass()) {
                return ImageStatistics.min((GrayS64)input);
            }
            if (GrayF32.class == input.getClass()) {
                return ImageStatistics.min((GrayF32)input);
            }
            if (GrayF64.class == input.getClass()) {
                return ImageStatistics.min((GrayF64)input);
            }
            throw new IllegalArgumentException("Unknown Image Type: " + input.getClass().getSimpleName());
        }
        if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                return ImageStatistics.min((InterleavedU8)input);
            }
            if (InterleavedS8.class == input.getClass()) {
                return ImageStatistics.min((InterleavedS8)input);
            }
            if (InterleavedU16.class == input.getClass()) {
                return ImageStatistics.min((InterleavedU16)input);
            }
            if (InterleavedS16.class == input.getClass()) {
                return ImageStatistics.min((InterleavedS16)input);
            }
            if (InterleavedS32.class == input.getClass()) {
                return ImageStatistics.min((InterleavedS32)input);
            }
            if (InterleavedS64.class == input.getClass()) {
                return ImageStatistics.min((InterleavedS64)input);
            }
            if (InterleavedF32.class == input.getClass()) {
                return ImageStatistics.min((InterleavedF32)input);
            }
            if (InterleavedF64.class == input.getClass()) {
                return ImageStatistics.min((InterleavedF64)input);
            }
            throw new IllegalArgumentException("Unknown Image Type: " + input.getClass().getSimpleName());
        }
        if (input instanceof Planar) {
            Planar pl = (Planar)input;
            int N = pl.getNumBands();
            if (N == 0) {
                throw new IllegalArgumentException("Must have at least one band");
            }
            double result = GImageStatistics.min((ImageBase)pl.bands[0]);
            for (int i = 1; i < N; ++i) {
                result = Math.min(result, GImageStatistics.min((ImageBase)pl.bands[i]));
            }
            return result;
        }
        throw new IllegalArgumentException("Image type not yet supported " + input.getClass().getSimpleName());
    }

    public static double sum(ImageBase input) {
        if (input instanceof ImageGray) {
            if (GrayU8.class == input.getClass()) {
                return ImageStatistics.sum((GrayU8)input);
            }
            if (GrayS8.class == input.getClass()) {
                return ImageStatistics.sum((GrayS8)input);
            }
            if (GrayU16.class == input.getClass()) {
                return ImageStatistics.sum((GrayU16)input);
            }
            if (GrayS16.class == input.getClass()) {
                return ImageStatistics.sum((GrayS16)input);
            }
            if (GrayS32.class == input.getClass()) {
                return ImageStatistics.sum((GrayS32)input);
            }
            if (GrayS64.class == input.getClass()) {
                return ImageStatistics.sum((GrayS64)input);
            }
            if (GrayF32.class == input.getClass()) {
                return ImageStatistics.sum((GrayF32)input);
            }
            if (GrayF64.class == input.getClass()) {
                return ImageStatistics.sum((GrayF64)input);
            }
            throw new IllegalArgumentException("Unknown image Type");
        }
        if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                return ImageStatistics.sum((InterleavedU8)input);
            }
            if (InterleavedS8.class == input.getClass()) {
                return ImageStatistics.sum((InterleavedS8)input);
            }
            if (InterleavedU16.class == input.getClass()) {
                return ImageStatistics.sum((InterleavedU16)input);
            }
            if (InterleavedS16.class == input.getClass()) {
                return ImageStatistics.sum((InterleavedS16)input);
            }
            if (InterleavedS32.class == input.getClass()) {
                return ImageStatistics.sum((InterleavedS32)input);
            }
            if (InterleavedS64.class == input.getClass()) {
                return ImageStatistics.sum((InterleavedS64)input);
            }
            if (InterleavedF32.class == input.getClass()) {
                return ImageStatistics.sum((InterleavedF32)input);
            }
            if (InterleavedF64.class == input.getClass()) {
                return ImageStatistics.sum((InterleavedF64)input);
            }
            throw new IllegalArgumentException("Unknown image Type");
        }
        if (input instanceof Planar) {
            double sum = 0.0;
            Planar in = (Planar)input;
            for (int i = 0; i < in.getNumBands(); ++i) {
                sum += GImageStatistics.sum((ImageBase)in.getBand(i));
            }
            return sum;
        }
        throw new IllegalArgumentException("Image type not yet supported " + input.getClass().getSimpleName());
    }

    public static double mean(ImageBase input) {
        if (input instanceof ImageGray) {
            if (GrayU8.class == input.getClass()) {
                return ImageStatistics.mean((GrayU8)input);
            }
            if (GrayS8.class == input.getClass()) {
                return ImageStatistics.mean((GrayS8)input);
            }
            if (GrayU16.class == input.getClass()) {
                return ImageStatistics.mean((GrayU16)input);
            }
            if (GrayS16.class == input.getClass()) {
                return ImageStatistics.mean((GrayS16)input);
            }
            if (GrayS32.class == input.getClass()) {
                return ImageStatistics.mean((GrayS32)input);
            }
            if (GrayS64.class == input.getClass()) {
                return ImageStatistics.mean((GrayS64)input);
            }
            if (GrayF32.class == input.getClass()) {
                return ImageStatistics.mean((GrayF32)input);
            }
            if (GrayF64.class == input.getClass()) {
                return ImageStatistics.mean((GrayF64)input);
            }
            throw new IllegalArgumentException("Unknown image Type");
        }
        if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                return ImageStatistics.mean((InterleavedU8)input);
            }
            if (InterleavedS8.class == input.getClass()) {
                return ImageStatistics.mean((InterleavedS8)input);
            }
            if (InterleavedU16.class == input.getClass()) {
                return ImageStatistics.mean((InterleavedU16)input);
            }
            if (InterleavedS16.class == input.getClass()) {
                return ImageStatistics.mean((InterleavedS16)input);
            }
            if (InterleavedS32.class == input.getClass()) {
                return ImageStatistics.mean((InterleavedS32)input);
            }
            if (InterleavedS64.class == input.getClass()) {
                return ImageStatistics.mean((InterleavedS64)input);
            }
            if (InterleavedF32.class == input.getClass()) {
                return ImageStatistics.mean((InterleavedF32)input);
            }
            if (InterleavedF64.class == input.getClass()) {
                return ImageStatistics.mean((InterleavedF64)input);
            }
            throw new IllegalArgumentException("Unknown image Type");
        }
        if (input instanceof Planar) {
            double mean = 0.0;
            Planar in = (Planar)input;
            for (int i = 0; i < in.getNumBands(); ++i) {
                mean += GImageStatistics.mean((ImageBase)in.getBand(i));
            }
            return mean / (double)in.getNumBands();
        }
        throw new IllegalArgumentException("Image type not yet supported " + input.getClass().getSimpleName());
    }

    public static <T extends ImageGray<T>> double variance(T input, double mean) {
        if (GrayU8.class == input.getClass()) {
            return ImageStatistics.variance((GrayU8)input, mean);
        }
        if (GrayS8.class == input.getClass()) {
            return ImageStatistics.variance((GrayS8)input, mean);
        }
        if (GrayU16.class == input.getClass()) {
            return ImageStatistics.variance((GrayU16)input, mean);
        }
        if (GrayS16.class == input.getClass()) {
            return ImageStatistics.variance((GrayS16)input, mean);
        }
        if (GrayS32.class == input.getClass()) {
            return ImageStatistics.variance((GrayS32)input, mean);
        }
        if (GrayS64.class == input.getClass()) {
            return ImageStatistics.variance((GrayS64)input, mean);
        }
        if (GrayF32.class == input.getClass()) {
            return ImageStatistics.variance((GrayF32)input, (float)mean);
        }
        if (GrayF64.class == input.getClass()) {
            return ImageStatistics.variance((GrayF64)input, mean);
        }
        throw new IllegalArgumentException("Unknown image Type");
    }

    public static <T extends ImageBase<T>> double meanDiffSq(T inputA, T inputB) {
        if (inputA instanceof ImageGray) {
            if (GrayU8.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((GrayU8)inputA, (GrayU8)inputB);
            }
            if (GrayS8.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((GrayS8)inputA, (GrayS8)inputB);
            }
            if (GrayU16.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((GrayU16)inputA, (GrayU16)inputB);
            }
            if (GrayS16.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((GrayS16)inputA, (GrayS16)inputB);
            }
            if (GrayS32.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((GrayS32)inputA, (GrayS32)inputB);
            }
            if (GrayS64.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((GrayS64)inputA, (GrayS64)inputB);
            }
            if (GrayF32.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((GrayF32)inputA, (GrayF32)inputB);
            }
            if (GrayF64.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((GrayF64)inputA, (GrayF64)inputB);
            }
            throw new IllegalArgumentException("Unknown image Type");
        }
        if (inputA instanceof ImageInterleaved) {
            if (InterleavedU8.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((InterleavedU8)inputA, (InterleavedU8)inputB);
            }
            if (InterleavedS8.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((InterleavedS8)inputA, (InterleavedS8)inputB);
            }
            if (InterleavedU16.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((InterleavedU16)inputA, (InterleavedU16)inputB);
            }
            if (InterleavedS16.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((InterleavedS16)inputA, (InterleavedS16)inputB);
            }
            if (InterleavedS32.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((InterleavedS32)inputA, (InterleavedS32)inputB);
            }
            if (InterleavedS64.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((InterleavedS64)inputA, (InterleavedS64)inputB);
            }
            if (InterleavedF32.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((InterleavedF32)inputA, (InterleavedF32)inputB);
            }
            if (InterleavedF64.class == inputA.getClass()) {
                return ImageStatistics.meanDiffSq((InterleavedF64)inputA, (InterleavedF64)inputB);
            }
            throw new IllegalArgumentException("Unknown image Type");
        }
        if (inputA instanceof Planar) {
            double mean = 0.0;
            Planar inA = (Planar)inputA;
            Planar inB = (Planar)inputB;
            for (int i = 0; i < inA.getNumBands(); ++i) {
                mean += GImageStatistics.meanDiffSq(inA.getBand(i), inB.getBand(i));
            }
            return mean / (double)inA.getNumBands();
        }
        throw new IllegalArgumentException("Image type not yet supported " + inputA.getClass().getSimpleName());
    }

    public static <T extends ImageBase<T>> double meanDiffAbs(T inputA, T inputB) {
        if (inputA instanceof ImageGray) {
            if (GrayU8.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((GrayU8)inputA, (GrayU8)inputB);
            }
            if (GrayS8.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((GrayS8)inputA, (GrayS8)inputB);
            }
            if (GrayU16.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((GrayU16)inputA, (GrayU16)inputB);
            }
            if (GrayS16.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((GrayS16)inputA, (GrayS16)inputB);
            }
            if (GrayS32.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((GrayS32)inputA, (GrayS32)inputB);
            }
            if (GrayS64.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((GrayS64)inputA, (GrayS64)inputB);
            }
            if (GrayF32.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((GrayF32)inputA, (GrayF32)inputB);
            }
            if (GrayF64.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((GrayF64)inputA, (GrayF64)inputB);
            }
            throw new IllegalArgumentException("Unknown image Type");
        }
        if (inputA instanceof ImageInterleaved) {
            if (InterleavedU8.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((InterleavedU8)inputA, (InterleavedU8)inputB);
            }
            if (InterleavedS8.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((InterleavedS8)inputA, (InterleavedS8)inputB);
            }
            if (InterleavedU16.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((InterleavedU16)inputA, (InterleavedU16)inputB);
            }
            if (InterleavedS16.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((InterleavedS16)inputA, (InterleavedS16)inputB);
            }
            if (InterleavedS32.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((InterleavedS32)inputA, (InterleavedS32)inputB);
            }
            if (InterleavedS64.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((InterleavedS64)inputA, (InterleavedS64)inputB);
            }
            if (InterleavedF32.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((InterleavedF32)inputA, (InterleavedF32)inputB);
            }
            if (InterleavedF64.class == inputA.getClass()) {
                return ImageStatistics.meanDiffAbs((InterleavedF64)inputA, (InterleavedF64)inputB);
            }
            throw new IllegalArgumentException("Unknown image Type");
        }
        if (inputA instanceof Planar) {
            double mean = 0.0;
            Planar inA = (Planar)inputA;
            Planar inB = (Planar)inputB;
            for (int i = 0; i < inA.getNumBands(); ++i) {
                mean += GImageStatistics.meanDiffAbs(inA.getBand(i), inB.getBand(i));
            }
            return mean / (double)inA.getNumBands();
        }
        throw new IllegalArgumentException("Image type not yet supported " + inputA.getClass().getSimpleName());
    }

    public static void histogram(ImageGray input, double minValue, int[] histogram) {
        if (GrayU8.class == input.getClass()) {
            ImageStatistics.histogram((GrayU8)input, (int)minValue, histogram);
        } else if (GrayS8.class == input.getClass()) {
            ImageStatistics.histogram((GrayS8)input, (int)minValue, histogram);
        } else if (GrayU16.class == input.getClass()) {
            ImageStatistics.histogram((GrayU16)input, (int)minValue, histogram);
        } else if (GrayS16.class == input.getClass()) {
            ImageStatistics.histogram((GrayS16)input, (int)minValue, histogram);
        } else if (GrayS32.class == input.getClass()) {
            ImageStatistics.histogram((GrayS32)input, (int)minValue, histogram);
        } else if (GrayS64.class == input.getClass()) {
            ImageStatistics.histogram((GrayS64)input, (long)minValue, histogram);
        } else if (GrayF32.class == input.getClass()) {
            ImageStatistics.histogram((GrayF32)input, (float)minValue, histogram);
        } else if (GrayF64.class == input.getClass()) {
            ImageStatistics.histogram((GrayF64)input, minValue, histogram);
        } else {
            throw new IllegalArgumentException("Unknown image Type");
        }
    }
}

