/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import java.util.Arrays;

public class ImplImageStatistics {
    public static int minU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbsU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSqU(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFF) - (dataB[indexB] & 0xFF);
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbsU(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFF) - (dataB[indexB] & 0xFF);
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayU8 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFF;
            }
        }
        return total;
    }

    public static int sum(InterleavedU8 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFF;
            }
        }
        return total;
    }

    public static double variance(GrayU8 img, double mean) {
        double total = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)(img.data[index] & 0xFF) - mean;
                total += d * d;
            }
        }
        return total / (double)(img.width * img.height);
    }

    public static void histogram(GrayU8 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int[] h = histogram;
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int end = index + input.width;
            while (index < end) {
                int n = (input.data[index++] & 0xFF) - minValue;
                h[n] = h[n] + 1;
            }
        }
    }

    public static int min(byte[] array, int startIndex, int rows, int columns, int stride) {
        byte output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                byte v = array[index];
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int max(byte[] array, int startIndex, int rows, int columns, int stride) {
        byte output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                byte v = array[index];
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbs(byte[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayS8 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static int sum(InterleavedS8 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double variance(GrayS8 img, double mean) {
        double total = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                total += d * d;
            }
        }
        return total / (double)(img.width * img.height);
    }

    public static void histogram(GrayS8 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int[] h = histogram;
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int end = index + input.width;
            while (index < end) {
                int n = input.data[index++] - minValue;
                h[n] = h[n] + 1;
            }
        }
    }

    public static int minU(short[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFFFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxU(short[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFFFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbsU(short[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFFFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSqU(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFFFF) - (dataB[indexB] & 0xFFFF);
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbsU(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFFFF) - (dataB[indexB] & 0xFFFF);
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayU16 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFFFF;
            }
        }
        return total;
    }

    public static int sum(InterleavedU16 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFFFF;
            }
        }
        return total;
    }

    public static double variance(GrayU16 img, double mean) {
        double total = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)(img.data[index] & 0xFFFF) - mean;
                total += d * d;
            }
        }
        return total / (double)(img.width * img.height);
    }

    public static void histogram(GrayU16 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int[] h = histogram;
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int end = index + input.width;
            while (index < end) {
                int n = (input.data[index++] & 0xFFFF) - minValue;
                h[n] = h[n] + 1;
            }
        }
    }

    public static int min(short[] array, int startIndex, int rows, int columns, int stride) {
        short output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                short v = array[index];
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int max(short[] array, int startIndex, int rows, int columns, int stride) {
        short output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                short v = array[index];
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbs(short[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayS16 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static int sum(InterleavedS16 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double variance(GrayS16 img, double mean) {
        double total = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                total += d * d;
            }
        }
        return total / (double)(img.width * img.height);
    }

    public static void histogram(GrayS16 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int[] h = histogram;
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int end = index + input.width;
            while (index < end) {
                int n = input.data[index++] - minValue;
                h[n] = h[n] + 1;
            }
        }
    }

    public static int min(int[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int max(int[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbs(int[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(int[] dataA, int startIndexA, int strideA, int[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(int[] dataA, int startIndexA, int strideA, int[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayS32 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static int sum(InterleavedS32 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double variance(GrayS32 img, double mean) {
        double total = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                total += d * d;
            }
        }
        return total / (double)(img.width * img.height);
    }

    public static void histogram(GrayS32 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int[] h = histogram;
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int end = index + input.width;
            while (index < end) {
                int n = input.data[index++] - minValue;
                h[n] = h[n] + 1;
            }
        }
    }

    public static long min(long[] array, int startIndex, int rows, int columns, int stride) {
        long output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = array[index];
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static long max(long[] array, int startIndex, int rows, int columns, int stride) {
        long output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = array[index];
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static long maxAbs(long[] array, int startIndex, int rows, int columns, int stride) {
        long output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(long[] dataA, int startIndexA, int strideA, long[] dataB, int startIndexB, int strideB, int rows, int columns) {
        long total = 0L;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                long difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(long[] dataA, int startIndexA, int strideA, long[] dataB, int startIndexB, int strideB, int rows, int columns) {
        long total = 0L;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                long difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static long sum(GrayS64 img) {
        int rows = img.height;
        int columns = img.width;
        long total = 0L;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static long sum(InterleavedS64 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        long total = 0L;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double variance(GrayS64 img, double mean) {
        double total = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                total += d * d;
            }
        }
        return total / (double)(img.width * img.height);
    }

    public static void histogram(GrayS64 input, long minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int[] h = histogram;
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int end = index + input.width;
            while (index < end) {
                int n = (int)(input.data[index++] - minValue);
                h[n] = h[n] + 1;
            }
        }
    }

    public static float min(float[] array, int startIndex, int rows, int columns, int stride) {
        float output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = array[index];
                if (!(v < output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static float max(float[] array, int startIndex, int rows, int columns, int stride) {
        float output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = array[index];
                if (!(v > output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static float maxAbs(float[] array, int startIndex, int rows, int columns, int stride) {
        float output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = Math.abs(array[index]);
                if (!(v > output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(float[] dataA, int startIndexA, int strideA, float[] dataB, int startIndexB, int strideB, int rows, int columns) {
        float total = 0.0f;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                float difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(float[] dataA, int startIndexA, int strideA, float[] dataB, int startIndexB, int strideB, int rows, int columns) {
        float total = 0.0f;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                float difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static float sum(GrayF32 img) {
        int rows = img.height;
        int columns = img.width;
        float total = 0.0f;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static float sum(InterleavedF32 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        float total = 0.0f;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static float variance(GrayF32 img, float mean) {
        float total = 0.0f;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                float d = img.data[index] - mean;
                total += d * d;
            }
        }
        return total / (float)(img.width * img.height);
    }

    public static void histogram(GrayF32 input, float minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int[] h = histogram;
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int end = index + input.width;
            while (index < end) {
                int n = (int)(input.data[index++] - minValue);
                h[n] = h[n] + 1;
            }
        }
    }

    public static double min(double[] array, int startIndex, int rows, int columns, int stride) {
        double output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = array[index];
                if (!(v < output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static double max(double[] array, int startIndex, int rows, int columns, int stride) {
        double output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = array[index];
                if (!(v > output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static double maxAbs(double[] array, int startIndex, int rows, int columns, int stride) {
        double output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = Math.abs(array[index]);
                if (!(v > output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(double[] dataA, int startIndexA, int strideA, double[] dataB, int startIndexB, int strideB, int rows, int columns) {
        double total = 0.0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                double difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return total / (double)(rows * columns);
    }

    public static double meanDiffAbs(double[] dataA, int startIndexA, int strideA, double[] dataB, int startIndexB, int strideB, int rows, int columns) {
        double total = 0.0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                double difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return total / (double)(rows * columns);
    }

    public static double sum(GrayF64 img) {
        int rows = img.height;
        int columns = img.width;
        double total = 0.0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double sum(InterleavedF64 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        double total = 0.0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double variance(GrayF64 img, double mean) {
        double total = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = img.data[index] - mean;
                total += d * d;
            }
        }
        return total / (double)(img.width * img.height);
    }

    public static void histogram(GrayF64 input, double minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int[] h = histogram;
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int end = index + input.width;
            while (index < end) {
                int n = (int)(input.data[index++] - minValue);
                h[n] = h[n] + 1;
            }
        }
    }
}

