/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.graph;

import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class FeatureGraph2D {
    public FastQueue<Node> nodes = new FastQueue(Node.class, true);
    public FastQueue<Edge> edges = new FastQueue(Edge.class, true);

    public void reset() {
        this.nodes.reset();
        this.edges.reset();
    }

    public void connect(int src, int dst) {
        Node n = (Node)((Object)this.nodes.get(src));
        int idx = n.connection(dst);
        if (idx == -1) {
            Edge e = (Edge)this.edges.grow();
            e.src = src;
            e.dst = dst;
            n.edges.add(e);
            ((Node)((Object)this.nodes.get((int)dst))).edges.add(e);
        }
    }

    public static class Edge {
        public int src;
        public int dst;

        public void reset() {
            this.src = -1;
            this.dst = -1;
        }

        public boolean isConnected(int idx) {
            return this.src == idx || this.dst == idx;
        }
    }

    public static class Node
    extends Point2D_F64 {
        public int index;
        public List<Edge> edges = new ArrayList<Edge>();

        public int connection(int idx) {
            for (int i = 0; i < this.edges.size(); ++i) {
                Edge e = this.edges.get(i);
                if (e.src != idx && e.dst != idx) continue;
                return i;
            }
            return -1;
        }

        public void reset() {
            this.index = -1;
            this.x = Double.NaN;
            this.y = Double.NaN;
            this.edges.clear();
        }
    }
}

