/*
 * Copyright (c) 2011-2019, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.alg.misc.impl;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.border.ImageBorder_S64;
import boofcv.struct.image.*;

import javax.annotation.Generated;

/**
 * Implementations of functions for {@link ImageMiscOps}
 *
 * <p>
 * DO NOT MODIFY. This code was automatically generated by GenerateImplImageMiscOps.
 * <p>
 *
 * @author Peter Abeles
 */
@Generated("boofcv.alg.misc.impl.GenerateImplImageMiscOps")
public class ImplImageMiscOps {

	public static <T extends GrayI8<T>>
	void growBorder(T src , ImageBorder_S32<T> border, int borderX0, int borderY0, int borderX1, int borderY1 , T dst )
	{
		dst.reshape(src.width+borderX0+borderX1, src.height+borderY0+borderY1);
		border.setImage(src);

		// Copy src into the inner portion of dst
		ImageMiscOps.copy(0,0,borderX0,borderY0,src.width,src.height,src,dst);

		// Top border
		for (int y = 0; y < borderY0; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = (byte)border.get(x-borderX0,y-borderY0);
			}
		}
		// Bottom border
		for (int y = 0; y < borderY1; y++) {
			int idxDst = dst.startIndex + (dst.height-borderY1+y)*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = (byte)border.get(x-borderX0,src.height+y);
			}
		}
		// Left and right border
		for (int y = borderY0; y < dst.height-borderY1; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < borderX0; x++) {
				dst.data[idxDst++] = (byte)border.get(x-borderX0,y-borderY0);
			}
			idxDst = dst.startIndex + y*dst.stride+src.width+borderX0;
			for (int x = 0; x < borderX1; x++) {
				dst.data[idxDst++] = (byte)border.get(src.width+x,y-borderY0);
			}
		}
	}

	public static <T extends GrayI16<T>>
	void growBorder(T src , ImageBorder_S32<T> border, int borderX0, int borderY0, int borderX1, int borderY1 , T dst )
	{
		dst.reshape(src.width+borderX0+borderX1, src.height+borderY0+borderY1);
		border.setImage(src);

		// Copy src into the inner portion of dst
		ImageMiscOps.copy(0,0,borderX0,borderY0,src.width,src.height,src,dst);

		// Top border
		for (int y = 0; y < borderY0; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = (short)border.get(x-borderX0,y-borderY0);
			}
		}
		// Bottom border
		for (int y = 0; y < borderY1; y++) {
			int idxDst = dst.startIndex + (dst.height-borderY1+y)*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = (short)border.get(x-borderX0,src.height+y);
			}
		}
		// Left and right border
		for (int y = borderY0; y < dst.height-borderY1; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < borderX0; x++) {
				dst.data[idxDst++] = (short)border.get(x-borderX0,y-borderY0);
			}
			idxDst = dst.startIndex + y*dst.stride+src.width+borderX0;
			for (int x = 0; x < borderX1; x++) {
				dst.data[idxDst++] = (short)border.get(src.width+x,y-borderY0);
			}
		}
	}

	public static void growBorder(GrayS32 src , ImageBorder_S32 border, int borderX0, int borderY0, int borderX1, int borderY1 , GrayS32 dst )
	{
		dst.reshape(src.width+borderX0+borderX1, src.height+borderY0+borderY1);
		border.setImage(src);

		// Copy src into the inner portion of dst
		ImageMiscOps.copy(0,0,borderX0,borderY0,src.width,src.height,src,dst);

		// Top border
		for (int y = 0; y < borderY0; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,y-borderY0);
			}
		}
		// Bottom border
		for (int y = 0; y < borderY1; y++) {
			int idxDst = dst.startIndex + (dst.height-borderY1+y)*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,src.height+y);
			}
		}
		// Left and right border
		for (int y = borderY0; y < dst.height-borderY1; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < borderX0; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,y-borderY0);
			}
			idxDst = dst.startIndex + y*dst.stride+src.width+borderX0;
			for (int x = 0; x < borderX1; x++) {
				dst.data[idxDst++] = border.get(src.width+x,y-borderY0);
			}
		}
	}

	public static void growBorder(GrayS64 src , ImageBorder_S64 border, int borderX0, int borderY0, int borderX1, int borderY1 , GrayS64 dst )
	{
		dst.reshape(src.width+borderX0+borderX1, src.height+borderY0+borderY1);
		border.setImage(src);

		// Copy src into the inner portion of dst
		ImageMiscOps.copy(0,0,borderX0,borderY0,src.width,src.height,src,dst);

		// Top border
		for (int y = 0; y < borderY0; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,y-borderY0);
			}
		}
		// Bottom border
		for (int y = 0; y < borderY1; y++) {
			int idxDst = dst.startIndex + (dst.height-borderY1+y)*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,src.height+y);
			}
		}
		// Left and right border
		for (int y = borderY0; y < dst.height-borderY1; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < borderX0; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,y-borderY0);
			}
			idxDst = dst.startIndex + y*dst.stride+src.width+borderX0;
			for (int x = 0; x < borderX1; x++) {
				dst.data[idxDst++] = border.get(src.width+x,y-borderY0);
			}
		}
	}

	public static void growBorder(GrayF32 src , ImageBorder_F32 border, int borderX0, int borderY0, int borderX1, int borderY1 , GrayF32 dst )
	{
		dst.reshape(src.width+borderX0+borderX1, src.height+borderY0+borderY1);
		border.setImage(src);

		// Copy src into the inner portion of dst
		ImageMiscOps.copy(0,0,borderX0,borderY0,src.width,src.height,src,dst);

		// Top border
		for (int y = 0; y < borderY0; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,y-borderY0);
			}
		}
		// Bottom border
		for (int y = 0; y < borderY1; y++) {
			int idxDst = dst.startIndex + (dst.height-borderY1+y)*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,src.height+y);
			}
		}
		// Left and right border
		for (int y = borderY0; y < dst.height-borderY1; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < borderX0; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,y-borderY0);
			}
			idxDst = dst.startIndex + y*dst.stride+src.width+borderX0;
			for (int x = 0; x < borderX1; x++) {
				dst.data[idxDst++] = border.get(src.width+x,y-borderY0);
			}
		}
	}

	public static void growBorder(GrayF64 src , ImageBorder_F64 border, int borderX0, int borderY0, int borderX1, int borderY1 , GrayF64 dst )
	{
		dst.reshape(src.width+borderX0+borderX1, src.height+borderY0+borderY1);
		border.setImage(src);

		// Copy src into the inner portion of dst
		ImageMiscOps.copy(0,0,borderX0,borderY0,src.width,src.height,src,dst);

		// Top border
		for (int y = 0; y < borderY0; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,y-borderY0);
			}
		}
		// Bottom border
		for (int y = 0; y < borderY1; y++) {
			int idxDst = dst.startIndex + (dst.height-borderY1+y)*dst.stride;
			for (int x = 0; x < dst.width; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,src.height+y);
			}
		}
		// Left and right border
		for (int y = borderY0; y < dst.height-borderY1; y++) {
			int idxDst = dst.startIndex + y*dst.stride;
			for (int x = 0; x < borderX0; x++) {
				dst.data[idxDst++] = border.get(x-borderX0,y-borderY0);
			}
			idxDst = dst.startIndex + y*dst.stride+src.width+borderX0;
			for (int x = 0; x < borderX1; x++) {
				dst.data[idxDst++] = border.get(src.width+x,y-borderY0);
			}
		}
	}

}
