/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.distort;

import boofcv.abst.distort.PointDeformKeyPoints;
import boofcv.alg.distort.mls.ImageDeformPointMLS_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;

public class PointDeform_MLS
implements PointDeformKeyPoints {
    ImageDeformPointMLS_F32 alg;
    int rows;
    int cols;

    public PointDeform_MLS(ImageDeformPointMLS_F32 alg, int rows, int cols) {
        this.alg = alg;
        this.rows = rows;
        this.cols = cols;
    }

    public void compute(float x, float y, Point2D_F32 out) {
        this.alg.compute(x, y, out);
    }

    public PointDeform_MLS copyConcurrent() {
        return new PointDeform_MLS(this.alg.copyConcurrent(), this.rows, this.cols);
    }

    @Override
    public void setImageShape(int width, int height) {
        this.alg.configure(width, height, this.rows, this.cols);
    }

    @Override
    public void setSource(List<Point2D_F32> locations) {
        this.alg.reset();
        for (int i = 0; i < locations.size(); ++i) {
            Point2D_F32 p = locations.get(i);
            this.alg.addControl(p.x, p.y);
        }
        this.alg.fixateUndistorted();
    }

    @Override
    public void setDestination(List<Point2D_F32> locations) {
        for (int i = 0; i < locations.size(); ++i) {
            Point2D_F32 p = locations.get(i);
            this.alg.setDistorted(i, p.x, p.y);
        }
        this.alg.fixateDistorted();
    }

    @Override
    public void setSource(int which, float x, float y) {
        this.alg.setUndistorted(which, x, y);
        this.alg.fixateUndistorted();
    }

    @Override
    public void setDestination(int which, float x, float y) {
        this.alg.setDistorted(which, x, y);
        this.alg.fixateDistorted();
    }

    public ImageDeformPointMLS_F32 getAlgorithm() {
        return this.alg;
    }
}

