/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.filter.convolve.GConvolveImageOps;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class ImageGradient_Gaussian<I extends ImageGray<I>, D extends ImageGray<D>>
implements ImageGradient<I, D> {
    private BorderType borderType = BorderType.EXTENDED;
    ImageBorder border;
    private I storage;
    private Class<D> derivType;
    Kernel1D kernelBlur;
    Kernel1D kernelDeriv;
    Class<I> imageType = this.imageType;

    public ImageGradient_Gaussian(int radius, Class<I> inputType, Class<D> derivType) {
        this(FactoryKernelGaussian.sigmaForRadius(radius, 0), radius, inputType, derivType);
    }

    public ImageGradient_Gaussian(double sigma, int radius, Class<I> inputType, Class<D> derivType) {
        this.derivType = derivType;
        if (radius <= 0) {
            radius = FactoryKernelGaussian.radiusForSigma(sigma, 1);
        } else if (sigma <= 0.0) {
            sigma = FactoryKernelGaussian.sigmaForRadius(radius, 1);
        }
        this.kernelBlur = FactoryKernelGaussian.gaussian1D(inputType, sigma, radius);
        this.kernelDeriv = FactoryKernelGaussian.derivativeI(inputType, 1, sigma, radius);
        this.border = FactoryImageBorder.single(this.borderType, derivType);
    }

    @Override
    public void process(I inputImage, D derivX, D derivY) {
        if (this.storage == null) {
            this.storage = (ImageGray)inputImage.createNew(((ImageGray)inputImage).width, ((ImageGray)inputImage).height);
        } else {
            this.storage.reshape(((ImageGray)inputImage).width, ((ImageGray)inputImage).height);
        }
        GConvolveImageOps.verticalNormalized(this.kernelBlur, inputImage, this.storage);
        GConvolveImageOps.horizontal(this.kernelDeriv, this.storage, derivX, this.border);
        GConvolveImageOps.horizontalNormalized(this.kernelBlur, inputImage, this.storage);
        GConvolveImageOps.vertical(this.kernelDeriv, this.storage, derivY, this.border);
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderType = type;
        this.border = FactoryImageBorder.single(this.borderType, this.derivType);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderType;
    }

    @Override
    public int getBorder() {
        return 0;
    }

    @Override
    public ImageType<I> getInputType() {
        return ImageType.single(this.imageType);
    }

    @Override
    public ImageType<D> getDerivativeType() {
        return ImageType.single(this.derivType);
    }
}

