/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F32;

public abstract class ImageDistortBasic<Input extends ImageBase<Input>, Output extends ImageBase<Output>, Interpolate extends InterpolatePixel<Input>>
implements ImageDistort<Input, Output> {
    protected PixelTransform<Point2D_F32> dstToSrc;
    protected Interpolate interp;
    protected int x0;
    protected int y0;
    protected int x1;
    protected int y1;
    protected boolean renderAll = true;
    protected Input srcImg;
    protected Output dstImg;

    public ImageDistortBasic(Interpolate interp) {
        this.interp = interp;
    }

    @Override
    public void setModel(PixelTransform<Point2D_F32> dstToSrc) {
        this.dstToSrc = dstToSrc;
    }

    @Override
    public void apply(Input srcImg, Output dstImg) {
        this.init(srcImg, dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageBase)dstImg).width;
        this.y1 = ((ImageBase)dstImg).height;
        if (this.renderAll) {
            this.applyAll();
        } else {
            this.applyOnlyInside();
        }
    }

    @Override
    public void apply(Input srcImg, Output dstImg, GrayU8 mask) {
        this.init(srcImg, dstImg);
        mask.reshape(dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageBase)dstImg).width;
        this.y1 = ((ImageBase)dstImg).height;
        if (this.renderAll) {
            this.applyAll(mask);
        } else {
            this.applyOnlyInside(mask);
        }
    }

    @Override
    public void apply(Input srcImg, Output dstImg, int dstX0, int dstY0, int dstX1, int dstY1) {
        this.init(srcImg, dstImg);
        this.x0 = dstX0;
        this.y0 = dstY0;
        this.x1 = dstX1;
        this.y1 = dstY1;
        if (this.renderAll) {
            this.applyAll();
        } else {
            this.applyOnlyInside();
        }
    }

    protected void init(Input srcImg, Output dstImg) {
        this.srcImg = srcImg;
        this.dstImg = dstImg;
        this.interp.setImage(srcImg);
    }

    protected abstract void applyAll();

    protected abstract void applyAll(GrayU8 var1);

    protected abstract void applyOnlyInside();

    protected abstract void applyOnlyInside(GrayU8 var1);

    @Override
    public void setRenderAll(boolean renderAll) {
        this.renderAll = renderAll;
    }

    @Override
    public boolean getRenderAll() {
        return this.renderAll;
    }

    @Override
    public PixelTransform<Point2D_F32> getModel() {
        return this.dstToSrc;
    }
}

