/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AssignPixelValue_SB;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;

public class ImageDistortCache_SB<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements ImageDistort<Input, Output> {
    protected AssignPixelValue_SB<Output> assigner;
    protected int width = -1;
    protected int height = -1;
    protected Point2D_F32[] map;
    protected InterpolatePixelS<Input> interp;
    protected PixelTransform<Point2D_F32> dstToSrc;
    protected int x0;
    protected int y0;
    protected int x1;
    protected int y1;
    protected boolean renderAll = true;
    protected Input srcImg;
    protected Output dstImg;
    protected boolean dirty;

    public ImageDistortCache_SB(AssignPixelValue_SB<Output> assigner, InterpolatePixelS<Input> interp) {
        this.assigner = assigner;
        this.interp = interp;
    }

    @Override
    public void setModel(PixelTransform<Point2D_F32> dstToSrc) {
        this.dirty = true;
        this.dstToSrc = dstToSrc;
    }

    @Override
    public void apply(Input srcImg, Output dstImg) {
        this.init(srcImg, dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageGray)dstImg).width;
        this.y1 = ((ImageGray)dstImg).height;
        if (this.renderAll) {
            this.renderAll();
        } else {
            this.applyOnlyInside();
        }
    }

    @Override
    public void apply(Input srcImg, Output dstImg, GrayU8 mask) {
        this.init(srcImg, dstImg);
        mask.reshape(dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageGray)dstImg).width;
        this.y1 = ((ImageGray)dstImg).height;
        if (this.renderAll) {
            this.renderAll(mask);
        } else {
            this.applyOnlyInside(mask);
        }
    }

    @Override
    public void apply(Input srcImg, Output dstImg, int dstX0, int dstY0, int dstX1, int dstY1) {
        this.init(srcImg, dstImg);
        this.x0 = dstX0;
        this.y0 = dstY0;
        this.x1 = dstX1;
        this.y1 = dstY1;
        if (this.renderAll) {
            this.renderAll();
        } else {
            this.applyOnlyInside();
        }
    }

    protected void init(Input srcImg, Output dstImg) {
        if (this.dirty || this.width != ((ImageGray)dstImg).width || this.height != ((ImageGray)dstImg).height) {
            this.width = ((ImageGray)dstImg).width;
            this.height = ((ImageGray)dstImg).height;
            this.map = new Point2D_F32[this.width * this.height];
            for (int i = 0; i < this.map.length; ++i) {
                this.map[i] = new Point2D_F32();
            }
            int index = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.dstToSrc.compute(x, y, (Object)this.map[index++]);
                }
            }
            this.dirty = false;
        } else if (((ImageGray)dstImg).width != this.width || ((ImageGray)dstImg).height != this.height) {
            throw new IllegalArgumentException("Unexpected dstImg dimension");
        }
        this.srcImg = srcImg;
        this.dstImg = dstImg;
        this.interp.setImage(srcImg);
        this.assigner.setImage(dstImg);
    }

    protected void renderAll() {
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                this.assigner.assign(indexDst, this.interp.get(s.x, s.y));
                ++x;
                ++indexDst;
            }
        }
    }

    protected void renderAll(GrayU8 mask) {
        float maxWidth = this.srcImg.getWidth() - 1;
        float maxHeight = this.srcImg.getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                this.assigner.assign(indexDst, this.interp.get(s.x, s.y));
                mask.data[indexMsk] = s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight ? (byte)1 : 0;
                ++x;
                ++indexDst;
                ++indexMsk;
            }
        }
    }

    protected void applyOnlyInside() {
        float maxWidth = this.srcImg.getWidth() - 1;
        float maxHeight = this.srcImg.getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                if (s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight) {
                    this.assigner.assign(indexDst, this.interp.get(s.x, s.y));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    protected void applyOnlyInside(GrayU8 mask) {
        float maxWidth = this.srcImg.getWidth() - 1;
        float maxHeight = this.srcImg.getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                if (s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight) {
                    this.assigner.assign(indexDst, this.interp.get(s.x, s.y));
                    mask.data[indexMsk] = 1;
                } else {
                    mask.data[indexMsk] = 0;
                }
                ++x;
                ++indexDst;
                ++indexMsk;
            }
        }
    }

    public Point2D_F32[] getMap() {
        return this.map;
    }

    public InterpolatePixelS<Input> getInterp() {
        return this.interp;
    }

    public PixelTransform<Point2D_F32> getDstToSrc() {
        return this.dstToSrc;
    }

    @Override
    public void setRenderAll(boolean renderAll) {
        this.renderAll = renderAll;
    }

    @Override
    public boolean getRenderAll() {
        return this.renderAll;
    }

    @Override
    public PixelTransform<Point2D_F32> getModel() {
        return this.dstToSrc;
    }
}

