/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.concurrency.FWorkArrays;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;

public class ThresholdSauvola
implements InputToBinary<GrayF32> {
    float k;
    ConfigLength width;
    boolean down;
    GrayF32 inputPow2 = new GrayF32(1, 1);
    GrayF32 inputMean = new GrayF32(1, 1);
    GrayF32 inputMeanPow2 = new GrayF32(1, 1);
    GrayF32 inputPow2Mean = new GrayF32(1, 1);
    GrayF32 stdev = new GrayF32(1, 1);
    GrayF32 tmp = new GrayF32(1, 1);
    FWorkArrays work = new FWorkArrays();

    public ThresholdSauvola(ConfigLength width, float k, boolean down) {
        this.k = k;
        this.width = width;
        this.down = down;
    }

    @Override
    public void process(GrayF32 input, GrayU8 output) {
        this.inputPow2.reshape(input.width, input.height);
        this.inputMean.reshape(input.width, input.height);
        this.inputMeanPow2.reshape(input.width, input.height);
        this.inputPow2Mean.reshape(input.width, input.height);
        this.stdev.reshape(input.width, input.height);
        this.tmp.reshape(input.width, input.height);
        this.inputPow2.reshape(input.width, input.height);
        int radius = this.width.computeI((double)Math.min(input.width, input.height)) / 2;
        BlurImageOps.mean(input, this.inputMean, radius, this.tmp, this.work);
        PixelMath.pow2(input, this.inputPow2);
        BlurImageOps.mean(this.inputPow2, this.inputPow2Mean, radius, this.tmp, this.work);
        PixelMath.pow2(this.inputMean, this.inputMeanPow2);
        PixelMath.subtract(this.inputPow2Mean, this.inputMeanPow2, this.stdev);
        PixelMath.sqrt(this.stdev, this.stdev);
        float R = ImageStatistics.max(this.stdev);
        if (this.down) {
            for (int y = 0; y < input.height; ++y) {
                int i = y * this.stdev.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float threshold = this.inputMean.data[i] * (1.0f + this.k * (this.stdev.data[i] / R - 1.0f));
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int i = y * this.stdev.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float threshold = this.inputMean.data[i] * (1.0f + this.k * (this.stdev.data[i] / R - 1.0f));
                    output.data[indexOut++] = (byte)(input.data[indexIn++] >= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            }
        }
    }

    @Override
    public ImageType<GrayF32> getInputType() {
        return ImageType.SB_F32;
    }

    public float getK() {
        return this.k;
    }

    public void setK(float k) {
        this.k = k;
    }

    public ConfigLength getWidth() {
        return this.width;
    }

    public void setWidth(ConfigLength width) {
        this.width = width;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }
}

