/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.normalized;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import java.util.Arrays;

public class ConvolveNormalized_JustBorder_IL {
    public static void horizontal(Kernel1D_F32 kernel, InterleavedF32 src, InterleavedF32 dst) {
        float[] dataSrc = src.data;
        float[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = src.getNumBands();
        float[] total = new float[numBands];
        for (int i = 0; i < height; ++i) {
            int band;
            int band2;
            double w;
            int k;
            float weight;
            int indexSrc;
            int j;
            int indexDst = dst.startIndex + i * dst.stride;
            for (j = 0; j < offsetL; ++j) {
                indexSrc = src.startIndex + i * src.stride;
                Arrays.fill(total, 0.0f);
                weight = 0.0f;
                for (k = offsetL - j; k < kernelWidth; ++k) {
                    w = kernel.data[k];
                    weight = (float)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (float)((double)total[n] + (double)dataSrc[indexSrc++] * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
            indexDst = dst.startIndex + i * dst.stride + (width - offsetR) * numBands;
            for (j = offsetR - 1; j >= 0; --j) {
                indexSrc = src.startIndex + i * src.stride + (width - offsetL - j - 1) * numBands;
                Arrays.fill(total, 0.0f);
                weight = 0.0f;
                for (k = 0; k <= offsetL + j; ++k) {
                    w = kernel.data[k];
                    weight = (float)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (float)((double)total[n] + (double)dataSrc[indexSrc++] * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, InterleavedF32 input, InterleavedF32 output) {
        int band;
        int band2;
        float w;
        int k;
        int indexSrc;
        int k2;
        float weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int numBands = output.getNumBands();
        float[] total = new float[numBands];
        int yEnd = imgHeight - offsetR;
        for (y = 0; y < offsetL; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kStart = offsetL - y;
            weight = 0.0f;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0.0f);
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
                i += numBands;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kEnd = imgHeight - (y - offsetL);
            weight = 0.0f;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0.0f);
                indexSrc = i - offsetL * input.stride;
                k = 0;
                while (k < kEnd) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
                i += numBands;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, InterleavedF32 src, InterleavedF32 dst) {
        int y;
        float[] dataSrc = src.data;
        float[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = dst.getNumBands();
        float[] total = new float[numBands];
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= offsetL ? -offsetL : -y;
            int maxI = y < height - offsetR ? offsetR : height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0.0f);
                float weight = 0.0f;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -x; j <= offsetR; ++j) {
                        float w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                int maxJ = width - x - 1;
                Arrays.fill(total, 0.0f);
                float weight = 0.0f;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= maxJ; ++j) {
                        float w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
        }
        for (y = 0; y < offsetL; ++y) {
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0.0f);
                float weight = 0.0f;
                for (int i = -y; i <= offsetR; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        float w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
        }
        for (y = height - offsetR; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0.0f);
                float weight = 0.0f;
                for (int i = -offsetL; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        float w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
        }
    }

    public static void horizontal(Kernel1D_F64 kernel, InterleavedF64 src, InterleavedF64 dst) {
        double[] dataSrc = src.data;
        double[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = src.getNumBands();
        double[] total = new double[numBands];
        for (int i = 0; i < height; ++i) {
            int band;
            int band2;
            double w;
            int k;
            double weight;
            int indexSrc;
            int j;
            int indexDst = dst.startIndex + i * dst.stride;
            for (j = 0; j < offsetL; ++j) {
                indexSrc = src.startIndex + i * src.stride;
                Arrays.fill(total, 0.0);
                weight = 0.0;
                for (k = offsetL - j; k < kernelWidth; ++k) {
                    w = kernel.data[k];
                    weight += w;
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = total[n] + dataSrc[indexSrc++] * w;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
            indexDst = dst.startIndex + i * dst.stride + (width - offsetR) * numBands;
            for (j = offsetR - 1; j >= 0; --j) {
                indexSrc = src.startIndex + i * src.stride + (width - offsetL - j - 1) * numBands;
                Arrays.fill(total, 0.0);
                weight = 0.0;
                for (k = 0; k <= offsetL + j; ++k) {
                    w = kernel.data[k];
                    weight += w;
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = total[n] + dataSrc[indexSrc++] * w;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
        }
    }

    public static void vertical(Kernel1D_F64 kernel, InterleavedF64 input, InterleavedF64 output) {
        int band;
        int band2;
        double w;
        int k;
        int indexSrc;
        int k2;
        double weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        double[] dataSrc = input.data;
        double[] dataDst = output.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int numBands = output.getNumBands();
        double[] total = new double[numBands];
        int yEnd = imgHeight - offsetR;
        for (y = 0; y < offsetL; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kStart = offsetL - y;
            weight = 0.0;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0.0);
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
                i += numBands;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kEnd = imgHeight - (y - offsetL);
            weight = 0.0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0.0);
                indexSrc = i - offsetL * input.stride;
                k = 0;
                while (k < kEnd) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
                i += numBands;
            }
        }
    }

    public static void convolve(Kernel2D_F64 kernel, InterleavedF64 src, InterleavedF64 dst) {
        int y;
        double[] dataSrc = src.data;
        double[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = dst.getNumBands();
        double[] total = new double[numBands];
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= offsetL ? -offsetL : -y;
            int maxI = y < height - offsetR ? offsetR : height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0.0);
                double weight = 0.0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -x; j <= offsetR; ++j) {
                        double w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                int maxJ = width - x - 1;
                Arrays.fill(total, 0.0);
                double weight = 0.0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= maxJ; ++j) {
                        double w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
        }
        for (y = 0; y < offsetL; ++y) {
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0.0);
                double weight = 0.0;
                for (int i = -y; i <= offsetR; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        double w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
        }
        for (y = height - offsetR; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0.0);
                double weight = 0.0;
                for (int i = -offsetL; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        double w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = total[band] / weight;
                }
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedU8 src, InterleavedI8 dst) {
        byte[] dataSrc = src.data;
        byte[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = src.getNumBands();
        int[] total = new int[numBands];
        for (int i = 0; i < height; ++i) {
            int band;
            int band2;
            double w;
            int k;
            int weight;
            int indexSrc;
            int j;
            int indexDst = dst.startIndex + i * dst.stride;
            for (j = 0; j < offsetL; ++j) {
                indexSrc = src.startIndex + i * src.stride;
                Arrays.fill(total, 0);
                weight = 0;
                for (k = offsetL - j; k < kernelWidth; ++k) {
                    w = kernel.data[k];
                    weight = (int)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (int)((double)total[n] + (double)(dataSrc[indexSrc++] & 0xFF) * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
            }
            indexDst = dst.startIndex + i * dst.stride + (width - offsetR) * numBands;
            for (j = offsetR - 1; j >= 0; --j) {
                indexSrc = src.startIndex + i * src.stride + (width - offsetL - j - 1) * numBands;
                Arrays.fill(total, 0);
                weight = 0;
                for (k = 0; k <= offsetL + j; ++k) {
                    w = kernel.data[k];
                    weight = (int)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (int)((double)total[n] + (double)(dataSrc[indexSrc++] & 0xFF) * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedU8 input, InterleavedI8 output) {
        int band;
        int band2;
        int w;
        int k;
        int indexSrc;
        int k2;
        int weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int numBands = output.getNumBands();
        int[] total = new int[numBands];
        int yEnd = imgHeight - offsetR;
        for (y = 0; y < offsetL; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kStart = offsetL - y;
            weight = 0;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0);
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + (dataSrc[indexSrc + band2] & 0xFF) * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
                i += numBands;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kEnd = imgHeight - (y - offsetL);
            weight = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0);
                indexSrc = i - offsetL * input.stride;
                k = 0;
                while (k < kEnd) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + (dataSrc[indexSrc + band2] & 0xFF) * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
                i += numBands;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedU8 src, InterleavedI8 dst) {
        int y;
        byte[] dataSrc = src.data;
        byte[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = dst.getNumBands();
        int[] total = new int[numBands];
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= offsetL ? -offsetL : -y;
            int maxI = y < height - offsetR ? offsetR : height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -x; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + (dataSrc[indexSrc++] & 0xFF) * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                int maxJ = width - x - 1;
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= maxJ; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + (dataSrc[indexSrc++] & 0xFF) * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
            }
        }
        for (y = 0; y < offsetL; ++y) {
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = -y; i <= offsetR; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + (dataSrc[indexSrc++] & 0xFF) * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
            }
        }
        for (y = height - offsetR; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = -offsetL; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + (dataSrc[indexSrc++] & 0xFF) * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedS16 src, InterleavedI16 dst) {
        short[] dataSrc = src.data;
        short[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = src.getNumBands();
        int[] total = new int[numBands];
        for (int i = 0; i < height; ++i) {
            int band;
            int band2;
            double w;
            int k;
            int weight;
            int indexSrc;
            int j;
            int indexDst = dst.startIndex + i * dst.stride;
            for (j = 0; j < offsetL; ++j) {
                indexSrc = src.startIndex + i * src.stride;
                Arrays.fill(total, 0);
                weight = 0;
                for (k = offsetL - j; k < kernelWidth; ++k) {
                    w = kernel.data[k];
                    weight = (int)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (int)((double)total[n] + (double)dataSrc[indexSrc++] * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
            indexDst = dst.startIndex + i * dst.stride + (width - offsetR) * numBands;
            for (j = offsetR - 1; j >= 0; --j) {
                indexSrc = src.startIndex + i * src.stride + (width - offsetL - j - 1) * numBands;
                Arrays.fill(total, 0);
                weight = 0;
                for (k = 0; k <= offsetL + j; ++k) {
                    w = kernel.data[k];
                    weight = (int)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (int)((double)total[n] + (double)dataSrc[indexSrc++] * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedS16 input, InterleavedI16 output) {
        int band;
        int band2;
        int w;
        int k;
        int indexSrc;
        int k2;
        int weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int numBands = output.getNumBands();
        int[] total = new int[numBands];
        int yEnd = imgHeight - offsetR;
        for (y = 0; y < offsetL; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kStart = offsetL - y;
            weight = 0;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0);
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
                i += numBands;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kEnd = imgHeight - (y - offsetL);
            weight = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0);
                indexSrc = i - offsetL * input.stride;
                k = 0;
                while (k < kEnd) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
                i += numBands;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedS16 src, InterleavedI16 dst) {
        int y;
        short[] dataSrc = src.data;
        short[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = dst.getNumBands();
        int[] total = new int[numBands];
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= offsetL ? -offsetL : -y;
            int maxI = y < height - offsetR ? offsetR : height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -x; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                int maxJ = width - x - 1;
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= maxJ; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
        }
        for (y = 0; y < offsetL; ++y) {
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = -y; i <= offsetR; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
        }
        for (y = height - offsetR; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = -offsetL; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedU16 src, InterleavedI16 dst) {
        short[] dataSrc = src.data;
        short[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = src.getNumBands();
        int[] total = new int[numBands];
        for (int i = 0; i < height; ++i) {
            int band;
            int band2;
            double w;
            int k;
            int weight;
            int indexSrc;
            int j;
            int indexDst = dst.startIndex + i * dst.stride;
            for (j = 0; j < offsetL; ++j) {
                indexSrc = src.startIndex + i * src.stride;
                Arrays.fill(total, 0);
                weight = 0;
                for (k = offsetL - j; k < kernelWidth; ++k) {
                    w = kernel.data[k];
                    weight = (int)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (int)((double)total[n] + (double)(dataSrc[indexSrc++] & 0xFFFF) * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
            indexDst = dst.startIndex + i * dst.stride + (width - offsetR) * numBands;
            for (j = offsetR - 1; j >= 0; --j) {
                indexSrc = src.startIndex + i * src.stride + (width - offsetL - j - 1) * numBands;
                Arrays.fill(total, 0);
                weight = 0;
                for (k = 0; k <= offsetL + j; ++k) {
                    w = kernel.data[k];
                    weight = (int)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (int)((double)total[n] + (double)(dataSrc[indexSrc++] & 0xFFFF) * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedU16 input, InterleavedI16 output) {
        int band;
        int band2;
        int w;
        int k;
        int indexSrc;
        int k2;
        int weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int numBands = output.getNumBands();
        int[] total = new int[numBands];
        int yEnd = imgHeight - offsetR;
        for (y = 0; y < offsetL; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kStart = offsetL - y;
            weight = 0;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0);
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + (dataSrc[indexSrc + band2] & 0xFFFF) * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
                i += numBands;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kEnd = imgHeight - (y - offsetL);
            weight = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0);
                indexSrc = i - offsetL * input.stride;
                k = 0;
                while (k < kEnd) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + (dataSrc[indexSrc + band2] & 0xFFFF) * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
                i += numBands;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedU16 src, InterleavedI16 dst) {
        int y;
        short[] dataSrc = src.data;
        short[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = dst.getNumBands();
        int[] total = new int[numBands];
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= offsetL ? -offsetL : -y;
            int maxI = y < height - offsetR ? offsetR : height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -x; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + (dataSrc[indexSrc++] & 0xFFFF) * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                int maxJ = width - x - 1;
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= maxJ; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + (dataSrc[indexSrc++] & 0xFFFF) * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
        }
        for (y = 0; y < offsetL; ++y) {
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = -y; i <= offsetR; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + (dataSrc[indexSrc++] & 0xFFFF) * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
        }
        for (y = height - offsetR; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = -offsetL; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + (dataSrc[indexSrc++] & 0xFFFF) * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedS32 src, InterleavedS32 dst) {
        int[] dataSrc = src.data;
        int[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = src.getNumBands();
        int[] total = new int[numBands];
        for (int i = 0; i < height; ++i) {
            int band;
            int band2;
            double w;
            int k;
            int weight;
            int indexSrc;
            int j;
            int indexDst = dst.startIndex + i * dst.stride;
            for (j = 0; j < offsetL; ++j) {
                indexSrc = src.startIndex + i * src.stride;
                Arrays.fill(total, 0);
                weight = 0;
                for (k = offsetL - j; k < kernelWidth; ++k) {
                    w = kernel.data[k];
                    weight = (int)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (int)((double)total[n] + (double)dataSrc[indexSrc++] * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (total[band] + weight / 2) / weight;
                }
            }
            indexDst = dst.startIndex + i * dst.stride + (width - offsetR) * numBands;
            for (j = offsetR - 1; j >= 0; --j) {
                indexSrc = src.startIndex + i * src.stride + (width - offsetL - j - 1) * numBands;
                Arrays.fill(total, 0);
                weight = 0;
                for (k = 0; k <= offsetL + j; ++k) {
                    w = kernel.data[k];
                    weight = (int)((double)weight + w);
                    band2 = 0;
                    while (band2 < numBands) {
                        int n = band2++;
                        total[n] = (int)((double)total[n] + (double)dataSrc[indexSrc++] * w);
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (total[band] + weight / 2) / weight;
                }
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedS32 input, InterleavedS32 output) {
        int band;
        int band2;
        int w;
        int k;
        int indexSrc;
        int k2;
        int weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        int[] dataSrc = input.data;
        int[] dataDst = output.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int numBands = output.getNumBands();
        int[] total = new int[numBands];
        int yEnd = imgHeight - offsetR;
        for (y = 0; y < offsetL; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kStart = offsetL - y;
            weight = 0;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0);
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (total[band] + weight / 2) / weight;
                }
                i += numBands;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth * numBands;
            int kEnd = imgHeight - (y - offsetL);
            weight = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += kernel.data[k2];
            }
            while (i < iEnd) {
                Arrays.fill(total, 0);
                indexSrc = i - offsetL * input.stride;
                k = 0;
                while (k < kEnd) {
                    w = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += input.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (total[band] + weight / 2) / weight;
                }
                i += numBands;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedS32 src, InterleavedS32 dst) {
        int y;
        int[] dataSrc = src.data;
        int[] dataDst = dst.data;
        int kernelWidth = kernel.getWidth();
        int offsetL = kernel.getOffset();
        int offsetR = kernelWidth - offsetL - 1;
        int width = src.getWidth();
        int height = src.getHeight();
        int numBands = dst.getNumBands();
        int[] total = new int[numBands];
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= offsetL ? -offsetL : -y;
            int maxI = y < height - offsetR ? offsetR : height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -x; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (total[band] + weight / 2) / weight;
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                int maxJ = width - x - 1;
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= maxJ; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (total[band] + weight / 2) / weight;
                }
            }
        }
        for (y = 0; y < offsetL; ++y) {
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = -y; i <= offsetR; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (total[band] + weight / 2) / weight;
                }
            }
        }
        for (y = height - offsetR; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = dst.startIndex + y * dst.stride + offsetL * numBands;
            for (int x = offsetL; x < width - offsetR; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = -offsetL; i <= maxI; ++i) {
                    int indexSrc = src.startIndex + (y + i) * src.stride + (x - offsetL) * numBands;
                    int indexKer = (i + offsetL) * kernelWidth;
                    for (int j = -offsetL; j <= offsetR; ++j) {
                        int w = kernel.data[indexKer + j + offsetL];
                        weight += w;
                        int band = 0;
                        while (band < numBands) {
                            int n = band++;
                            total[n] = total[n] + dataSrc[indexSrc++] * w;
                        }
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (total[band] + weight / 2) / weight;
                }
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernelX, Kernel1D_S32 kernelY, InterleavedU16 src, InterleavedI8 dst) {
        int band;
        int band2;
        int w;
        int k;
        int indexSrc;
        int weight;
        int x;
        int weightX;
        int k2;
        int weightY;
        int iEnd;
        int i;
        int indexDst;
        int y;
        short[] dataSrc = src.data;
        byte[] dataDst = dst.data;
        int offsetY = kernelY.getOffset();
        int kernelWidthY = kernelY.getWidth();
        int offsetX = kernelX.getOffset();
        int kernelWidthX = kernelX.getWidth();
        int offsetX1 = kernelWidthX - offsetX - 1;
        int imgWidth = dst.getWidth();
        int imgHeight = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] total = new int[numBands];
        int yEnd = imgHeight - (kernelWidthY - offsetY - 1);
        int startWeightX = 0;
        for (int k3 = offsetX; k3 < kernelWidthX; ++k3) {
            startWeightX += kernelX.data[k3];
        }
        for (y = 0; y < offsetY; ++y) {
            indexDst = dst.startIndex + y * dst.stride;
            i = src.startIndex + y * src.stride;
            iEnd = i + imgWidth * numBands;
            int kStart = offsetY - y;
            weightY = 0;
            for (k2 = kStart; k2 < kernelWidthY; ++k2) {
                weightY += kernelY.data[k2];
            }
            weightX = startWeightX;
            x = 0;
            while (i < iEnd) {
                weight = weightX * weightY;
                Arrays.fill(total, 0);
                indexSrc = i - y * src.stride;
                k = kStart;
                while (k < kernelWidthY) {
                    w = kernelY.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + (dataSrc[indexSrc + band2] & 0xFFFF) * w;
                    }
                    ++k;
                    indexSrc += src.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
                if (x < offsetX) {
                    weightX += kernelX.data[offsetX - x - 1];
                } else if (x >= src.width - (kernelWidthX - offsetX)) {
                    weightX -= kernelX.data[src.width - x + offsetX - 1];
                }
                i += numBands;
                ++x;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = dst.startIndex + y * dst.stride;
            i = src.startIndex + y * src.stride;
            iEnd = i + imgWidth * numBands;
            int kEnd = imgHeight - (y - offsetY);
            weightY = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weightY += kernelY.data[k2];
            }
            weightX = startWeightX;
            x = 0;
            while (i < iEnd) {
                weight = weightX * weightY;
                Arrays.fill(total, 0);
                indexSrc = i - offsetY * src.stride;
                k = 0;
                while (k < kEnd) {
                    w = kernelY.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + (dataSrc[indexSrc + band2] & 0xFFFF) * w;
                    }
                    ++k;
                    indexSrc += src.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (byte)((total[band] + weight / 2) / weight);
                }
                if (x < offsetX) {
                    weightX += kernelX.data[offsetX - x - 1];
                } else if (x >= src.width - (kernelWidthX - offsetX)) {
                    weightX -= kernelX.data[src.width - x + offsetX - 1];
                }
                i += numBands;
                ++x;
            }
        }
        int weightY2 = kernelY.computeSum();
        for (int y2 = offsetY; y2 < yEnd; ++y2) {
            int indexDst2 = dst.startIndex + y2 * dst.stride;
            int i2 = src.startIndex + y2 * src.stride;
            int iEnd2 = i2 + offsetY * numBands;
            int weightX2 = startWeightX;
            int x2 = 0;
            while (i2 < iEnd2) {
                int weight2 = weightX2 * weightY2;
                Arrays.fill(total, 0);
                int indexSrc2 = i2 - offsetY * src.stride;
                int k4 = 0;
                while (k4 < kernelWidthY) {
                    int w2 = kernelY.data[k4];
                    for (int band3 = 0; band3 < numBands; ++band3) {
                        int n = band3;
                        total[n] = total[n] + (dataSrc[indexSrc2 + band3] & 0xFFFF) * w2;
                    }
                    ++k4;
                    indexSrc2 += src.stride;
                }
                for (int band4 = 0; band4 < numBands; ++band4) {
                    dataDst[indexDst2++] = (byte)((total[band4] + weight2 / 2) / weight2);
                }
                weightX2 += kernelX.data[offsetX - x2 - 1];
                i2 += numBands;
                ++x2;
            }
            int startX = src.width - offsetX1;
            indexDst2 = dst.startIndex + y2 * dst.stride + startX * numBands;
            i2 = src.startIndex + y2 * src.stride + startX * numBands;
            iEnd2 = src.startIndex + y2 * src.stride + src.width * numBands;
            x = startX;
            while (i2 < iEnd2) {
                weight = (weightX2 -= kernelX.data[src.width - x + offsetX]) * weightY2;
                Arrays.fill(total, 0);
                indexSrc = i2 - offsetY * src.stride;
                k = 0;
                while (k < kernelWidthY) {
                    w = kernelY.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + (dataSrc[indexSrc + band2] & 0xFFFF) * w;
                    }
                    ++k;
                    indexSrc += src.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst2++] = (byte)((total[band] + weight / 2) / weight);
                }
                i2 += numBands;
                ++x;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernelX, Kernel1D_S32 kernelY, InterleavedS32 src, InterleavedI16 dst) {
        int band;
        int band2;
        int w;
        int k;
        int indexSrc;
        int weight;
        int x;
        int weightX;
        int k2;
        int weightY;
        int iEnd;
        int i;
        int indexDst;
        int y;
        int[] dataSrc = src.data;
        short[] dataDst = dst.data;
        int offsetY = kernelY.getOffset();
        int kernelWidthY = kernelY.getWidth();
        int offsetX = kernelX.getOffset();
        int kernelWidthX = kernelX.getWidth();
        int offsetX1 = kernelWidthX - offsetX - 1;
        int imgWidth = dst.getWidth();
        int imgHeight = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] total = new int[numBands];
        int yEnd = imgHeight - (kernelWidthY - offsetY - 1);
        int startWeightX = 0;
        for (int k3 = offsetX; k3 < kernelWidthX; ++k3) {
            startWeightX += kernelX.data[k3];
        }
        for (y = 0; y < offsetY; ++y) {
            indexDst = dst.startIndex + y * dst.stride;
            i = src.startIndex + y * src.stride;
            iEnd = i + imgWidth * numBands;
            int kStart = offsetY - y;
            weightY = 0;
            for (k2 = kStart; k2 < kernelWidthY; ++k2) {
                weightY += kernelY.data[k2];
            }
            weightX = startWeightX;
            x = 0;
            while (i < iEnd) {
                weight = weightX * weightY;
                Arrays.fill(total, 0);
                indexSrc = i - y * src.stride;
                k = kStart;
                while (k < kernelWidthY) {
                    w = kernelY.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += src.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
                if (x < offsetX) {
                    weightX += kernelX.data[offsetX - x - 1];
                } else if (x >= src.width - (kernelWidthX - offsetX)) {
                    weightX -= kernelX.data[src.width - x + offsetX - 1];
                }
                i += numBands;
                ++x;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = dst.startIndex + y * dst.stride;
            i = src.startIndex + y * src.stride;
            iEnd = i + imgWidth * numBands;
            int kEnd = imgHeight - (y - offsetY);
            weightY = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weightY += kernelY.data[k2];
            }
            weightX = startWeightX;
            x = 0;
            while (i < iEnd) {
                weight = weightX * weightY;
                Arrays.fill(total, 0);
                indexSrc = i - offsetY * src.stride;
                k = 0;
                while (k < kEnd) {
                    w = kernelY.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += src.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst++] = (short)((total[band] + weight / 2) / weight);
                }
                if (x < offsetX) {
                    weightX += kernelX.data[offsetX - x - 1];
                } else if (x >= src.width - (kernelWidthX - offsetX)) {
                    weightX -= kernelX.data[src.width - x + offsetX - 1];
                }
                i += numBands;
                ++x;
            }
        }
        int weightY2 = kernelY.computeSum();
        for (int y2 = offsetY; y2 < yEnd; ++y2) {
            int indexDst2 = dst.startIndex + y2 * dst.stride;
            int i2 = src.startIndex + y2 * src.stride;
            int iEnd2 = i2 + offsetY * numBands;
            int weightX2 = startWeightX;
            int x2 = 0;
            while (i2 < iEnd2) {
                int weight2 = weightX2 * weightY2;
                Arrays.fill(total, 0);
                int indexSrc2 = i2 - offsetY * src.stride;
                int k4 = 0;
                while (k4 < kernelWidthY) {
                    int w2 = kernelY.data[k4];
                    for (int band3 = 0; band3 < numBands; ++band3) {
                        int n = band3;
                        total[n] = total[n] + dataSrc[indexSrc2 + band3] * w2;
                    }
                    ++k4;
                    indexSrc2 += src.stride;
                }
                for (int band4 = 0; band4 < numBands; ++band4) {
                    dataDst[indexDst2++] = (short)((total[band4] + weight2 / 2) / weight2);
                }
                weightX2 += kernelX.data[offsetX - x2 - 1];
                i2 += numBands;
                ++x2;
            }
            int startX = src.width - offsetX1;
            indexDst2 = dst.startIndex + y2 * dst.stride + startX * numBands;
            i2 = src.startIndex + y2 * src.stride + startX * numBands;
            iEnd2 = src.startIndex + y2 * src.stride + src.width * numBands;
            x = startX;
            while (i2 < iEnd2) {
                weight = (weightX2 -= kernelX.data[src.width - x + offsetX]) * weightY2;
                Arrays.fill(total, 0);
                indexSrc = i2 - offsetY * src.stride;
                k = 0;
                while (k < kernelWidthY) {
                    w = kernelY.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + dataSrc[indexSrc + band2] * w;
                    }
                    ++k;
                    indexSrc += src.stride;
                }
                for (band = 0; band < numBands; ++band) {
                    dataDst[indexDst2++] = (short)((total[band] + weight / 2) / weight);
                }
                i2 += numBands;
                ++x;
            }
        }
    }
}

