/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.census.impl;

import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedU16;
import org.ddogleg.struct.GrowQueue_I32;

public class ImplCensusTransformInner {
    public static void dense3x3(GrayU8 input, GrayU8 output) {
        int height = input.height - 1;
        byte[] src = input.data;
        int offset0 = -input.stride - 1;
        int offset1 = -input.stride;
        int offset2 = -input.stride + 1;
        int offset3 = -1;
        boolean offset5 = true;
        int offset6 = input.stride - 1;
        int offset7 = input.stride;
        int offset8 = input.stride + 1;
        for (int y = 1; y < height; ++y) {
            int indexSrc = input.startIndex + y * input.stride + 1;
            int indexDst = output.startIndex + y * output.stride + 1;
            int end = indexDst + input.width - 2;
            while (indexDst < end) {
                int center = src[indexSrc] & 0xFF;
                int census = 0;
                if ((src[indexSrc + offset0] & 0xFF) > center) {
                    census |= 1;
                }
                if ((src[indexSrc + offset1] & 0xFF) > center) {
                    census |= 2;
                }
                if ((src[indexSrc + offset2] & 0xFF) > center) {
                    census |= 4;
                }
                if ((src[indexSrc + -1] & 0xFF) > center) {
                    census |= 8;
                }
                if ((src[indexSrc + 1] & 0xFF) > center) {
                    census |= 0x10;
                }
                if ((src[indexSrc + offset6] & 0xFF) > center) {
                    census |= 0x20;
                }
                if ((src[indexSrc + offset7] & 0xFF) > center) {
                    census |= 0x40;
                }
                if ((src[indexSrc + offset8] & 0xFF) > center) {
                    census |= 0x80;
                }
                output.data[indexDst] = (byte)census;
                ++indexDst;
                ++indexSrc;
            }
        }
    }

    public static void dense5x5(GrayU8 input, GrayS32 output) {
        int height = input.height - 2;
        byte[] src = input.data;
        int offset00 = -2 * input.stride - 2;
        int offset01 = -2 * input.stride - 1;
        int offset02 = -2 * input.stride;
        int offset03 = -2 * input.stride + 1;
        int offset04 = -2 * input.stride + 2;
        int offset10 = -input.stride - 2;
        int offset11 = -input.stride - 1;
        int offset12 = -input.stride;
        int offset13 = -input.stride + 1;
        int offset14 = -input.stride + 2;
        int offset20 = -2;
        int offset21 = -1;
        boolean offset23 = true;
        int offset24 = 2;
        int offset30 = input.stride - 2;
        int offset31 = input.stride - 1;
        int offset32 = input.stride;
        int offset33 = input.stride + 1;
        int offset34 = input.stride + 2;
        int offset40 = 2 * input.stride - 2;
        int offset41 = 2 * input.stride - 1;
        int offset42 = 2 * input.stride;
        int offset43 = 2 * input.stride + 1;
        int offset44 = 2 * input.stride + 2;
        for (int y = 2; y < height; ++y) {
            int indexSrc = input.startIndex + y * input.stride + 2;
            int indexDst = output.startIndex + y * output.stride + 2;
            int end = indexDst + input.width - 4;
            while (indexDst < end) {
                int center = src[indexSrc] & 0xFF;
                int census = 0;
                if ((src[indexSrc + offset00] & 0xFF) > center) {
                    census |= 1;
                }
                if ((src[indexSrc + offset01] & 0xFF) > center) {
                    census |= 2;
                }
                if ((src[indexSrc + offset02] & 0xFF) > center) {
                    census |= 4;
                }
                if ((src[indexSrc + offset03] & 0xFF) > center) {
                    census |= 8;
                }
                if ((src[indexSrc + offset04] & 0xFF) > center) {
                    census |= 0x10;
                }
                if ((src[indexSrc + offset10] & 0xFF) > center) {
                    census |= 0x20;
                }
                if ((src[indexSrc + offset11] & 0xFF) > center) {
                    census |= 0x40;
                }
                if ((src[indexSrc + offset12] & 0xFF) > center) {
                    census |= 0x80;
                }
                if ((src[indexSrc + offset13] & 0xFF) > center) {
                    census |= 0x100;
                }
                if ((src[indexSrc + offset14] & 0xFF) > center) {
                    census |= 0x200;
                }
                if ((src[indexSrc + -2] & 0xFF) > center) {
                    census |= 0x400;
                }
                if ((src[indexSrc + -1] & 0xFF) > center) {
                    census |= 0x800;
                }
                if ((src[indexSrc + 1] & 0xFF) > center) {
                    census |= 0x1000;
                }
                if ((src[indexSrc + 2] & 0xFF) > center) {
                    census |= 0x2000;
                }
                if ((src[indexSrc + offset30] & 0xFF) > center) {
                    census |= 0x4000;
                }
                if ((src[indexSrc + offset31] & 0xFF) > center) {
                    census |= 0x8000;
                }
                if ((src[indexSrc + offset32] & 0xFF) > center) {
                    census |= 0x10000;
                }
                if ((src[indexSrc + offset33] & 0xFF) > center) {
                    census |= 0x20000;
                }
                if ((src[indexSrc + offset34] & 0xFF) > center) {
                    census |= 0x40000;
                }
                if ((src[indexSrc + offset40] & 0xFF) > center) {
                    census |= 0x80000;
                }
                if ((src[indexSrc + offset41] & 0xFF) > center) {
                    census |= 0x100000;
                }
                if ((src[indexSrc + offset42] & 0xFF) > center) {
                    census |= 0x200000;
                }
                if ((src[indexSrc + offset43] & 0xFF) > center) {
                    census |= 0x400000;
                }
                if ((src[indexSrc + offset44] & 0xFF) > center) {
                    census |= 0x800000;
                }
                output.data[indexDst] = census;
                ++indexDst;
                ++indexSrc;
            }
        }
    }

    public static void sample_S64(GrayU8 input, int radius, GrowQueue_I32 offsets, GrayS64 output) {
        int height = input.height - radius;
        byte[] src = input.data;
        for (int y = radius; y < height; ++y) {
            int indexSrc = input.startIndex + y * input.stride + radius;
            int indexDst = output.startIndex + y * output.stride + radius;
            int end = indexDst + input.width - 2 * radius;
            while (indexDst < end) {
                int center = src[indexSrc] & 0xFF;
                long census = 0L;
                int bit = 1;
                for (int i = 0; i < offsets.size; ++i) {
                    if ((src[indexSrc + offsets.data[i]] & 0xFF) > center) {
                        census |= (long)bit;
                    }
                    bit <<= 1;
                }
                output.data[indexDst++] = census;
                ++indexSrc;
            }
        }
    }

    public static void sample_IU16(GrayU8 input, int radius, GrowQueue_I32 offsets, InterleavedU16 output) {
        int height = input.height - radius;
        byte[] src = input.data;
        int bitBlocks = offsets.size / 16;
        for (int y = radius; y < height; ++y) {
            int indexSrc = input.startIndex + y * input.stride + radius;
            int indexDst = output.startIndex + y * output.stride + radius * output.numBands;
            int end = indexDst + (input.width - 2 * radius) * output.numBands;
            while (indexDst < end) {
                int center = src[indexSrc] & 0xFF;
                int idx = 0;
                for (int block = 0; block < bitBlocks; ++block) {
                    short census = 0;
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 1);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 2);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 4);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 8);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x10);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x20);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x40);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x80);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x100);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x200);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x400);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x800);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x1000);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x2000);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x4000);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                        census = (short)(census | 0x8000);
                    }
                    output.data[indexDst++] = census;
                }
                if (idx != offsets.size) {
                    short census = 0;
                    int bit = 1;
                    while (idx < offsets.size) {
                        if ((src[indexSrc + offsets.data[idx++]] & 0xFF) > center) {
                            census = (short)(census | bit);
                        }
                        bit <<= 1;
                    }
                    output.data[indexDst++] = census;
                }
                ++indexSrc;
            }
        }
    }

    public static void dense3x3(GrayU16 input, GrayU8 output) {
        int height = input.height - 1;
        short[] src = input.data;
        int offset0 = -input.stride - 1;
        int offset1 = -input.stride;
        int offset2 = -input.stride + 1;
        int offset3 = -1;
        boolean offset5 = true;
        int offset6 = input.stride - 1;
        int offset7 = input.stride;
        int offset8 = input.stride + 1;
        for (int y = 1; y < height; ++y) {
            int indexSrc = input.startIndex + y * input.stride + 1;
            int indexDst = output.startIndex + y * output.stride + 1;
            int end = indexDst + input.width - 2;
            while (indexDst < end) {
                int center = src[indexSrc] & 0xFFFF;
                int census = 0;
                if ((src[indexSrc + offset0] & 0xFFFF) > center) {
                    census |= 1;
                }
                if ((src[indexSrc + offset1] & 0xFFFF) > center) {
                    census |= 2;
                }
                if ((src[indexSrc + offset2] & 0xFFFF) > center) {
                    census |= 4;
                }
                if ((src[indexSrc + -1] & 0xFFFF) > center) {
                    census |= 8;
                }
                if ((src[indexSrc + 1] & 0xFFFF) > center) {
                    census |= 0x10;
                }
                if ((src[indexSrc + offset6] & 0xFFFF) > center) {
                    census |= 0x20;
                }
                if ((src[indexSrc + offset7] & 0xFFFF) > center) {
                    census |= 0x40;
                }
                if ((src[indexSrc + offset8] & 0xFFFF) > center) {
                    census |= 0x80;
                }
                output.data[indexDst] = (byte)census;
                ++indexDst;
                ++indexSrc;
            }
        }
    }

    public static void dense5x5(GrayU16 input, GrayS32 output) {
        int height = input.height - 2;
        short[] src = input.data;
        int offset00 = -2 * input.stride - 2;
        int offset01 = -2 * input.stride - 1;
        int offset02 = -2 * input.stride;
        int offset03 = -2 * input.stride + 1;
        int offset04 = -2 * input.stride + 2;
        int offset10 = -input.stride - 2;
        int offset11 = -input.stride - 1;
        int offset12 = -input.stride;
        int offset13 = -input.stride + 1;
        int offset14 = -input.stride + 2;
        int offset20 = -2;
        int offset21 = -1;
        boolean offset23 = true;
        int offset24 = 2;
        int offset30 = input.stride - 2;
        int offset31 = input.stride - 1;
        int offset32 = input.stride;
        int offset33 = input.stride + 1;
        int offset34 = input.stride + 2;
        int offset40 = 2 * input.stride - 2;
        int offset41 = 2 * input.stride - 1;
        int offset42 = 2 * input.stride;
        int offset43 = 2 * input.stride + 1;
        int offset44 = 2 * input.stride + 2;
        for (int y = 2; y < height; ++y) {
            int indexSrc = input.startIndex + y * input.stride + 2;
            int indexDst = output.startIndex + y * output.stride + 2;
            int end = indexDst + input.width - 4;
            while (indexDst < end) {
                int center = src[indexSrc] & 0xFFFF;
                int census = 0;
                if ((src[indexSrc + offset00] & 0xFFFF) > center) {
                    census |= 1;
                }
                if ((src[indexSrc + offset01] & 0xFFFF) > center) {
                    census |= 2;
                }
                if ((src[indexSrc + offset02] & 0xFFFF) > center) {
                    census |= 4;
                }
                if ((src[indexSrc + offset03] & 0xFFFF) > center) {
                    census |= 8;
                }
                if ((src[indexSrc + offset04] & 0xFFFF) > center) {
                    census |= 0x10;
                }
                if ((src[indexSrc + offset10] & 0xFFFF) > center) {
                    census |= 0x20;
                }
                if ((src[indexSrc + offset11] & 0xFFFF) > center) {
                    census |= 0x40;
                }
                if ((src[indexSrc + offset12] & 0xFFFF) > center) {
                    census |= 0x80;
                }
                if ((src[indexSrc + offset13] & 0xFFFF) > center) {
                    census |= 0x100;
                }
                if ((src[indexSrc + offset14] & 0xFFFF) > center) {
                    census |= 0x200;
                }
                if ((src[indexSrc + -2] & 0xFFFF) > center) {
                    census |= 0x400;
                }
                if ((src[indexSrc + -1] & 0xFFFF) > center) {
                    census |= 0x800;
                }
                if ((src[indexSrc + 1] & 0xFFFF) > center) {
                    census |= 0x1000;
                }
                if ((src[indexSrc + 2] & 0xFFFF) > center) {
                    census |= 0x2000;
                }
                if ((src[indexSrc + offset30] & 0xFFFF) > center) {
                    census |= 0x4000;
                }
                if ((src[indexSrc + offset31] & 0xFFFF) > center) {
                    census |= 0x8000;
                }
                if ((src[indexSrc + offset32] & 0xFFFF) > center) {
                    census |= 0x10000;
                }
                if ((src[indexSrc + offset33] & 0xFFFF) > center) {
                    census |= 0x20000;
                }
                if ((src[indexSrc + offset34] & 0xFFFF) > center) {
                    census |= 0x40000;
                }
                if ((src[indexSrc + offset40] & 0xFFFF) > center) {
                    census |= 0x80000;
                }
                if ((src[indexSrc + offset41] & 0xFFFF) > center) {
                    census |= 0x100000;
                }
                if ((src[indexSrc + offset42] & 0xFFFF) > center) {
                    census |= 0x200000;
                }
                if ((src[indexSrc + offset43] & 0xFFFF) > center) {
                    census |= 0x400000;
                }
                if ((src[indexSrc + offset44] & 0xFFFF) > center) {
                    census |= 0x800000;
                }
                output.data[indexDst] = census;
                ++indexDst;
                ++indexSrc;
            }
        }
    }

    public static void sample_S64(GrayU16 input, int radius, GrowQueue_I32 offsets, GrayS64 output) {
        int height = input.height - radius;
        short[] src = input.data;
        for (int y = radius; y < height; ++y) {
            int indexSrc = input.startIndex + y * input.stride + radius;
            int indexDst = output.startIndex + y * output.stride + radius;
            int end = indexDst + input.width - 2 * radius;
            while (indexDst < end) {
                int center = src[indexSrc] & 0xFFFF;
                long census = 0L;
                int bit = 1;
                for (int i = 0; i < offsets.size; ++i) {
                    if ((src[indexSrc + offsets.data[i]] & 0xFFFF) > center) {
                        census |= (long)bit;
                    }
                    bit <<= 1;
                }
                output.data[indexDst++] = census;
                ++indexSrc;
            }
        }
    }

    public static void sample_IU16(GrayU16 input, int radius, GrowQueue_I32 offsets, InterleavedU16 output) {
        int height = input.height - radius;
        short[] src = input.data;
        int bitBlocks = offsets.size / 16;
        for (int y = radius; y < height; ++y) {
            int indexSrc = input.startIndex + y * input.stride + radius;
            int indexDst = output.startIndex + y * output.stride + radius * output.numBands;
            int end = indexDst + (input.width - 2 * radius) * output.numBands;
            while (indexDst < end) {
                int center = src[indexSrc] & 0xFFFF;
                int idx = 0;
                for (int block = 0; block < bitBlocks; ++block) {
                    short census = 0;
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 1);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 2);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 4);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 8);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x10);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x20);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x40);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x80);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x100);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x200);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x400);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x800);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x1000);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x2000);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x4000);
                    }
                    if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                        census = (short)(census | 0x8000);
                    }
                    output.data[indexDst++] = census;
                }
                if (idx != offsets.size) {
                    short census = 0;
                    int bit = 1;
                    while (idx < offsets.size) {
                        if ((src[indexSrc + offsets.data[idx++]] & 0xFFFF) > center) {
                            census = (short)(census | bit);
                        }
                        bit <<= 1;
                    }
                    output.data[indexDst++] = census;
                }
                ++indexSrc;
            }
        }
    }
}

