/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.alg.transform.ii.impl.ImplIntegralImageConvolve;
import boofcv.alg.transform.ii.impl.ImplIntegralImageConvolve_MT;
import boofcv.alg.transform.ii.impl.ImplIntegralImageOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;

public class IntegralImageOps {
    public static GrayF32 transform(GrayF32 input, GrayF32 transformed) {
        transformed = (GrayF32)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)transformed);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static GrayF64 transform(GrayF64 input, GrayF64 transformed) {
        transformed = (GrayF64)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)transformed);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static GrayS32 transform(GrayU8 input, GrayS32 transformed) {
        transformed = (GrayS32)InputSanityCheck.checkDeclare((ImageGray)input, (ImageGray)transformed, GrayS32.class);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static GrayS32 transform(GrayS32 input, GrayS32 transformed) {
        transformed = (GrayS32)InputSanityCheck.checkDeclare((ImageGray)input, (ImageGray)transformed, GrayS32.class);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static GrayS64 transform(GrayS64 input, GrayS64 transformed) {
        transformed = (GrayS64)InputSanityCheck.checkDeclare((ImageGray)input, (ImageGray)transformed, GrayS64.class);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static GrayF32 convolve(GrayF32 integral, IntegralKernel kernel, GrayF32 output) {
        output = (GrayF32)InputSanityCheck.checkDeclare((ImageBase)integral, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplIntegralImageConvolve_MT.convolve(integral, kernel, output);
        } else {
            ImplIntegralImageConvolve.convolve(integral, kernel, output);
        }
        return output;
    }

    public static GrayF64 convolve(GrayF64 integral, IntegralKernel kernel, GrayF64 output) {
        output = (GrayF64)InputSanityCheck.checkDeclare((ImageBase)integral, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplIntegralImageConvolve_MT.convolve(integral, kernel, output);
        } else {
            ImplIntegralImageConvolve.convolve(integral, kernel, output);
        }
        return output;
    }

    public static GrayS32 convolve(GrayS32 integral, IntegralKernel kernel, GrayS32 output) {
        output = (GrayS32)InputSanityCheck.checkDeclare((ImageBase)integral, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplIntegralImageConvolve_MT.convolve(integral, kernel, output);
        } else {
            ImplIntegralImageConvolve.convolve(integral, kernel, output);
        }
        return output;
    }

    public static GrayS64 convolve(GrayS64 integral, IntegralKernel kernel, GrayS64 output) {
        output = (GrayS64)InputSanityCheck.checkDeclare((ImageBase)integral, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplIntegralImageConvolve_MT.convolve(integral, kernel, output);
        } else {
            ImplIntegralImageConvolve.convolve(integral, kernel, output);
        }
        return output;
    }

    public static GrayF32 convolveBorder(GrayF32 integral, IntegralKernel kernel, GrayF32 output, int borderX, int borderY) {
        output = (GrayF32)InputSanityCheck.checkDeclare((ImageBase)integral, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplIntegralImageConvolve_MT.convolveBorder(integral, kernel, output, borderX, borderY);
        } else {
            ImplIntegralImageConvolve.convolveBorder(integral, kernel, output, borderX, borderY);
        }
        return output;
    }

    public static GrayF64 convolveBorder(GrayF64 integral, IntegralKernel kernel, GrayF64 output, int borderX, int borderY) {
        output = (GrayF64)InputSanityCheck.checkDeclare((ImageBase)integral, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplIntegralImageConvolve_MT.convolveBorder(integral, kernel, output, borderX, borderY);
        } else {
            ImplIntegralImageConvolve.convolveBorder(integral, kernel, output, borderX, borderY);
        }
        return output;
    }

    public static GrayS32 convolveBorder(GrayS32 integral, IntegralKernel kernel, GrayS32 output, int borderX, int borderY) {
        output = (GrayS32)InputSanityCheck.checkDeclare((ImageBase)integral, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplIntegralImageConvolve_MT.convolveBorder(integral, kernel, output, borderX, borderY);
        } else {
            ImplIntegralImageConvolve.convolveBorder(integral, kernel, output, borderX, borderY);
        }
        return output;
    }

    public static GrayS64 convolveBorder(GrayS64 integral, IntegralKernel kernel, GrayS64 output, int borderX, int borderY) {
        output = (GrayS64)InputSanityCheck.checkDeclare((ImageBase)integral, (ImageBase)output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplIntegralImageConvolve_MT.convolveBorder(integral, kernel, output, borderX, borderY);
        } else {
            ImplIntegralImageConvolve.convolveBorder(integral, kernel, output, borderX, borderY);
        }
        return output;
    }

    public static float convolveSparse(GrayF32 integral, IntegralKernel kernel, int x, int y) {
        return ImplIntegralImageOps.convolveSparse(integral, kernel, x, y);
    }

    public static double convolveSparse(GrayF64 integral, IntegralKernel kernel, int x, int y) {
        return ImplIntegralImageOps.convolveSparse(integral, kernel, x, y);
    }

    public static int convolveSparse(GrayS32 integral, IntegralKernel kernel, int x, int y) {
        return ImplIntegralImageOps.convolveSparse(integral, kernel, x, y);
    }

    public static long convolveSparse(GrayS64 integral, IntegralKernel kernel, int x, int y) {
        return ImplIntegralImageOps.convolveSparse(integral, kernel, x, y);
    }

    public static double block_unsafe(GrayF64 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_unsafe(integral, x0, y0, x1, y1);
    }

    public static float block_unsafe(GrayF32 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_unsafe(integral, x0, y0, x1, y1);
    }

    public static int block_unsafe(GrayS32 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_unsafe(integral, x0, y0, x1, y1);
    }

    public static long block_unsafe(GrayS64 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_unsafe(integral, x0, y0, x1, y1);
    }

    public static float block_zero(GrayF32 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_zero(integral, x0, y0, x1, y1);
    }

    public static double block_zero(GrayF64 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_zero(integral, x0, y0, x1, y1);
    }

    public static int block_zero(GrayS32 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_zero(integral, x0, y0, x1, y1);
    }

    public static long block_zero(GrayS64 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_zero(integral, x0, y0, x1, y1);
    }

    public static void print(IntegralKernel kernel) {
        int x0 = 0;
        int x1 = 0;
        int y0 = 0;
        int y1 = 0;
        for (ImageRectangle k : kernel.blocks) {
            if (k.x0 < x0) {
                x0 = k.x0;
            }
            if (k.y0 < y0) {
                y0 = k.y0;
            }
            if (k.x1 > x1) {
                x1 = k.x1;
            }
            if (k.y1 <= y1) continue;
            y1 = k.y1;
        }
        int w = x1 - x0;
        int h = y1 - y0;
        int[] sum = new int[w * h];
        for (int i = 0; i < kernel.blocks.length; ++i) {
            ImageRectangle r = kernel.blocks[i];
            int value = kernel.scales[i];
            for (int y = r.y0; y < r.y1; ++y) {
                int yy = y - y0;
                for (int x = r.x0; x < r.x1; ++x) {
                    int xx = x - x0;
                    int n = yy * w + xx;
                    sum[n] = sum[n] + value;
                }
            }
        }
        System.out.println("IntegralKernel: TL = (" + (x0 + 1) + "," + (y0 + 1) + ") BR=(" + x1 + "," + y1 + ")");
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                System.out.printf("%4d ", sum[y * w + x]);
            }
            System.out.println();
        }
    }

    public static boolean isInBounds(int x, int y, IntegralKernel kernel, int width, int height) {
        for (ImageRectangle r : kernel.blocks) {
            if (x + r.x0 < 0 || y + r.y0 < 0) {
                return false;
            }
            if (x + r.x1 < width && y + r.y1 < height) continue;
            return false;
        }
        return true;
    }
}

