/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

public class ConfigPyramid2 {
    public int numLevelsRequested = -1;
    public int minWidth = -1;
    public int minHeight = -1;

    public ConfigPyramid2() {
    }

    public ConfigPyramid2(int numLevelsRequested, int minWidth, int minHeight) {
        this.numLevelsRequested = numLevelsRequested;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    public int computeLayers(int width, int height) {
        if (this.numLevelsRequested > 0) {
            return this.numLevelsRequested;
        }
        if (this.minWidth > 0) {
            return this.computeNumLevels(width, this.minWidth);
        }
        if (this.minHeight > 0) {
            return this.computeNumLevels(height, this.minHeight);
        }
        throw new IllegalArgumentException("Need to specify numLevels or minWidth or minHeight");
    }

    int computeNumLevels(int length, int minLength) {
        double scale = (double)length / (double)minLength;
        double levels = Math.log(scale) / Math.log(2.0);
        return (int)Math.floor(levels) + 1;
    }

    public void set(ConfigPyramid2 config) {
        this.numLevelsRequested = config.numLevelsRequested;
        this.minWidth = config.minWidth;
        this.minHeight = config.minHeight;
    }
}

