/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.distort.FDistort;
import boofcv.alg.transform.pyramid.ConfigPyramid2;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class PyramidDiscreteNN2<T extends ImageBase<T>> {
    ImageType<T> imageType;
    FDistort distort;
    private ConfigPyramid2 configLayers = new ConfigPyramid2();
    T[] levels;

    public PyramidDiscreteNN2(ImageType<T> imageType) {
        this.imageType = imageType;
        this.levels = imageType.createArray(0);
        this.distort = new FDistort(imageType);
        this.distort.interpNN();
    }

    public void process(T input) {
        int requestedLayers = this.configLayers.computeLayers(((ImageBase)input).width, ((ImageBase)input).height);
        if (this.levels.length != requestedLayers) {
            this.declareArray(requestedLayers);
        }
        this.levels[0] = input;
        int scale = 2;
        for (int level = 1; level < this.levels.length; ++level) {
            int width = ((ImageBase)input).width / scale;
            int height = ((ImageBase)input).height / scale;
            this.levels[level].reshape(width, height);
            this.distort.input((ImageBase)this.levels[level - 1]);
            this.distort.output((ImageBase)this.levels[level]);
            this.distort.scaleExt();
            this.distort.apply();
            scale *= 2;
        }
    }

    private int computeNumLevels(int length, int minLengt) {
        double scale = (double)length / (double)minLengt;
        double levels = Math.log(scale) / Math.log(2.0);
        return (int)Math.floor(levels) + 1;
    }

    private void declareArray(int numLevels) {
        this.levels = this.imageType.createArray(numLevels);
        for (int i = 1; i < this.levels.length; ++i) {
            this.levels[i] = this.imageType.createImage(1, 1);
        }
    }

    public T get(int i) {
        return this.levels[i];
    }

    public T getLayer(int i) {
        return this.levels[i];
    }

    public ImageType<T> getImageType() {
        return this.imageType;
    }

    public int getLevelsCount() {
        return this.levels.length;
    }

    public ConfigPyramid2 getConfigLayers() {
        return this.configLayers;
    }
}

