/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding;

import boofcv.concurrency.BoofConcurrency;
import boofcv.core.encoding.impl.ImplConvertNV21;
import boofcv.core.encoding.impl.ImplConvertNV21_MT;
import boofcv.core.encoding.impl.ImplConvertYV12;
import boofcv.core.encoding.impl.ImplConvertYV12_MT;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ConvertYV12 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void yu12ToBoof(byte[] data, int width, int height, ImageBase output) {
        if (output instanceof Planar) {
            Planar ms = (Planar)output;
            ms.reshape(width, height, 3);
            if (BoofConcurrency.USE_CONCURRENT) {
                if (ms.getBandType() == GrayU8.class) {
                    ImplConvertYV12_MT.yv12ToPlanarRgb_U8(data, (Planar<GrayU8>)ms);
                    return;
                } else {
                    if (ms.getBandType() != GrayF32.class) throw new IllegalArgumentException("Unsupported output band format");
                    ImplConvertYV12_MT.yv12ToPlanarRgb_F32(data, (Planar<GrayF32>)ms);
                }
                return;
            } else if (ms.getBandType() == GrayU8.class) {
                ImplConvertYV12.yv12ToPlanarRgb_U8(data, (Planar<GrayU8>)ms);
                return;
            } else {
                if (ms.getBandType() != GrayF32.class) throw new IllegalArgumentException("Unsupported output band format");
                ImplConvertYV12.yv12ToPlanarRgb_F32(data, (Planar<GrayF32>)ms);
            }
            return;
        } else if (output instanceof ImageGray) {
            if (output.getClass() == GrayU8.class) {
                ConvertYV12.yu12ToGray(data, width, height, (GrayU8)output);
                return;
            } else {
                if (output.getClass() != GrayF32.class) throw new IllegalArgumentException("Unsupported output type");
                ConvertYV12.yu12ToGray(data, width, height, (GrayF32)output);
            }
            return;
        } else {
            if (!(output instanceof ImageInterleaved)) throw new IllegalArgumentException("Boofcv image type not yet supported");
            ((ImageMultiBand)output).reshape(width, height, 3);
            if (BoofConcurrency.USE_CONCURRENT) {
                if (output.getClass() == InterleavedU8.class) {
                    ImplConvertYV12_MT.yv12ToInterleaved(data, (InterleavedU8)output);
                    return;
                } else {
                    if (output.getClass() != InterleavedF32.class) throw new IllegalArgumentException("Unsupported output type");
                    ImplConvertYV12_MT.yv12ToInterleaved(data, (InterleavedF32)output);
                }
                return;
            } else if (output.getClass() == InterleavedU8.class) {
                ImplConvertYV12.yv12ToInterleaved(data, (InterleavedU8)output);
                return;
            } else {
                if (output.getClass() != InterleavedF32.class) throw new IllegalArgumentException("Unsupported output type");
                ImplConvertYV12.yv12ToInterleaved(data, (InterleavedF32)output);
            }
        }
    }

    public static GrayU8 yu12ToGray(byte[] data, int width, int height, GrayU8 output) {
        if (output != null) {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
        } else {
            output = new GrayU8(width, height);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToGray(data, output);
        } else {
            ImplConvertNV21.nv21ToGray(data, output);
        }
        return output;
    }

    public static GrayF32 yu12ToGray(byte[] data, int width, int height, GrayF32 output) {
        if (output != null) {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
        } else {
            output = new GrayF32(width, height);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToGray(data, output);
        } else {
            ImplConvertNV21.nv21ToGray(data, output);
        }
        return output;
    }
}

