/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.census;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.abst.transform.census.FilterCensusTransformD33U8;
import boofcv.abst.transform.census.FilterCensusTransformD55S32;
import boofcv.abst.transform.census.FilterCensusTransformSampleS64;
import boofcv.alg.transform.census.CensusTransform;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.transform.census.CensusVariants;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;

public class FactoryCensusTransform {
    public static BorderType CENSUS_BORDER = BorderType.REFLECT;

    public static <In extends ImageGray<In>, Out extends ImageBase<Out>> FilterImageInterface<In, Out> variant(CensusVariants type, Class<In> imageType) {
        switch (type) {
            case BLOCK_3_3: {
                return FactoryCensusTransform.blockDense(1, imageType);
            }
            case BLOCK_5_5: {
                return FactoryCensusTransform.blockDense(2, imageType);
            }
            case BLOCK_7_7: {
                return FactoryCensusTransform.blockDense(3, imageType);
            }
            case BLOCK_9_7: {
                return FactoryCensusTransform.blockDense(4, 3, imageType);
            }
            case BLOCK_13_5: {
                return FactoryCensusTransform.blockDense(5, 2, imageType);
            }
            case CIRCLE_9: {
                FastQueue<Point2D_I32> points = CensusTransform.createCircleSamples();
                return new FilterCensusTransformSampleS64<In>(points, FactoryImageBorder.single(CENSUS_BORDER, imageType), imageType);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public static <In extends ImageGray<In>, Out extends ImageBase<Out>> FilterImageInterface<In, Out> blockDense(int radius, Class<In> imageType) {
        switch (radius) {
            case 1: {
                return new FilterCensusTransformD33U8<In>(FactoryImageBorder.single(CENSUS_BORDER, imageType), imageType);
            }
            case 2: {
                return new FilterCensusTransformD55S32<In>(FactoryImageBorder.single(CENSUS_BORDER, imageType), imageType);
            }
            case 3: {
                FastQueue<Point2D_I32> points7x7 = CensusTransform.createBlockSamples(3);
                return new FilterCensusTransformSampleS64<In>(points7x7, FactoryImageBorder.single(CENSUS_BORDER, imageType), imageType);
            }
        }
        throw new IllegalArgumentException("Currently only radius 1 to 3 is supported");
    }

    public static <In extends ImageGray<In>, Out extends ImageBase<Out>> FilterImageInterface<In, Out> blockDense(int radiusX, int radiusY, Class<In> imageType) {
        FastQueue<Point2D_I32> points = CensusTransform.createBlockSamples(radiusX, radiusY);
        return new FilterCensusTransformSampleS64<In>(points, FactoryImageBorder.single(CENSUS_BORDER, imageType), imageType);
    }
}

