/*
 * Decompiled with CFR 0.152.
 */
package boofcv.testing;

import boofcv.concurrency.WorkArrays;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageGray;
import boofcv.core.image.GImageMultiBand;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;

public class BoofTesting {
    public static <T> T convertToGenericType(Class<?> type) {
        if (type == GrayS8.class || type == GrayU8.class) {
            return (T)GrayI8.class;
        }
        if (type == GrayS16.class || type == GrayU16.class) {
            return (T)GrayI16.class;
        }
        if (type == InterleavedS8.class || type == InterleavedU8.class) {
            return (T)InterleavedI8.class;
        }
        if (type == InterleavedS16.class || type == InterleavedU16.class) {
            return (T)InterleavedI16.class;
        }
        return (T)type;
    }

    public static ImageDataType convertToGenericType(ImageDataType type) {
        if (type.isInteger()) {
            if (type.getNumBits() == 8) {
                return ImageDataType.I8;
            }
            if (type.getNumBits() == 16) {
                return ImageDataType.I16;
            }
        }
        return type;
    }

    public static <T extends ImageBase<T>> T createSubImageOf(T input) {
        if (input instanceof ImageGray) {
            return (T)BoofTesting.createSubImageOf_S((ImageGray)input);
        }
        if (input instanceof Planar) {
            return (T)BoofTesting.createSubImageOf_PL((Planar)input);
        }
        if (input instanceof ImageInterleaved) {
            return (T)BoofTesting.createSubImageOf_I((ImageInterleaved)input);
        }
        throw new IllegalArgumentException("Add support for this image type");
    }

    public static <T extends ImageGray<T>> T createSubImageOf_S(T input) {
        ImageGray ret = (ImageGray)input.createNew(input.width + 10, input.height + 12);
        ret = ret.subimage(5, 7, input.width + 5, input.height + 7, null);
        ret.setTo(input);
        return (T)ret;
    }

    public static <T extends ImageInterleaved<T>> T createSubImageOf_I(T input) {
        ImageInterleaved ret = (ImageInterleaved)input.createNew(input.width + 10, input.height + 12);
        ret = ret.subimage(5, 7, input.width + 5, input.height + 7, null);
        ret.setTo(input);
        return (T)ret;
    }

    public static <T extends Planar> T createSubImageOf_PL(T input) {
        Planar ret = new Planar(input.type, input.width, input.height, input.getNumBands());
        for (int i = 0; i < input.getNumBands(); ++i) {
            ret.bands[i] = BoofTesting.createSubImageOf_S(input.getBand(i));
        }
        ret.stride = ret.bands[0].stride;
        ret.startIndex = ret.bands[0].startIndex;
        return (T)ret;
    }

    public static void checkImageDimensionValidation(Object testClass, int numFunctions) {
        Method[] methods;
        int count = 0;
        for (Method m : methods = testClass.getClass().getMethods()) {
            if (!BoofTesting.areAllInputsImages(m)) continue;
            Class<?>[] params = m.getParameterTypes();
            Object[] inputs = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                inputs[i] = GeneralizedImageOps.createSingleBand(params[i], (int)10, (int)20);
            }
            try {
                m.invoke(testClass, inputs);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (int target = 0; target < params.length; ++target) {
                for (int i = 0; i < params.length; ++i) {
                    inputs[i] = i != target ? GeneralizedImageOps.createSingleBand(params[i], (int)10, (int)20) : GeneralizedImageOps.createSingleBand(params[i], (int)11, (int)22);
                }
                try {
                    m.invoke(testClass, inputs);
                    throw new RuntimeException("Expected an exception here");
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException().getClass() == IllegalArgumentException.class) continue;
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++count;
        }
        if (count != numFunctions) {
            throw new RuntimeException("Unexpected number of functions");
        }
    }

    public static void checkImageDimensionReshape(Object testClass, int numFunctions) {
        Method[] methods;
        int count = 0;
        for (Method m : methods = testClass.getClass().getMethods()) {
            if (!BoofTesting.areAllInputsImages(m)) continue;
            Class<?>[] params = m.getParameterTypes();
            Object[] inputs = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                inputs[i] = GeneralizedImageOps.createSingleBand(params[i], (int)10, (int)20);
            }
            try {
                m.invoke(testClass, inputs);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (int target = 1; target < params.length; ++target) {
                int i;
                for (i = 0; i < params.length; ++i) {
                    inputs[i] = i != target ? GeneralizedImageOps.createSingleBand(params[i], (int)10, (int)20) : GeneralizedImageOps.createSingleBand(params[i], (int)11, (int)22);
                }
                try {
                    m.invoke(testClass, inputs);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                for (i = 1; i < params.length; ++i) {
                    if (10 == ((ImageBase)inputs[i]).width && 20 == ((ImageBase)inputs[i]).height) continue;
                    throw new RuntimeException("Wasn't reshaped");
                }
            }
            ++count;
        }
        if (count != numFunctions) {
            throw new RuntimeException("Unexpected number of functions. cnt=" + count + " funcs=" + numFunctions);
        }
    }

    private static boolean areAllInputsImages(Method m) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length == 0) {
            return false;
        }
        for (Class<?> p : params) {
            if (ImageGray.class.isAssignableFrom(p)) continue;
            return false;
        }
        return true;
    }

    public static void checkSubImage(Object testClass, String function, boolean checkEquals, Object ... inputParam) {
        try {
            int i;
            ImageBase[] larger = new ImageBase[inputParam.length];
            ImageBase[] subImg = new ImageBase[inputParam.length];
            Class[] paramDesc = new Class[inputParam.length];
            Object[] inputModified = new Object[inputParam.length];
            for (int i2 = 0; i2 < inputParam.length; ++i2) {
                if (ImageBase.class.isAssignableFrom(inputParam[i2].getClass())) {
                    ImageBase img = (ImageBase)inputParam[i2];
                    larger[i2] = img.createNew(img.getWidth() + 10, img.getHeight() + 12);
                    subImg[i2] = larger[i2].subimage(5, 6, 5 + img.getWidth(), 6 + img.getHeight(), null);
                    subImg[i2].setTo(img);
                }
                inputModified[i2] = inputParam[i2];
                paramDesc[i2] = inputParam[i2].getClass();
            }
            Method m = BoofTesting.findMethod(testClass.getClass(), function, paramDesc);
            m.invoke(testClass, inputModified);
            for (i = 0; i < inputModified.length; ++i) {
                if (subImg[i] == null) continue;
                inputModified[i] = subImg[i];
            }
            m.invoke(testClass, inputModified);
            if (checkEquals) {
                for (i = 0; i < inputParam.length; ++i) {
                    if (subImg[i] == null) continue;
                    BoofTesting.assertEquals((ImageBase)inputModified[i], subImg[i], 0.0);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findMethod(Class<?> type, String name, Class<?> ... params) {
        Method[] methods = type.getMethods();
        ArrayList<Method> found = new ArrayList<Method>();
        for (Method m : methods) {
            int i;
            Class<?>[] a;
            if (m.getName().compareTo(name) != 0 || (a = m.getParameterTypes()).length != params.length) continue;
            boolean match = true;
            for (i = 0; i < a.length; ++i) {
                if (a[i] == params[i]) continue;
                match = false;
                break;
            }
            if (match) {
                return m;
            }
            match = true;
            for (i = 0; i < a.length; ++i) {
                if (params[i] == a[i] || a[i].isPrimitive() && (a[i] == Boolean.TYPE && params[i] == Boolean.class || a[i] == Byte.TYPE && params[i] == Byte.class || a[i] == Short.TYPE && params[i] == Short.class || a[i] == Integer.TYPE && params[i] == Integer.class || a[i] == Long.TYPE && params[i] == Long.class || a[i] == Float.TYPE && params[i] == Float.class || a[i] == Double.TYPE && params[i] == Double.class) || a[i].isAssignableFrom(params[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            found.add(m);
        }
        if (found.size() == 1) {
            return (Method)found.get(0);
        }
        throw new RuntimeException("Couldn't find matching *public* function to " + name);
    }

    public static void callStaticMethod(Class<?> classType, String name, Object ... inputs) {
        Class[] params = new Class[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            params[i] = inputs[i].getClass();
        }
        Method m = BoofTesting.findMethod(classType, name, params);
        if (m == null) {
            for (int i = 0; i < inputs.length; ++i) {
                if (params[i] == Integer.class) {
                    params[i] = Integer.TYPE;
                    continue;
                }
                if (params[i] == Float.class) {
                    params[i] = Float.TYPE;
                    continue;
                }
                if (params[i] != Double.class) continue;
                params[i] = Double.TYPE;
            }
            m = BoofTesting.findMethod(classType, name, params);
        }
        if (m == null) {
            throw new IllegalArgumentException("Method not found");
        }
        try {
            m.invoke(null, inputs);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static int findMethodThenCall(Object owner, String ownerMethod, Class target, String targetMethod) {
        int total = 0;
        Method[] list = target.getMethods();
        try {
            Method om = owner.getClass().getMethod(ownerMethod, Method.class);
            for (Method m : list) {
                if (!m.getName().equals(targetMethod)) continue;
                om.invoke(owner, m);
                ++total;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return total;
    }

    public static void assertEquals(double[] a, double[] b, double tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - b[i]);
            if (!(diff > tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(double[] a, float[] b, double tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - (double)b[i]);
            if (!(diff > tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(double[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs((int)a[i] - b[i]);
            if (diff == 0.0) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(byte[] a, byte[] b) {
        for (int i = 0; i < a.length; ++i) {
            int diff = Math.abs(a[i] - b[i]);
            if (diff == 0) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(short[] a, short[] b) {
        for (int i = 0; i < a.length; ++i) {
            int diff = Math.abs(a[i] - b[i]);
            if (diff == 0) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            int diff = Math.abs(a[i] - b[i]);
            if (diff == 0) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(long[] a, long[] b) {
        for (int i = 0; i < a.length; ++i) {
            long diff = Math.abs(a[i] - b[i]);
            if (diff == 0L) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(float[] a, float[] b, float tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - b[i]);
            if (!(diff > (double)tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(ImageBase imgA, ImageBase imgB, double tol) {
        if (imgA instanceof ImageGray) {
            GImageGray a = FactoryGImageGray.wrap((ImageGray)((ImageGray)imgA));
            GImageGray b = FactoryGImageGray.wrap((ImageGray)((ImageGray)imgB));
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    double valB;
                    double valA = a.get(x, y).doubleValue();
                    double difference = valA - (valB = b.get(x, y).doubleValue());
                    if (!(Math.abs(difference) > tol)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof Planar && imgB instanceof Planar) {
            Planar a = (Planar)imgA;
            Planar b = (Planar)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEquals((ImageBase)a.getBand(band), (ImageBase)b.getBand(band), tol);
            }
        } else if (imgA instanceof ImageMultiBand && imgB instanceof ImageMultiBand) {
            ImageMultiBand a = (ImageMultiBand)imgA;
            ImageMultiBand b = (ImageMultiBand)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            int numBands = a.getNumBands();
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    for (int band = 0; band < numBands; ++band) {
                        double valB;
                        double valA = GeneralizedImageOps.get((ImageBase)a, (int)x, (int)y, (int)band);
                        double difference = valA - (valB = GeneralizedImageOps.get((ImageBase)b, (int)x, (int)y, (int)band));
                        if (!(Math.abs(difference) > tol)) continue;
                        throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                    }
                }
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsInner(ImageBase imgA, ImageBase imgB, double tol, int borderX, int borderY, boolean relative) {
        if (imgA instanceof ImageGray) {
            GImageGray a = FactoryGImageGray.wrap((ImageGray)((ImageGray)imgA));
            GImageGray b = FactoryGImageGray.wrap((ImageGray)((ImageGray)imgB));
            for (int y = borderY; y < imgA.height - borderY; ++y) {
                for (int x = borderX; x < imgA.width - borderX; ++x) {
                    double valA = a.get(x, y).doubleValue();
                    double valB = b.get(x, y).doubleValue();
                    double error = Math.abs(valA - valB);
                    if (relative) {
                        double denominator = Math.abs(valA) + Math.abs(valB);
                        if (denominator == 0.0) {
                            denominator = 1.0;
                        }
                        error /= denominator;
                    }
                    if (!(error > tol)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof Planar) {
            Planar a = (Planar)imgA;
            Planar b = (Planar)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEqualsInner((ImageBase)a.getBand(band), (ImageBase)b.getBand(band), tol, borderX, borderY, relative);
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsInner(ImageBase imgA, ImageBase imgB, double tol, int borderX0, int borderY0, int borderX1, int borderY1, boolean relative) {
        if (imgA instanceof ImageGray) {
            GImageGray a = FactoryGImageGray.wrap((ImageGray)((ImageGray)imgA));
            GImageGray b = FactoryGImageGray.wrap((ImageGray)((ImageGray)imgB));
            for (int y = borderY0; y < imgA.height - borderY1; ++y) {
                for (int x = borderX0; x < imgA.width - borderX1; ++x) {
                    double valA = a.get(x, y).doubleValue();
                    double valB = b.get(x, y).doubleValue();
                    double error = Math.abs(valA - valB);
                    if (relative) {
                        double denominator = Math.abs(valA) + Math.abs(valB);
                        if (denominator == 0.0) {
                            denominator = 1.0;
                        }
                        error /= denominator;
                    }
                    if (!(error > tol)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof ImageInterleaved) {
            GImageMultiBand a = FactoryGImageMultiBand.wrap((ImageInterleaved)((ImageInterleaved)imgA));
            GImageMultiBand b = FactoryGImageMultiBand.wrap((ImageInterleaved)((ImageInterleaved)imgB));
            int numBands = a.getNumberOfBands();
            for (int y = borderY0; y < imgA.height - borderY1; ++y) {
                for (int x = borderX0; x < imgA.width - borderX1; ++x) {
                    for (int band = 0; band < numBands; ++band) {
                        double valA = a.get(x, y, band).doubleValue();
                        double valB = b.get(x, y, band).doubleValue();
                        double error = Math.abs(valA - valB);
                        if (relative) {
                            double denominator = Math.abs(valA) + Math.abs(valB);
                            if (denominator == 0.0) {
                                denominator = 1.0;
                            }
                            error /= denominator;
                        }
                        if (!(error > tol)) continue;
                        throw new RuntimeException("Values not equal at (" + x + "," + y + "," + band + ") " + valA + "  " + valB);
                    }
                }
            }
        } else if (imgA instanceof Planar) {
            Planar a = (Planar)imgA;
            Planar b = (Planar)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEqualsInner((ImageBase)a.getBand(band), (ImageBase)b.getBand(band), tol, borderX0, borderY0, borderX1, borderY1, relative);
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsRelative(ImageBase imgA, ImageBase imgB, double tolFrac) {
        if (imgA instanceof ImageGray) {
            GImageGray a = FactoryGImageGray.wrap((ImageGray)((ImageGray)imgA));
            GImageGray b = FactoryGImageGray.wrap((ImageGray)((ImageGray)imgB));
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    double valA = a.get(x, y).doubleValue();
                    double valB = b.get(x, y).doubleValue();
                    double difference = valA - valB;
                    double max = Math.max(Math.abs(valA), Math.abs(valB));
                    if (max == 0.0) {
                        max = 1.0;
                    }
                    if (!(Math.abs(difference) / max > tolFrac)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof ImageInterleaved) {
            GImageMultiBand a = FactoryGImageMultiBand.wrap((ImageBase)imgA);
            GImageMultiBand b = FactoryGImageMultiBand.wrap((ImageBase)imgB);
            float[] valueA = new float[a.getNumberOfBands()];
            float[] valueB = new float[b.getNumberOfBands()];
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    a.get(x, y, valueA);
                    b.get(x, y, valueB);
                    for (int i = 0; i < a.getNumberOfBands(); ++i) {
                        double valA = valueA[i];
                        double valB = valueB[i];
                        double difference = valA - valB;
                        double max = Math.max(Math.abs(valA), Math.abs(valB));
                        if (max == 0.0) {
                            max = 1.0;
                        }
                        if (!(Math.abs(difference) / max > tolFrac)) continue;
                        throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                    }
                }
            }
        } else if (imgA instanceof Planar) {
            Planar a = (Planar)imgA;
            Planar b = (Planar)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEqualsRelative((ImageBase)a.getBand(band), (ImageBase)b.getBand(band), tolFrac);
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsBorder(ImageBase imgA, ImageBase imgB, double tol, int borderX, int borderY) {
        if (imgA instanceof ImageGray) {
            BoofTesting.assertEqualsBorder((ImageGray)imgA, (ImageGray)imgB, tol, borderX, borderY);
        } else if (imgA instanceof ImageInterleaved) {
            BoofTesting.assertEqualsBorder((ImageInterleaved)imgA, (ImageInterleaved)imgB, tol, borderX, borderY);
        } else {
            throw new RuntimeException("Unsupported image type");
        }
    }

    public static void assertEqualsBorder(ImageGray imgA, ImageGray imgB, double tol, int borderX, int borderY) {
        if (imgA.getWidth() != imgB.getWidth()) {
            throw new RuntimeException("Widths are not equals");
        }
        if (imgA.getHeight() != imgB.getHeight()) {
            throw new RuntimeException("Heights are not equals");
        }
        GImageGray a = FactoryGImageGray.wrap((ImageGray)imgA);
        GImageGray b = FactoryGImageGray.wrap((ImageGray)imgB);
        for (int y = 0; y < imgA.getHeight(); ++y) {
            int x;
            for (x = 0; x < borderX; ++x) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
            for (x = imgA.getWidth() - borderX; x < imgA.getWidth(); ++x) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
        }
        for (int x = borderX; x < imgA.getWidth() - borderX; ++x) {
            int y;
            for (y = 0; y < borderY; ++y) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
            for (y = imgA.getHeight() - borderY; y < imgA.getHeight(); ++y) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
        }
    }

    public static void assertEqualsBorder(ImageInterleaved imgA, ImageInterleaved imgB, double tol, int borderX, int borderY) {
        int band;
        if (imgA.getWidth() != imgB.getWidth()) {
            throw new RuntimeException("Widths are not equals");
        }
        if (imgA.getHeight() != imgB.getHeight()) {
            throw new RuntimeException("Heights are not equals");
        }
        int numBands = imgA.numBands;
        GImageMultiBand a = FactoryGImageMultiBand.wrap((ImageInterleaved)imgA);
        GImageMultiBand b = FactoryGImageMultiBand.wrap((ImageInterleaved)imgB);
        for (int y = 0; y < imgA.getHeight(); ++y) {
            int x;
            for (x = 0; x < borderX; ++x) {
                for (band = 0; band < numBands; ++band) {
                    BoofTesting.compareValues(tol, a, b, x, y, band);
                }
            }
            for (x = imgA.getWidth() - borderX; x < imgA.getWidth(); ++x) {
                for (band = 0; band < numBands; ++band) {
                    BoofTesting.compareValues(tol, a, b, x, y, band);
                }
            }
        }
        for (int x = borderX; x < imgA.getWidth() - borderX; ++x) {
            int y;
            for (y = 0; y < borderY; ++y) {
                for (band = 0; band < numBands; ++band) {
                    BoofTesting.compareValues(tol, a, b, x, y, band);
                }
            }
            for (y = imgA.getHeight() - borderY; y < imgA.getHeight(); ++y) {
                for (band = 0; band < numBands; ++band) {
                    BoofTesting.compareValues(tol, a, b, x, y, band);
                }
            }
        }
    }

    private static void compareValues(double tol, GImageGray a, GImageGray b, int x, int y) {
        double normalizer = Math.abs(a.get(x, y).doubleValue()) + Math.abs(b.get(x, y).doubleValue());
        if (normalizer < 1.0) {
            normalizer = 1.0;
        }
        if (Math.abs(a.get(x, y).doubleValue() - b.get(x, y).doubleValue()) / normalizer > tol) {
            throw new RuntimeException("values not equal at (" + x + " " + y + ") " + a.get(x, y) + "  " + b.get(x, y));
        }
    }

    private static void compareValues(double tol, GImageMultiBand a, GImageMultiBand b, int x, int y, int band) {
        double normalizer = Math.abs(a.get(x, y, band).doubleValue()) + Math.abs(b.get(x, y, band).doubleValue());
        if (normalizer < 1.0) {
            normalizer = 1.0;
        }
        if (Math.abs(a.get(x, y, band).doubleValue() - b.get(x, y, band).doubleValue()) / normalizer > tol) {
            throw new RuntimeException("values not equal at (" + x + " " + y + " " + band + ") " + a.get(x, y, band) + "  " + b.get(x, y, band));
        }
    }

    public static void checkBorderZero(ImageGray outputImage, int border) {
        GImageGray img = FactoryGImageGray.wrap((ImageGray)outputImage);
        for (int y = 0; y < img.getHeight(); ++y) {
            if (y >= border && y < img.getHeight() - border) continue;
            for (int x = 0; x < img.getWidth(); ++x) {
                if (x >= border && x < img.getWidth() - border || img.get(x, y).intValue() == 0) continue;
                throw new RuntimeException("The border is not zero: " + x + " " + y);
            }
        }
    }

    public static void checkBorderZero(ImageGray outputImage, int borderX0, int borderY0, int borderX1, int borderY1) {
        GImageGray img = FactoryGImageGray.wrap((ImageGray)outputImage);
        for (int y = 0; y < img.getHeight(); ++y) {
            if (y >= borderY0 && y < img.getHeight() - borderY1) continue;
            for (int x = 0; x < img.getWidth(); ++x) {
                if (x >= borderX0 && x < img.getWidth() - borderX1 || img.get(x, y).intValue() == 0) continue;
                throw new RuntimeException("The border is not zero: " + x + " " + y);
            }
        }
    }

    public static void printDiff(ImageGray imgA, ImageGray imgB) {
        GImageGray a = FactoryGImageGray.wrap((ImageGray)imgA);
        GImageGray b = FactoryGImageGray.wrap((ImageGray)imgB);
        System.out.println("------- Difference -----------");
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                double diff = Math.abs(a.get(x, y).doubleValue() - b.get(x, y).doubleValue());
                System.out.printf("%2d ", (int)diff);
            }
            System.out.println();
        }
    }

    public static void printDiffBinary(GrayU8 imgA, GrayU8 imgB) {
        System.out.println("------- Difference -----------");
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                if (imgA.unsafe_get(x, y) != imgB.unsafe_get(x, y)) {
                    System.out.print(" x");
                    continue;
                }
                System.out.print(" .");
            }
            System.out.println();
        }
    }

    public static Object randomArray(Class type, int length, Random rand) {
        Object[] ret;
        if (type == byte[].class) {
            byte[] data = new byte[length];
            for (int i = 0; i < length; ++i) {
                data[i] = (byte)(rand.nextInt(255) + -128);
            }
            ret = data;
        } else if (type == short[].class) {
            short[] data = new short[length];
            for (int i = 0; i < length; ++i) {
                data[i] = (short)(rand.nextInt(65535) + Short.MIN_VALUE);
            }
            ret = data;
        } else if (type == int[].class) {
            int[] data = new int[length];
            for (int i = 0; i < length; ++i) {
                data[i] = rand.nextInt(1000) - 500;
            }
            ret = data;
        } else if (type == long[].class) {
            long[] data = new long[length];
            for (int i = 0; i < length; ++i) {
                data[i] = rand.nextLong();
            }
            ret = data;
        } else if (type == float[].class) {
            float[] data = new float[length];
            for (int i = 0; i < length; ++i) {
                data[i] = rand.nextFloat() - 0.5f;
            }
            ret = data;
        } else if (type == double[].class) {
            double[] data = new double[length];
            for (int i = 0; i < length; ++i) {
                data[i] = rand.nextDouble() - 0.5;
            }
            ret = data;
        } else {
            throw new RuntimeException("Unknown. " + type.getSimpleName());
        }
        return ret;
    }

    public static Object primitive(Object v, Class type) {
        Number value = (Number)v;
        if (type == Byte.TYPE) {
            return value.byteValue();
        }
        if (type == Short.TYPE) {
            return value.shortValue();
        }
        if (type == Integer.TYPE) {
            return value.intValue();
        }
        if (type == Long.TYPE) {
            return value.longValue();
        }
        if (type == Float.TYPE) {
            return Float.valueOf(value.floatValue());
        }
        if (type == Double.TYPE) {
            return value.doubleValue();
        }
        throw new RuntimeException("Unknown. " + type.getSimpleName());
    }

    public static Object createInstance(Class type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static WorkArrays createWorkArray(Class type, int length) {
        WorkArrays w = (WorkArrays)BoofTesting.createInstance(type);
        w.reset(length);
        return w;
    }
}

