/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.concurrency.DWorkArrays;
import boofcv.concurrency.FWorkArrays;
import boofcv.concurrency.IWorkArrays;
import boofcv.concurrency.WorkArrays;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import javax.annotation.Nullable;

public class GBlurImageOps {
    public static <T extends ImageBase<T>> T mean(T input, @Nullable T output, int radius, @Nullable ImageBase storage, @Nullable WorkArrays workVert) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.mean((GrayU8)input, (GrayU8)output, radius, (GrayU8)storage, (IWorkArrays)workVert);
        }
        if (input instanceof GrayU16) {
            return (T)BlurImageOps.mean((GrayU16)input, (GrayU16)output, radius, (GrayU16)storage, (IWorkArrays)workVert);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.mean((GrayF32)input, (GrayF32)output, radius, (GrayF32)storage, (FWorkArrays)workVert);
        }
        if (input instanceof GrayF64) {
            return (T)BlurImageOps.mean((GrayF64)input, (GrayF64)output, radius, (GrayF64)storage, (DWorkArrays)workVert);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.mean((Planar)input, (Planar)output, radius, (ImageGray)storage, workVert);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageBase<T>> T mean(T input, @Nullable T output, int radiusX, int radiusY, @Nullable ImageBase storage, @Nullable WorkArrays workVert) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.mean((GrayU8)input, (GrayU8)output, radiusX, radiusY, (GrayU8)storage, (IWorkArrays)workVert);
        }
        if (input instanceof GrayU16) {
            return (T)BlurImageOps.mean((GrayU16)input, (GrayU16)output, radiusX, radiusY, (GrayU16)storage, (IWorkArrays)workVert);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.mean((GrayF32)input, (GrayF32)output, radiusX, radiusY, (GrayF32)storage, (FWorkArrays)workVert);
        }
        if (input instanceof GrayF64) {
            return (T)BlurImageOps.mean((GrayF64)input, (GrayF64)output, radiusX, radiusY, (GrayF64)storage, (DWorkArrays)workVert);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.mean((Planar)input, (Planar)output, radiusX, radiusY, (ImageGray)storage, workVert);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageBase<T>> T meanB(T input, @Nullable T output, int radiusX, int radiusY, @Nullable ImageBorder<T> border, @Nullable ImageBase storage, @Nullable WorkArrays workVert) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.meanB((GrayU8)input, (GrayU8)output, radiusX, radiusY, (ImageBorder_S32<GrayU8>)((ImageBorder_S32)border), (GrayU8)storage, (IWorkArrays)workVert);
        }
        if (input instanceof GrayU16) {
            return (T)BlurImageOps.meanB((GrayU16)input, (GrayU16)output, radiusX, radiusY, (ImageBorder_S32<GrayU16>)((ImageBorder_S32)border), (GrayU16)storage, (IWorkArrays)workVert);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.meanB((GrayF32)input, (GrayF32)output, radiusX, radiusY, (ImageBorder_F32)border, (GrayF32)storage, (FWorkArrays)workVert);
        }
        if (input instanceof GrayF64) {
            return (T)BlurImageOps.meanB((GrayF64)input, (GrayF64)output, radiusX, radiusY, (ImageBorder_F64)border, (GrayF64)storage, (DWorkArrays)workVert);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.meanB((Planar)input, (Planar)output, radiusX, radiusY, border, (ImageGray)storage, workVert);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageBase<T>> T median(T input, @Nullable T output, int radius, @Nullable WorkArrays work) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.median((GrayU8)input, (GrayU8)output, radius, (IWorkArrays)work);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.median((GrayF32)input, (GrayF32)output, radius);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.median((Planar)input, (Planar)output, radius, work);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageBase<T>> T gaussian(T input, @Nullable T output, double sigma, int radius, @Nullable ImageBase storage) {
        return GBlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static <T extends ImageBase<T>> T gaussian(T input, @Nullable T output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable ImageBase storage) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayU8) {
                    return (T)BlurImageOps.gaussian((GrayU8)input, (GrayU8)output, sigmaX, radiusX, sigmaY, radiusY, (GrayU8)storage);
                }
                if (input instanceof GrayU16) {
                    return (T)BlurImageOps.gaussian((GrayU16)input, (GrayU16)output, sigmaX, radiusX, sigmaY, radiusY, (GrayU16)storage);
                }
                if (input instanceof GrayF32) {
                    return (T)BlurImageOps.gaussian((GrayF32)input, (GrayF32)output, sigmaX, radiusX, sigmaY, radiusY, (GrayF32)storage);
                }
                if (input instanceof GrayF64) {
                    return (T)BlurImageOps.gaussian((GrayF64)input, (GrayF64)output, sigmaX, radiusX, sigmaY, radiusY, (GrayF64)storage);
                }
                throw new IllegalArgumentException("Unsupported image type: " + input.getClass().getSimpleName());
            }
            case INTERLEAVED: {
                if (input instanceof InterleavedU8) {
                    return (T)BlurImageOps.gaussian((InterleavedU8)input, (InterleavedU8)output, sigmaX, radiusX, sigmaY, radiusY, (InterleavedU8)storage);
                }
                if (input instanceof InterleavedU16) {
                    return (T)BlurImageOps.gaussian((InterleavedU16)input, (InterleavedU16)output, sigmaX, radiusX, sigmaY, radiusY, (InterleavedU16)storage);
                }
                if (input instanceof InterleavedF32) {
                    return (T)BlurImageOps.gaussian((InterleavedF32)input, (InterleavedF32)output, sigmaX, radiusX, sigmaY, radiusY, (InterleavedF32)storage);
                }
                if (input instanceof InterleavedF64) {
                    return (T)BlurImageOps.gaussian((InterleavedF64)input, (InterleavedF64)output, sigmaX, radiusX, sigmaY, radiusY, (InterleavedF64)storage);
                }
                throw new IllegalArgumentException("Unsupported image type: " + input.getClass().getSimpleName());
            }
            case PLANAR: {
                return (T)BlurImageOps.gaussian((Planar)input, (Planar)output, sigmaX, radiusX, sigmaY, radiusY, (ImageGray)storage);
            }
        }
        throw new IllegalArgumentException("Unknown image family");
    }
}

