/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.filter.convolve.BOverrideConvolveImageMean;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General_SB;
import boofcv.alg.filter.convolve.noborder.ImplConvolveMean;
import boofcv.alg.filter.convolve.noborder.ImplConvolveMean_MT;
import boofcv.alg.filter.convolve.normalized.ConvolveNormalized_JustBorder_SB;
import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.DWorkArrays;
import boofcv.concurrency.FWorkArrays;
import boofcv.concurrency.IWorkArrays;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import javax.annotation.Nullable;

public class ConvolveImageMean {
    public static void horizontal(GrayU8 input, GrayI8 output, int offset, int length) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
        if (length > input.width) {
            ConvolveImageNormalized.horizontal(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayU8 input, GrayI8 output, int offset, int length, @Nullable IWorkArrays work) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
        if (length > input.height) {
            ConvolveImageNormalized.vertical(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayU8 input, GrayI8 output, int offset, int length, @Nullable ImageBorder_S32<GrayU8> binput) {
        output.reshape(input.width, output.height);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
            ConvolveJustBorder_General_SB.horizontal(kernel, binput, output, kernel.computeSum());
        }
        if (length <= input.width) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayU8 input, GrayI8 output, int offset, int length, @Nullable ImageBorder_S32<GrayU8> binput, @Nullable IWorkArrays work) {
        output.reshape((ImageBase)input);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
            ConvolveJustBorder_General_SB.vertical(kernel, binput, output, kernel.computeSum());
        }
        if (length <= input.height) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int offset, int length) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
        if (length > input.width) {
            ConvolveImageNormalized.horizontal(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayS16 input, GrayI16 output, int offset, int length, @Nullable IWorkArrays work) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
        if (length > input.height) {
            ConvolveImageNormalized.vertical(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int offset, int length, @Nullable ImageBorder_S32<GrayS16> binput) {
        output.reshape(input.width, output.height);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
            ConvolveJustBorder_General_SB.horizontal(kernel, binput, output, kernel.computeSum());
        }
        if (length <= input.width) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayS16 input, GrayI16 output, int offset, int length, @Nullable ImageBorder_S32<GrayS16> binput, @Nullable IWorkArrays work) {
        output.reshape((ImageBase)input);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
            ConvolveJustBorder_General_SB.vertical(kernel, binput, output, kernel.computeSum());
        }
        if (length <= input.height) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayU16 input, GrayI16 output, int offset, int length) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
        if (length > input.width) {
            ConvolveImageNormalized.horizontal(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayU16 input, GrayI16 output, int offset, int length, @Nullable IWorkArrays work) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
        if (length > input.height) {
            ConvolveImageNormalized.vertical(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayU16 input, GrayI16 output, int offset, int length, @Nullable ImageBorder_S32<GrayU16> binput) {
        output.reshape(input.width, output.height);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
            ConvolveJustBorder_General_SB.horizontal(kernel, binput, output, kernel.computeSum());
        }
        if (length <= input.width) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayU16 input, GrayI16 output, int offset, int length, @Nullable ImageBorder_S32<GrayU16> binput, @Nullable IWorkArrays work) {
        output.reshape((ImageBase)input);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_S32 kernel = FactoryKernel.table1D_S32(offset, length);
            ConvolveJustBorder_General_SB.vertical(kernel, binput, output, kernel.computeSum());
        }
        if (length <= input.height) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayF32 input, GrayF32 output, int offset, int length) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(offset, length, true);
        if (length > input.width) {
            ConvolveImageNormalized.horizontal(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayF32 input, GrayF32 output, int offset, int length, @Nullable FWorkArrays work) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(offset, length, true);
        if (length > input.height) {
            ConvolveImageNormalized.vertical(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayF32 input, GrayF32 output, int offset, int length, @Nullable ImageBorder_F32 binput) {
        output.reshape(input.width, output.height);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_F32 kernel = FactoryKernel.table1D_F32(offset, length, true);
            ConvolveJustBorder_General_SB.horizontal(kernel, binput, output);
        }
        if (length <= input.width) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayF32 input, GrayF32 output, int offset, int length, @Nullable ImageBorder_F32 binput, @Nullable FWorkArrays work) {
        output.reshape((ImageBase)input);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_F32 kernel = FactoryKernel.table1D_F32(offset, length, true);
            ConvolveJustBorder_General_SB.vertical(kernel, binput, output);
        }
        if (length <= input.height) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayF64 input, GrayF64 output, int offset, int length) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_F64 kernel = FactoryKernel.table1D_F64(offset, length, true);
        if (length > input.width) {
            ConvolveImageNormalized.horizontal(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayF64 input, GrayF64 output, int offset, int length, @Nullable DWorkArrays work) {
        output.reshape((ImageBase)input);
        if (BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, offset, length)) {
            return;
        }
        Kernel1D_F64 kernel = FactoryKernel.table1D_F64(offset, length, true);
        if (length > input.height) {
            ConvolveImageNormalized.vertical(kernel, input, output);
        } else {
            ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }

    public static void horizontal(GrayF64 input, GrayF64 output, int offset, int length, @Nullable ImageBorder_F64 binput) {
        output.reshape(input.width, output.height);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_F64 kernel = FactoryKernel.table1D_F64(offset, length, true);
            ConvolveJustBorder_General_SB.horizontal(kernel, binput, output);
        }
        if (length <= input.width) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.horizontal(input, output, offset, length);
            } else {
                ImplConvolveMean.horizontal(input, output, offset, length);
            }
        }
    }

    public static void vertical(GrayF64 input, GrayF64 output, int offset, int length, @Nullable ImageBorder_F64 binput, @Nullable DWorkArrays work) {
        output.reshape((ImageBase)input);
        if (binput != null) {
            binput.setImage((ImageBase)input);
            Kernel1D_F64 kernel = FactoryKernel.table1D_F64(offset, length, true);
            ConvolveJustBorder_General_SB.vertical(kernel, binput, output);
        }
        if (length <= input.height) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplConvolveMean_MT.vertical(input, output, offset, length, work);
            } else {
                ImplConvolveMean.vertical(input, output, offset, length, work);
            }
        }
    }
}

