/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.DWorkArrays;
import boofcv.concurrency.FWorkArrays;
import boofcv.concurrency.IWorkArrays;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ImplConvolveBox_MT {
    public static void horizontal(GrayU8 input, GrayI16 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = (short)total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFF;
                output.data[indexOut++] = (short)(total += input.data[indexIn] & 0xFF);
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayU8 input, GrayI16 output, int radius, IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        IWorkArrays _work = work;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        BoofConcurrency.loopBlocks((int)radius, (int)(output.height - radius), (int)kernelWidth, (y0, y1) -> {
            int indexIn;
            int indexOut;
            int[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                int total = 0;
                int indexEnd = indexIn + input.stride * kernelWidth;
                for (indexIn = input.startIndex + (y0 - radius) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn] & 0xFF;
                }
                totals[x] = total;
                output.data[indexOut] = (short)total;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + radius) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    int total = totals[x] - (input.data[indexIn - backStep] & 0xFF);
                    totals[x] = total += input.data[indexIn] & 0xFF;
                    output.data[indexOut] = (short)total;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
        });
    }

    public static void horizontal(GrayU8 input, GrayS32 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFF;
                output.data[indexOut++] = total += input.data[indexIn] & 0xFF;
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayU8 input, GrayS32 output, int radius, IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        IWorkArrays _work = work;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        BoofConcurrency.loopBlocks((int)radius, (int)(output.height - radius), (int)kernelWidth, (y0, y1) -> {
            int indexIn;
            int indexOut;
            int[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                int total = 0;
                int indexEnd = indexIn + input.stride * kernelWidth;
                for (indexIn = input.startIndex + (y0 - radius) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn] & 0xFF;
                }
                totals[x] = total;
                output.data[indexOut] = total;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + radius) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    int total = totals[x] - (input.data[indexIn - backStep] & 0xFF);
                    totals[x] = total += input.data[indexIn] & 0xFF;
                    output.data[indexOut] = total;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
        });
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = (short)total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = (short)(total += input.data[indexIn]);
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayS16 input, GrayI16 output, int radius, IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        IWorkArrays _work = work;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        BoofConcurrency.loopBlocks((int)radius, (int)(output.height - radius), (int)kernelWidth, (y0, y1) -> {
            int indexIn;
            int indexOut;
            int[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                int total = 0;
                int indexEnd = indexIn + input.stride * kernelWidth;
                for (indexIn = input.startIndex + (y0 - radius) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn];
                }
                totals[x] = total;
                output.data[indexOut] = (short)total;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + radius) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    int total = totals[x] - input.data[indexIn - backStep];
                    totals[x] = total += input.data[indexIn];
                    output.data[indexOut] = (short)total;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
        });
    }

    public static void horizontal(GrayU16 input, GrayI16 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFFFF;
            }
            output.data[indexOut++] = (short)total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFFFF;
                output.data[indexOut++] = (short)(total += input.data[indexIn] & 0xFFFF);
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayU16 input, GrayI16 output, int radius, IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        IWorkArrays _work = work;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        BoofConcurrency.loopBlocks((int)radius, (int)(output.height - radius), (int)kernelWidth, (y0, y1) -> {
            int indexIn;
            int indexOut;
            int[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                int total = 0;
                int indexEnd = indexIn + input.stride * kernelWidth;
                for (indexIn = input.startIndex + (y0 - radius) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn] & 0xFFFF;
                }
                totals[x] = total;
                output.data[indexOut] = (short)total;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + radius) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    int total = totals[x] - (input.data[indexIn - backStep] & 0xFFFF);
                    totals[x] = total += input.data[indexIn] & 0xFFFF;
                    output.data[indexOut] = (short)total;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
        });
    }

    public static void horizontal(GrayS32 input, GrayS32 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = total += input.data[indexIn];
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayS32 input, GrayS32 output, int radius, IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        IWorkArrays _work = work;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        BoofConcurrency.loopBlocks((int)radius, (int)(output.height - radius), (int)kernelWidth, (y0, y1) -> {
            int indexIn;
            int indexOut;
            int[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                int total = 0;
                int indexEnd = indexIn + input.stride * kernelWidth;
                for (indexIn = input.startIndex + (y0 - radius) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn];
                }
                totals[x] = total;
                output.data[indexOut] = total;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + radius) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    int total = totals[x] - input.data[indexIn - backStep];
                    totals[x] = total += input.data[indexIn];
                    output.data[indexOut] = total;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
        });
    }

    public static void horizontal(GrayF32 input, GrayF32 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            float total = 0.0f;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = total += input.data[indexIn];
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayF32 input, GrayF32 output, int radius, FWorkArrays work) {
        if (work == null) {
            work = new FWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        FWorkArrays _work = work;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        BoofConcurrency.loopBlocks((int)radius, (int)(output.height - radius), (int)kernelWidth, (y0, y1) -> {
            int indexIn;
            int indexOut;
            float[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                float total = 0.0f;
                int indexEnd = indexIn + input.stride * kernelWidth;
                for (indexIn = input.startIndex + (y0 - radius) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn];
                }
                totals[x] = total;
                output.data[indexOut] = total;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + radius) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float total = totals[x] - input.data[indexIn - backStep];
                    totals[x] = total += input.data[indexIn];
                    output.data[indexOut] = total;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
        });
    }

    public static void horizontal(GrayF64 input, GrayF64 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            double total = 0.0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = total += input.data[indexIn];
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayF64 input, GrayF64 output, int radius, DWorkArrays work) {
        if (work == null) {
            work = new DWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        DWorkArrays _work = work;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        BoofConcurrency.loopBlocks((int)radius, (int)(output.height - radius), (int)kernelWidth, (y0, y1) -> {
            int indexIn;
            int indexOut;
            double[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                double total = 0.0;
                int indexEnd = indexIn + input.stride * kernelWidth;
                for (indexIn = input.startIndex + (y0 - radius) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn];
                }
                totals[x] = total;
                output.data[indexOut] = total;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + radius) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    double total = totals[x] - input.data[indexIn - backStep];
                    totals[x] = total += input.data[indexIn];
                    output.data[indexOut] = total;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
        });
    }
}

