/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.alg.filter.misc.ImplAverageDownSample;
import boofcv.alg.filter.misc.ImplAverageDownSample2;
import boofcv.alg.filter.misc.ImplAverageDownSample2_MT;
import boofcv.alg.filter.misc.ImplAverageDownSampleN;
import boofcv.alg.filter.misc.ImplAverageDownSampleN_MT;
import boofcv.alg.filter.misc.ImplAverageDownSample_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class AverageDownSampleOps {
    public static int downSampleSize(int length, int squareWidth) {
        int ret = length / squareWidth;
        if (length % squareWidth != 0) {
            ++ret;
        }
        return ret;
    }

    public static void reshapeDown(ImageBase image, int inputWidth, int inputHeight, int squareWidth) {
        int w = AverageDownSampleOps.downSampleSize(inputWidth, squareWidth);
        int h = AverageDownSampleOps.downSampleSize(inputHeight, squareWidth);
        image.reshape(w, h);
    }

    public static void down(ImageBase input, int sampleWidth, ImageBase output) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                AverageDownSampleOps.down((ImageGray)input, sampleWidth, (ImageGray)output);
                return;
            }
            case PLANAR: {
                AverageDownSampleOps.down((Planar)input, sampleWidth, (Planar)output);
                return;
            }
            case INTERLEAVED: {
                throw new IllegalArgumentException("Interleaved images are not yet supported");
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static void down(ImageGray input, int sampleWidth, ImageGray output) {
        if (input instanceof GrayU8) {
            AverageDownSampleOps.down((GrayU8)input, sampleWidth, (GrayI8)output);
        } else if (input instanceof GrayS8) {
            AverageDownSampleOps.down((GrayS8)input, sampleWidth, (GrayI8)output);
        } else if (input instanceof GrayU16) {
            AverageDownSampleOps.down((GrayU16)input, sampleWidth, (GrayI16)output);
        } else if (input instanceof GrayS16) {
            AverageDownSampleOps.down((GrayS16)input, sampleWidth, (GrayI16)output);
        } else if (input instanceof GrayS32) {
            AverageDownSampleOps.down((GrayS32)input, sampleWidth, (GrayS32)output);
        } else if (input instanceof GrayF32) {
            AverageDownSampleOps.down((GrayF32)input, sampleWidth, (GrayF32)output);
        } else if (input instanceof GrayF64) {
            AverageDownSampleOps.down((GrayF64)input, sampleWidth, (GrayF64)output);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase<T>> void down(T input, T output) {
        if (ImageGray.class.isAssignableFrom(input.getClass())) {
            if (BoofConcurrency.USE_CONCURRENT) {
                if (input instanceof GrayU8) {
                    GrayF32 middle = new GrayF32(output.width, input.height);
                    ImplAverageDownSample_MT.horizontal((GrayU8)input, middle);
                    ImplAverageDownSample_MT.vertical(middle, (GrayI8)output);
                    return;
                } else if (input instanceof GrayU16) {
                    GrayF32 middle = new GrayF32(output.width, input.height);
                    ImplAverageDownSample_MT.horizontal((GrayU16)input, middle);
                    ImplAverageDownSample_MT.vertical(middle, (GrayI16)((GrayU16)output));
                    return;
                } else if (input instanceof GrayF32) {
                    GrayF32 middle = new GrayF32(output.width, input.height);
                    ImplAverageDownSample_MT.horizontal((GrayF32)input, middle);
                    ImplAverageDownSample_MT.vertical(middle, (GrayF32)output);
                    return;
                } else {
                    if (!(input instanceof GrayF64)) throw new IllegalArgumentException("Unknown image type");
                    GrayF64 middle = new GrayF64(output.width, input.height);
                    ImplAverageDownSample_MT.horizontal((GrayF64)input, middle);
                    ImplAverageDownSample_MT.vertical(middle, (GrayF64)output);
                }
                return;
            } else if (input instanceof GrayU8) {
                GrayF32 middle = new GrayF32(output.width, input.height);
                ImplAverageDownSample.horizontal((GrayU8)input, middle);
                ImplAverageDownSample.vertical(middle, (GrayI8)output);
                return;
            } else if (input instanceof GrayU16) {
                GrayF32 middle = new GrayF32(output.width, input.height);
                ImplAverageDownSample.horizontal((GrayU16)input, middle);
                ImplAverageDownSample.vertical(middle, (GrayI16)((GrayU16)output));
                return;
            } else if (input instanceof GrayF32) {
                GrayF32 middle = new GrayF32(output.width, input.height);
                ImplAverageDownSample.horizontal((GrayF32)input, middle);
                ImplAverageDownSample.vertical(middle, (GrayF32)output);
                return;
            } else {
                if (!(input instanceof GrayF64)) throw new IllegalArgumentException("Unknown image type");
                GrayF64 middle = new GrayF64(output.width, input.height);
                ImplAverageDownSample.horizontal((GrayF64)input, middle);
                ImplAverageDownSample.vertical(middle, (GrayF64)output);
            }
            return;
        } else {
            if (!Planar.class.isAssignableFrom(input.getClass())) return;
            Planar in = (Planar)input;
            Planar out = (Planar)output;
            int N = in.getNumBands();
            for (int i = 0; i < N; ++i) {
                AverageDownSampleOps.down(in.getBand(i), out.getBand(i));
            }
        }
    }

    public static <T extends ImageGray<T>> void down(Planar<T> input, int sampleWidth, Planar<T> output) {
        for (int band = 0; band < input.getNumBands(); ++band) {
            AverageDownSampleOps.down(input.getBand(band), sampleWidth, output.getBand(band));
        }
    }

    public static <T extends ImageGray<T>> void down(Planar<T> input, Planar<T> output) {
        for (int band = 0; band < input.getNumBands(); ++band) {
            AverageDownSampleOps.down(input.getBand(band), output.getBand(band));
        }
    }

    public static void down(GrayU8 input, int sampleWidth, GrayI8 output) {
        if (sampleWidth == 2) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplAverageDownSample2_MT.down(input, output);
            } else {
                ImplAverageDownSample2.down(input, output);
            }
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplAverageDownSampleN_MT.down(input, sampleWidth, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayS8 input, int sampleWidth, GrayI8 output) {
        if (sampleWidth == 2) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplAverageDownSample2_MT.down(input, output);
            } else {
                ImplAverageDownSample2.down(input, output);
            }
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplAverageDownSampleN_MT.down(input, sampleWidth, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayU16 input, int sampleWidth, GrayI16 output) {
        if (sampleWidth == 2) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplAverageDownSample2_MT.down(input, output);
            } else {
                ImplAverageDownSample2.down(input, output);
            }
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplAverageDownSampleN_MT.down(input, sampleWidth, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayS16 input, int sampleWidth, GrayI16 output) {
        if (sampleWidth == 2) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplAverageDownSample2_MT.down(input, output);
            } else {
                ImplAverageDownSample2.down(input, output);
            }
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplAverageDownSampleN_MT.down(input, sampleWidth, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayS32 input, int sampleWidth, GrayS32 output) {
        if (sampleWidth == 2) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplAverageDownSample2_MT.down(input, output);
            } else {
                ImplAverageDownSample2.down(input, output);
            }
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplAverageDownSampleN_MT.down(input, sampleWidth, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayF32 input, int sampleWidth, GrayF32 output) {
        if (sampleWidth == 2) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplAverageDownSample2_MT.down(input, output);
            } else {
                ImplAverageDownSample2.down(input, output);
            }
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplAverageDownSampleN_MT.down(input, sampleWidth, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayF64 input, int sampleWidth, GrayF64 output) {
        if (sampleWidth == 2) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplAverageDownSample2_MT.down(input, output);
            } else {
                ImplAverageDownSample2.down(input, output);
            }
        } else if (BoofConcurrency.USE_CONCURRENT) {
            ImplAverageDownSampleN_MT.down(input, sampleWidth, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }
}

