/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AssignPixelValue_SB;
import boofcv.alg.distort.ImageDistortCache_SB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;
import java.util.Stack;

public class ImageDistortCache_SB_MT<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
extends ImageDistortCache_SB<Input, Output> {
    private final Stack<BlockDistort> queue = new Stack();

    public ImageDistortCache_SB_MT(AssignPixelValue_SB<Output> assigner, InterpolatePixelS<Input> interp) {
        super(assigner, interp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockDistort pop() {
        Stack<BlockDistort> stack = this.queue;
        synchronized (stack) {
            if (this.queue.isEmpty()) {
                return new BlockDistort();
            }
            return this.queue.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle(BlockDistort b) {
        Stack<BlockDistort> stack = this.queue;
        synchronized (stack) {
            this.queue.push(b);
        }
    }

    @Override
    protected void init(Input srcImg, Output dstImg) {
        if (this.dirty || this.width != ((ImageGray)dstImg).width || this.height != ((ImageGray)dstImg).height) {
            this.width = ((ImageGray)dstImg).width;
            this.height = ((ImageGray)dstImg).height;
            this.map = new Point2D_F32[this.width * this.height];
            for (int i = 0; i < this.map.length; ++i) {
                this.map[i] = new Point2D_F32();
            }
            BoofConcurrency.loopBlocks((int)0, (int)this.height, (y0, y1) -> {
                PixelTransform dstToSrc = this.dstToSrc.copyConcurrent();
                for (int y = y0; y < y1; ++y) {
                    int index = y * this.width;
                    for (int x = 0; x < this.width; ++x) {
                        dstToSrc.compute(x, y, (Object)this.map[index++]);
                    }
                }
            });
            this.dirty = false;
        } else if (((ImageGray)dstImg).width != this.width || ((ImageGray)dstImg).height != this.height) {
            throw new IllegalArgumentException("Unexpected dstImg dimension");
        }
        this.srcImg = srcImg;
        this.dstImg = dstImg;
        this.interp.setImage(srcImg);
        this.assigner.setImage(dstImg);
    }

    @Override
    protected void renderAll() {
        BoofConcurrency.loopBlocks((int)this.y0, (int)this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyAll(y0, y1);
            this.recycle(b);
        });
    }

    @Override
    protected void renderAll(GrayU8 mask) {
        BoofConcurrency.loopBlocks((int)this.y0, (int)this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyAll(y0, y1, mask);
            this.recycle(b);
        });
    }

    @Override
    protected void applyOnlyInside() {
        BoofConcurrency.loopBlocks((int)this.y0, (int)this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyOnlyInside(y0, y1);
            this.recycle(b);
        });
    }

    @Override
    protected void applyOnlyInside(GrayU8 mask) {
        BoofConcurrency.loopBlocks((int)this.y0, (int)this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyOnlyInside(y0, y1, mask);
            this.recycle(b);
        });
    }

    private class BlockDistort {
        InterpolatePixelS<Input> interp;

        private BlockDistort() {
            this.interp = ImageDistortCache_SB_MT.this.interp.copy();
        }

        public void init() {
            this.interp.setImage(ImageDistortCache_SB_MT.this.srcImg);
        }

        void applyAll(int y0, int y1) {
            this.init();
            for (int y = y0; y < y1; ++y) {
                int indexDst = ImageDistortCache_SB_MT.this.dstImg.startIndex + ImageDistortCache_SB_MT.this.dstImg.stride * y + ImageDistortCache_SB_MT.this.x0;
                int x = ImageDistortCache_SB_MT.this.x0;
                while (x < ImageDistortCache_SB_MT.this.x1) {
                    Point2D_F32 s = ImageDistortCache_SB_MT.this.map[indexDst];
                    ImageDistortCache_SB_MT.this.assigner.assign(indexDst, this.interp.get(s.x, s.y));
                    ++x;
                    ++indexDst;
                }
            }
        }

        void applyAll(int y0, int y1, GrayU8 mask) {
            this.init();
            float maxWidth = ImageDistortCache_SB_MT.this.srcImg.getWidth() - 1;
            float maxHeight = ImageDistortCache_SB_MT.this.srcImg.getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ImageDistortCache_SB_MT.this.dstImg.startIndex + ImageDistortCache_SB_MT.this.dstImg.stride * y + ImageDistortCache_SB_MT.this.x0;
                int indexMsk = mask.startIndex + mask.stride * y + ImageDistortCache_SB_MT.this.x0;
                int x = ImageDistortCache_SB_MT.this.x0;
                while (x < ImageDistortCache_SB_MT.this.x1) {
                    Point2D_F32 s = ImageDistortCache_SB_MT.this.map[indexDst];
                    ImageDistortCache_SB_MT.this.assigner.assign(indexDst, this.interp.get(s.x, s.y));
                    mask.data[indexMsk] = s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight ? (byte)1 : 0;
                    ++x;
                    ++indexDst;
                    ++indexMsk;
                }
            }
        }

        void applyOnlyInside(int y0, int y1) {
            this.init();
            float maxWidth = ImageDistortCache_SB_MT.this.srcImg.getWidth() - 1;
            float maxHeight = ImageDistortCache_SB_MT.this.srcImg.getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ImageDistortCache_SB_MT.this.dstImg.startIndex + ImageDistortCache_SB_MT.this.dstImg.stride * y + ImageDistortCache_SB_MT.this.x0;
                int x = ImageDistortCache_SB_MT.this.x0;
                while (x < ImageDistortCache_SB_MT.this.x1) {
                    Point2D_F32 s = ImageDistortCache_SB_MT.this.map[indexDst];
                    if (s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight) {
                        ImageDistortCache_SB_MT.this.assigner.assign(indexDst, this.interp.get(s.x, s.y));
                    }
                    ++x;
                    ++indexDst;
                }
            }
        }

        void applyOnlyInside(int y0, int y1, GrayU8 mask) {
            this.init();
            float maxWidth = ImageDistortCache_SB_MT.this.srcImg.getWidth() - 1;
            float maxHeight = ImageDistortCache_SB_MT.this.srcImg.getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ImageDistortCache_SB_MT.this.dstImg.startIndex + ImageDistortCache_SB_MT.this.dstImg.stride * y + ImageDistortCache_SB_MT.this.x0;
                int indexMsk = mask.startIndex + mask.stride * y + ImageDistortCache_SB_MT.this.x0;
                int x = ImageDistortCache_SB_MT.this.x0;
                while (x < ImageDistortCache_SB_MT.this.x1) {
                    Point2D_F32 s = ImageDistortCache_SB_MT.this.map[indexDst];
                    if (s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight) {
                        ImageDistortCache_SB_MT.this.assigner.assign(indexDst, this.interp.get(s.x, s.y));
                        mask.data[indexMsk] = 1;
                    } else {
                        mask.data[indexMsk] = 0;
                    }
                    ++x;
                    ++indexDst;
                    ++indexMsk;
                }
            }
        }
    }
}

