/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;
import org.ejml.UtilEjml;

public class PixelTransformCached_F32
implements PixelTransform<Point2D_F32> {
    Point2D_F32[] map;
    int width;
    int height;
    boolean ignoreNaN = true;

    public PixelTransformCached_F32(int width, int height, Point2Transform2_F32 transform) {
        this(width, height, new PointToPixelTransform_F32(transform));
    }

    public PixelTransformCached_F32(int width, int height, PixelTransform<Point2D_F32> transform) {
        this.width = width + 1;
        this.height = height + 1;
        this.map = new Point2D_F32[this.width * this.height];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                Point2D_F32 p = new Point2D_F32();
                transform.compute(x, y, (Object)p);
                if (!this.ignoreNaN && (UtilEjml.isUncountable((float)p.x) || UtilEjml.isUncountable((float)p.y))) {
                    p.set(-1.0f, -1.0f);
                }
                this.map[index++] = p;
            }
        }
    }

    PixelTransformCached_F32() {
    }

    public Point2D_F32 getPixel(int x, int y) {
        return this.map[this.width * y + x];
    }

    public boolean isIgnoreNaN() {
        return this.ignoreNaN;
    }

    public void setIgnoreNaN(boolean ignoreNaN) {
        this.ignoreNaN = ignoreNaN;
    }

    public void compute(int x, int y, Point2D_F32 output) {
        output.set(this.map[y * this.width + x]);
    }

    public PixelTransform<Point2D_F32> copyConcurrent() {
        PixelTransformCached_F32 ret = new PixelTransformCached_F32();
        ret.map = new Point2D_F32[this.map.length];
        for (int i = 0; i < ret.map.length; ++i) {
            ret.map[i] = this.map[i].copy();
        }
        ret.width = this.width;
        ret.height = this.height;
        ret.ignoreNaN = this.ignoreNaN;
        return ret;
    }
}

