/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General_SB;
import boofcv.alg.filter.derivative.impl.DerivativeLaplacian_Inner;
import boofcv.alg.filter.derivative.impl.DerivativeLaplacian_Inner_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import javax.annotation.Nullable;

public class DerivativeLaplacian {
    public static Kernel2D_S32 kernel_I32 = new Kernel2D_S32(3, new int[]{0, 1, 0, 1, -4, 1, 0, 1, 0});
    public static Kernel2D_F32 kernel_F32 = new Kernel2D_F32(3, new float[]{0.0f, 1.0f, 0.0f, 1.0f, -4.0f, 1.0f, 0.0f, 1.0f, 0.0f});

    public static void process(GrayU8 orig, GrayS16 deriv, @Nullable ImageBorder_S32<GrayU8> border) {
        deriv.reshape(orig.width, orig.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            DerivativeLaplacian_Inner_MT.process(orig, deriv);
        } else {
            DerivativeLaplacian_Inner.process(orig, deriv);
        }
        if (border != null) {
            border.setImage((ImageBase)orig);
            ConvolveJustBorder_General_SB.convolve(kernel_I32, border, (GrayI16)deriv);
        }
    }

    public static void process(GrayU8 orig, GrayF32 deriv) {
        deriv.reshape(orig.width, orig.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            DerivativeLaplacian_Inner_MT.process(orig, deriv);
        } else {
            DerivativeLaplacian_Inner.process(orig, deriv);
        }
    }

    public static void process(GrayF32 orig, GrayF32 deriv, @Nullable ImageBorder_F32 border) {
        deriv.reshape(orig.width, orig.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            DerivativeLaplacian_Inner_MT.process(orig, deriv);
        } else {
            DerivativeLaplacian_Inner.process(orig, deriv);
        }
        if (border != null) {
            border.setImage((ImageBase)orig);
            ConvolveJustBorder_General_SB.convolve(kernel_F32, border, deriv);
        }
    }
}

