/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;

public class HessianThreeDeterminant_Border {
    public static void process(GrayU8 input, GrayS16 output, ImageBorder_S32<GrayU8> border) {
        int Lxy;
        int Lyy;
        int Lxx;
        int center;
        int x;
        int idxDst;
        int idxSrc;
        int y;
        border.setImage((ImageBase)input);
        byte[] src = input.data;
        short[] dst = output.data;
        int width = input.getWidth();
        int height = input.getHeight();
        int stride = input.stride;
        for (y = 0; y < 2; ++y) {
            idxSrc = input.startIndex + stride * y;
            idxDst = output.startIndex + stride * y;
            x = 0;
            while (x < width) {
                center = src[idxSrc] & 0xFF;
                Lxx = border.get(x - 2, y) - 2 * center + border.get(x + 2, y);
                Lyy = border.get(x, y - 2) - 2 * center + border.get(x, y + 2);
                Lxy = border.get(x - 1, y - 1) + border.get(x + 1, y + 1);
                dst[idxDst++] = (short)(Lxx * Lyy - (Lxy -= border.get(x + 1, y - 1) + border.get(x - 1, y + 1)) * Lxy);
                ++x;
                ++idxSrc;
            }
        }
        for (y = height - 2; y < height; ++y) {
            idxSrc = input.startIndex + stride * y;
            idxDst = output.startIndex + stride * y;
            x = 0;
            while (x < width) {
                center = src[idxSrc] & 0xFF;
                Lxx = border.get(x - 2, y) - 2 * center + border.get(x + 2, y);
                Lyy = border.get(x, y - 2) - 2 * center + border.get(x, y + 2);
                Lxy = border.get(x - 1, y - 1) + border.get(x + 1, y + 1);
                dst[idxDst++] = (short)(Lxx * Lyy - (Lxy -= border.get(x + 1, y - 1) + border.get(x - 1, y + 1)) * Lxy);
                ++x;
                ++idxSrc;
            }
        }
        for (y = 2; y < height - 2; ++y) {
            int idxDst2;
            int idxSrc2;
            int x2;
            for (x2 = 0; x2 < 2; ++x2) {
                idxSrc2 = input.startIndex + stride * y + x2;
                idxDst2 = output.startIndex + stride * y + x2;
                center = src[idxSrc2] & 0xFF;
                Lxx = border.get(x2 - 2, y) - 2 * center + border.get(x2 + 2, y);
                Lyy = border.get(x2, y - 2) - 2 * center + border.get(x2, y + 2);
                Lxy = border.get(x2 - 1, y - 1) + border.get(x2 + 1, y + 1);
                dst[idxDst2] = (short)(Lxx * Lyy - (Lxy -= border.get(x2 + 1, y - 1) + border.get(x2 - 1, y + 1)) * Lxy);
            }
            for (x2 = width - 2; x2 < width; ++x2) {
                idxSrc2 = input.startIndex + stride * y + x2;
                idxDst2 = output.startIndex + stride * y + x2;
                center = src[idxSrc2] & 0xFF;
                Lxx = border.get(x2 - 2, y) - 2 * center + border.get(x2 + 2, y);
                Lyy = border.get(x2, y - 2) - 2 * center + border.get(x2, y + 2);
                Lxy = border.get(x2 - 1, y - 1) + border.get(x2 + 1, y + 1);
                dst[idxDst2] = (short)(Lxx * Lyy - (Lxy -= border.get(x2 + 1, y - 1) + border.get(x2 - 1, y + 1)) * Lxy);
            }
        }
    }

    public static void process(GrayU8 input, GrayF32 output, ImageBorder_S32<GrayU8> border) {
        int Lxy;
        int Lyy;
        int Lxx;
        int center;
        int x;
        int idxDst;
        int idxSrc;
        int y;
        border.setImage((ImageBase)input);
        byte[] src = input.data;
        float[] dst = output.data;
        int width = input.getWidth();
        int height = input.getHeight();
        int stride = input.stride;
        for (y = 0; y < 2; ++y) {
            idxSrc = input.startIndex + stride * y;
            idxDst = output.startIndex + stride * y;
            x = 0;
            while (x < width) {
                center = src[idxSrc] & 0xFF;
                Lxx = border.get(x - 2, y) - 2 * center + border.get(x + 2, y);
                Lyy = border.get(x, y - 2) - 2 * center + border.get(x, y + 2);
                Lxy = border.get(x - 1, y - 1) + border.get(x + 1, y + 1);
                dst[idxDst++] = Lxx * Lyy - (Lxy -= border.get(x + 1, y - 1) + border.get(x - 1, y + 1)) * Lxy;
                ++x;
                ++idxSrc;
            }
        }
        for (y = height - 2; y < height; ++y) {
            idxSrc = input.startIndex + stride * y;
            idxDst = output.startIndex + stride * y;
            x = 0;
            while (x < width) {
                center = src[idxSrc] & 0xFF;
                Lxx = border.get(x - 2, y) - 2 * center + border.get(x + 2, y);
                Lyy = border.get(x, y - 2) - 2 * center + border.get(x, y + 2);
                Lxy = border.get(x - 1, y - 1) + border.get(x + 1, y + 1);
                dst[idxDst++] = Lxx * Lyy - (Lxy -= border.get(x + 1, y - 1) + border.get(x - 1, y + 1)) * Lxy;
                ++x;
                ++idxSrc;
            }
        }
        for (y = 2; y < height - 2; ++y) {
            int idxDst2;
            int idxSrc2;
            int x2;
            for (x2 = 0; x2 < 2; ++x2) {
                idxSrc2 = input.startIndex + stride * y + x2;
                idxDst2 = output.startIndex + stride * y + x2;
                center = src[idxSrc2] & 0xFF;
                Lxx = border.get(x2 - 2, y) - 2 * center + border.get(x2 + 2, y);
                Lyy = border.get(x2, y - 2) - 2 * center + border.get(x2, y + 2);
                Lxy = border.get(x2 - 1, y - 1) + border.get(x2 + 1, y + 1);
                dst[idxDst2] = Lxx * Lyy - (Lxy -= border.get(x2 + 1, y - 1) + border.get(x2 - 1, y + 1)) * Lxy;
            }
            for (x2 = width - 2; x2 < width; ++x2) {
                idxSrc2 = input.startIndex + stride * y + x2;
                idxDst2 = output.startIndex + stride * y + x2;
                center = src[idxSrc2] & 0xFF;
                Lxx = border.get(x2 - 2, y) - 2 * center + border.get(x2 + 2, y);
                Lyy = border.get(x2, y - 2) - 2 * center + border.get(x2, y + 2);
                Lxy = border.get(x2 - 1, y - 1) + border.get(x2 + 1, y + 1);
                dst[idxDst2] = Lxx * Lyy - (Lxy -= border.get(x2 + 1, y - 1) + border.get(x2 - 1, y + 1)) * Lxy;
            }
        }
    }

    public static void process(GrayF32 input, GrayF32 output, ImageBorder_F32 border) {
        float Lxy;
        float Lyy;
        float Lxx;
        float center;
        int x;
        int idxDst;
        int idxSrc;
        int y;
        border.setImage((ImageBase)input);
        float[] src = input.data;
        float[] dst = output.data;
        int width = input.getWidth();
        int height = input.getHeight();
        int stride = input.stride;
        for (y = 0; y < 2; ++y) {
            idxSrc = input.startIndex + stride * y;
            idxDst = output.startIndex + stride * y;
            x = 0;
            while (x < width) {
                center = src[idxSrc];
                Lxx = border.get(x - 2, y) - 2.0f * center + border.get(x + 2, y);
                Lyy = border.get(x, y - 2) - 2.0f * center + border.get(x, y + 2);
                Lxy = border.get(x - 1, y - 1) + border.get(x + 1, y + 1);
                dst[idxDst++] = Lxx * Lyy - (Lxy -= border.get(x + 1, y - 1) + border.get(x - 1, y + 1)) * Lxy;
                ++x;
                ++idxSrc;
            }
        }
        for (y = height - 2; y < height; ++y) {
            idxSrc = input.startIndex + stride * y;
            idxDst = output.startIndex + stride * y;
            x = 0;
            while (x < width) {
                center = src[idxSrc];
                Lxx = border.get(x - 2, y) - 2.0f * center + border.get(x + 2, y);
                Lyy = border.get(x, y - 2) - 2.0f * center + border.get(x, y + 2);
                Lxy = border.get(x - 1, y - 1) + border.get(x + 1, y + 1);
                dst[idxDst++] = Lxx * Lyy - (Lxy -= border.get(x + 1, y - 1) + border.get(x - 1, y + 1)) * Lxy;
                ++x;
                ++idxSrc;
            }
        }
        for (y = 2; y < height - 2; ++y) {
            int idxDst2;
            int idxSrc2;
            int x2;
            for (x2 = 0; x2 < 2; ++x2) {
                idxSrc2 = input.startIndex + stride * y + x2;
                idxDst2 = output.startIndex + stride * y + x2;
                center = src[idxSrc2];
                Lxx = border.get(x2 - 2, y) - 2.0f * center + border.get(x2 + 2, y);
                Lyy = border.get(x2, y - 2) - 2.0f * center + border.get(x2, y + 2);
                Lxy = border.get(x2 - 1, y - 1) + border.get(x2 + 1, y + 1);
                dst[idxDst2] = Lxx * Lyy - (Lxy -= border.get(x2 + 1, y - 1) + border.get(x2 - 1, y + 1)) * Lxy;
            }
            for (x2 = width - 2; x2 < width; ++x2) {
                idxSrc2 = input.startIndex + stride * y + x2;
                idxDst2 = output.startIndex + stride * y + x2;
                center = src[idxSrc2];
                Lxx = border.get(x2 - 2, y) - 2.0f * center + border.get(x2 + 2, y);
                Lyy = border.get(x2, y - 2) - 2.0f * center + border.get(x2, y + 2);
                Lxy = border.get(x2 - 1, y - 1) + border.get(x2 + 1, y + 1);
                dst[idxDst2] = Lxx * Lyy - (Lxy -= border.get(x2 + 1, y - 1) + border.get(x2 - 1, y + 1)) * Lxy;
            }
        }
    }
}

