/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.derivative;

import boofcv.abst.filter.derivative.GradientMultiToSingleBand_Reflection;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageGradientThenReduce;
import boofcv.abst.filter.derivative.ImageGradient_Gaussian;
import boofcv.abst.filter.derivative.ImageGradient_PL;
import boofcv.abst.filter.derivative.ImageGradient_SB;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.abst.filter.derivative.ImageHessianDirect;
import boofcv.abst.filter.derivative.ImageHessianDirect_SB;
import boofcv.abst.filter.derivative.ImageHessian_Reflection;
import boofcv.alg.filter.derivative.DerivativeReduceType;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientReduceToSingle;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.derivative.HessianFromGradient;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public class FactoryDerivative {
    public static <I extends ImageMultiBand<I>, M extends ImageMultiBand<M>, D extends ImageGray<D>> ImageGradient<I, D> gradientReduce(ImageGradient<I, M> gradient, DerivativeReduceType type, Class<D> outputType) {
        Class clazz;
        String name;
        switch (type) {
            case MAX_F: {
                name = "maxf";
                break;
            }
            default: {
                throw new RuntimeException("Unknown reduce type " + type);
            }
        }
        switch (gradient.getDerivativeType().getFamily()) {
            case PLANAR: {
                clazz = Planar.class;
                break;
            }
            case GRAY: {
                throw new IllegalArgumentException("Can't have gradient output be single band");
            }
            default: {
                clazz = gradient.getDerivativeType().getImageClass();
            }
        }
        Class middleType = clazz;
        Method m = FactoryDerivative.findReduce(name, middleType, outputType);
        GradientMultiToSingleBand_Reflection reducer = new GradientMultiToSingleBand_Reflection(m, gradient.getDerivativeType(), outputType);
        return new ImageGradientThenReduce<I, M, D>(gradient, reducer);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<I, D> gradientSB(DerivativeType type, Class<I> inputType, Class<D> derivType) {
        ImageGradient_SB imageGradient_SB;
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        switch (type) {
            case PREWITT: {
                imageGradient_SB = new ImageGradient_SB.Prewitt<I, D>(inputType, derivType);
                break;
            }
            case SOBEL: {
                imageGradient_SB = new ImageGradient_SB.Sobel<I, D>(inputType, derivType);
                break;
            }
            case SCHARR: {
                imageGradient_SB = new ImageGradient_SB.Scharr<I, D>(inputType, derivType);
                break;
            }
            case THREE: {
                imageGradient_SB = new ImageGradient_SB.Three<I, D>(inputType, derivType);
                break;
            }
            case TWO_0: {
                imageGradient_SB = new ImageGradient_SB.Two0<I, D>(inputType, derivType);
                break;
            }
            case TWO_1: {
                imageGradient_SB = new ImageGradient_SB.Two1<I, D>(inputType, derivType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown derivative type " + type);
            }
        }
        return imageGradient_SB;
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<Planar<I>, Planar<D>> gradientPL(DerivativeType type, int numBands, Class<I> inputType, @Nullable Class<D> derivType) {
        ImageGradient<I, D> g = FactoryDerivative.gradientSB(type, inputType, derivType);
        return new ImageGradient_PL<I, D>(g, numBands);
    }

    public static <I extends ImageBase<I>, D extends ImageBase<D>> ImageGradient<I, D> gradient(DerivativeType type, ImageType<I> inputType, @Nullable ImageType<D> derivType) {
        if (derivType != null && inputType.getFamily() != derivType.getFamily()) {
            throw new IllegalArgumentException("input and output must be of the same family");
        }
        switch (inputType.getFamily()) {
            case GRAY: {
                Class derivClass = derivType != null ? derivType.getImageClass() : null;
                return FactoryDerivative.gradientSB(type, inputType.getImageClass(), derivClass);
            }
            case PLANAR: {
                int numBands = inputType.getNumBands();
                Class derivClass = derivType != null ? derivType.getImageClass() : null;
                return FactoryDerivative.gradientPL(type, numBands, inputType.getImageClass(), derivClass);
            }
            case INTERLEAVED: {
                throw new IllegalArgumentException("INTERLEAVED images not yet supported");
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<I, D> prewitt(Class<I> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageGradient_SB.Prewitt<I, D>(inputType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<I, D> sobel(Class<I> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageGradient_SB.Sobel<I, D>(inputType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<I, D> scharr(Class<I> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageGradient_SB.Scharr<I, D>(inputType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<I, D> three(Class<I> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageGradient_SB.Three<I, D>(inputType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<I, D> two0(Class<I> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageGradient_SB.Two0<I, D>(inputType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<I, D> two1(Class<I> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageGradient_SB.Two1<I, D>(inputType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageHessianDirect<I, D> hessianDirectThree(Class<I> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageHessianDirect_SB.Three<I, D>(inputType, derivType);
    }

    public static <D extends ImageGray<D>> ImageHessian<D> hessian(Class<?> gradientType, @Nullable Class<D> derivType) {
        Method m = FactoryDerivative.findHessianFromGradient(gradientType, derivType);
        return new ImageHessian_Reflection(m);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> ImageGradient<I, D> gaussian(double sigma, int radius, Class<I> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageGradient_Gaussian<I, D>(sigma, radius, inputType, derivType);
    }

    public static <D extends ImageGray<D>> ImageHessian<D> hessianSobel(Class<D> derivType) {
        if (derivType == GrayF32.class) {
            return FactoryDerivative.hessian(GradientSobel.class, GrayF32.class);
        }
        if (derivType == GrayS16.class) {
            return FactoryDerivative.hessian(GradientSobel.class, GrayS16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    public static <D extends ImageGray<D>> ImageHessian<D> hessianPrewitt(Class<D> derivType) {
        if (derivType == GrayF32.class) {
            return FactoryDerivative.hessian(GradientPrewitt.class, GrayF32.class);
        }
        if (derivType == GrayS16.class) {
            return FactoryDerivative.hessian(GradientPrewitt.class, GrayS16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    public static <D extends ImageGray<D>> ImageHessian<D> hessianThree(Class<D> derivType) {
        if (derivType == GrayF32.class) {
            return FactoryDerivative.hessian(GradientThree.class, GrayF32.class);
        }
        if (derivType == GrayS16.class) {
            return FactoryDerivative.hessian(GradientThree.class, GrayS16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    private static Method findReduce(String name, Class<?> inputType, @Nullable Class<?> derivType) {
        Method m;
        try {
            m = GradientReduceToSingle.class.getDeclaredMethod(name, inputType, inputType, derivType, derivType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Input and derivative types are probably not compatible", e);
        }
        return m;
    }

    private static Method findHessianFromGradient(Class<?> derivativeClass, Class<?> imageType) {
        Method m;
        String name = derivativeClass.getSimpleName().substring(8);
        try {
            Class borderType = GeneralizedImageOps.isFloatingPoint(imageType) ? ImageBorder_F32.class : ImageBorder_S32.class;
            m = HessianFromGradient.class.getDeclaredMethod("hessian" + name, imageType, imageType, imageType, imageType, imageType, borderType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Input and derivative types are probably not compatible", e);
        }
        return m;
    }
}

