/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.basic.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ImplGrayImageOps {
    public static void invert(GrayF32 input, float max, GrayF32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = max - input.data[indexSrc++];
            }
        }
    }

    public static void brighten(GrayF32 input, float beta, float max, GrayF32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int n = indexSrc++;
                float val = input.data[n] + beta;
                if (val > max) {
                    val = max;
                }
                if (val < 0.0f) {
                    val = 0.0f;
                }
                output.data[indexDst++] = val;
            }
        }
    }

    public static void stretch(GrayF32 input, double gamma, float beta, float max, GrayF32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int n = indexSrc++;
                float val = (float)((double)input.data[n] * gamma) + beta;
                if (val > max) {
                    val = max;
                }
                if (val < 0.0f) {
                    val = 0.0f;
                }
                output.data[indexDst++] = val;
            }
        }
    }

    public static void invert(GrayU8 input, int max, GrayU8 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = (byte)(max - (input.data[indexSrc++] & 0xFF));
            }
        }
    }

    public static void brighten(GrayU8 input, int beta, int max, GrayU8 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (input.data[indexSrc++] & 0xFF) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (byte)val;
            }
        }
    }

    public static void stretch(GrayU8 input, double gamma, int beta, int max, GrayU8 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (int)((double)(input.data[indexSrc++] & 0xFF) * gamma) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (byte)val;
            }
        }
    }

    public static void invert(GrayS16 input, int max, GrayS16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = (short)(max - input.data[indexSrc++]);
            }
        }
    }

    public static void brighten(GrayS16 input, int beta, int max, GrayS16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = input.data[indexSrc++] + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (short)val;
            }
        }
    }

    public static void stretch(GrayS16 input, double gamma, int beta, int max, GrayS16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (int)((double)input.data[indexSrc++] * gamma) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (short)val;
            }
        }
    }

    public static void invert(GrayU16 input, int max, GrayU16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = (short)(max - (input.data[indexSrc++] & 0xFFFF));
            }
        }
    }

    public static void brighten(GrayU16 input, int beta, int max, GrayU16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (input.data[indexSrc++] & 0xFFFF) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (short)val;
            }
        }
    }

    public static void stretch(GrayU16 input, double gamma, int beta, int max, GrayU16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (int)((double)(input.data[indexSrc++] & 0xFFFF) * gamma) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (short)val;
            }
        }
    }

    public static void invert(GrayS32 input, int max, GrayS32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = max - input.data[indexSrc++];
            }
        }
    }

    public static void brighten(GrayS32 input, int beta, int max, GrayS32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = input.data[indexSrc++] + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = val;
            }
        }
    }

    public static void stretch(GrayS32 input, double gamma, int beta, int max, GrayS32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (int)((double)input.data[indexSrc++] * gamma) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = val;
            }
        }
    }
}

