/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.array;

public abstract class Interpolate1D_F32 {
    protected int size;
    protected float[] x;
    protected float[] y;
    protected int M;
    private int center;
    protected int index0;
    private boolean doHunt;
    private int dj;
    protected boolean ascend;

    protected Interpolate1D_F32(int degree) {
        this.changeDegree(degree);
    }

    protected Interpolate1D_F32(int degree, float[] x, float[] y, int size) {
        this(degree);
        this.setInput(x, y, size);
    }

    public void setInput(float[] x, float[] y, int size) {
        if (x.length < size || y.length < size) {
            throw new IllegalArgumentException("Arrays too small for size.");
        }
        if (size < this.M) {
            throw new IllegalArgumentException("Not enough data points for M");
        }
        this.x = x;
        this.y = y;
        this.size = size;
        this.dj = Math.min(1, (int)Math.pow(size, 0.25));
        this.ascend = x[size - 1] >= x[0];
    }

    public float process(float testX) {
        if (this.doHunt) {
            this.hunt(testX);
        } else {
            this.bisectionSearch(testX, 0, this.size - 1);
        }
        return this.compute(testX);
    }

    public float process(int index0, float testX) {
        this.index0 = index0;
        return this.compute(testX);
    }

    protected abstract float compute(float var1);

    public void changeDegree(int degree) {
        this.M = degree + 1;
        this.doHunt = false;
    }

    protected void hunt(float val) {
        int upperLimit;
        int lowerLimit = this.center;
        int inc = 1;
        if (val >= this.x[lowerLimit] && this.ascend) {
            while (true) {
                if ((upperLimit = lowerLimit + inc) >= this.size - 1) {
                    upperLimit = this.size - 1;
                } else if (!(val < this.x[upperLimit]) || !this.ascend) {
                    lowerLimit = upperLimit;
                    inc += inc;
                    continue;
                }
                break;
            }
        } else {
            upperLimit = lowerLimit;
            while (true) {
                if ((lowerLimit -= inc) <= 0) {
                    lowerLimit = 0;
                    break;
                }
                if (val >= this.x[lowerLimit] && this.ascend) break;
                upperLimit = lowerLimit;
                inc += inc;
            }
        }
        this.bisectionSearch(val, lowerLimit, upperLimit);
    }

    protected void bisectionSearch(float val, int lowerLimit, int upperLimit) {
        while (upperLimit - lowerLimit > 1) {
            int middle = (upperLimit + lowerLimit) / 2;
            if (val >= this.x[middle] && this.ascend) {
                lowerLimit = middle;
                continue;
            }
            upperLimit = middle;
        }
        this.doHunt = Math.abs(lowerLimit - this.center) > this.dj;
        this.center = lowerLimit;
        this.index0 = this.center - this.M / 2;
        if (this.index0 + this.M > this.size) {
            this.index0 = this.size - this.M;
        } else if (this.index0 < 0) {
            this.index0 = 0;
        }
    }
}

