/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray_F32;
import pabeles.concurrency.GrowArray;

public class ThresholdNiblackFamily
implements InputToBinary<GrayF32> {
    float k;
    ConfigLength width;
    boolean down;
    Variant variant;
    GrayF32 inputPow2 = new GrayF32(1, 1);
    GrayF32 inputMean = new GrayF32(1, 1);
    GrayF32 inputMeanPow2 = new GrayF32(1, 1);
    GrayF32 inputPow2Mean = new GrayF32(1, 1);
    GrayF32 stdev = new GrayF32(1, 1);
    GrayF32 tmp = new GrayF32(1, 1);
    GrowArray<DogArray_F32> work = new GrowArray(DogArray_F32::new);
    float maxStdev;
    float minItensity;
    Threshold op;

    public ThresholdNiblackFamily(ConfigLength width, float k, boolean down, Variant variant) {
        Threshold threshold;
        this.k = k;
        this.width = width;
        this.down = down;
        this.variant = variant;
        switch (variant) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SAUVOLA: {
                threshold = new Sauvola();
                break;
            }
            case NIBLACK: {
                threshold = new Niblack();
                break;
            }
            case WOLF_JOLION: {
                threshold = new WolfJolion();
            }
        }
        this.op = threshold;
    }

    @Override
    public void process(GrayF32 input, GrayU8 output) {
        this.inputPow2.reshape(input.width, input.height);
        this.inputMean.reshape(input.width, input.height);
        this.inputMeanPow2.reshape(input.width, input.height);
        this.inputPow2Mean.reshape(input.width, input.height);
        this.stdev.reshape(input.width, input.height);
        this.tmp.reshape(input.width, input.height);
        this.inputPow2.reshape(input.width, input.height);
        int radius = this.width.computeI((double)Math.min(input.width, input.height)) / 2;
        BlurImageOps.mean(input, this.inputMean, radius, this.tmp, this.work);
        PixelMath.pow2(input, this.inputPow2);
        BlurImageOps.mean(this.inputPow2, this.inputPow2Mean, radius, this.tmp, this.work);
        PixelMath.pow2(this.inputMean, this.inputMeanPow2);
        PixelMath.subtract(this.inputPow2Mean, this.inputMeanPow2, this.stdev);
        PixelMath.sqrt(this.stdev, this.stdev);
        if (this.variant == Variant.SAUVOLA || this.variant == Variant.WOLF_JOLION) {
            this.maxStdev = ImageStatistics.max(this.stdev);
        }
        if (this.variant == Variant.WOLF_JOLION) {
            this.minItensity = ImageStatistics.min(input);
        }
        this.applyThresholding(input, output);
    }

    protected void applyThresholding(GrayF32 input, GrayU8 output) {
        if (this.down) {
            for (int y = 0; y < input.height; ++y) {
                int i = y * this.stdev.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float threshold = this.op.compute(this.inputMean.data[i], this.stdev.data[i]);
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int i = y * this.stdev.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float threshold = this.op.compute(this.inputMean.data[i], this.stdev.data[i]);
                    output.data[indexOut++] = (byte)(input.data[indexIn++] >= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            }
        }
    }

    @Override
    public ImageType<GrayF32> getInputType() {
        return ImageType.SB_F32;
    }

    public float getK() {
        return this.k;
    }

    public void setK(float k) {
        this.k = k;
    }

    public ConfigLength getWidth() {
        return this.width;
    }

    public void setWidth(ConfigLength width) {
        this.width = width;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public static enum Variant {
        NIBLACK,
        SAUVOLA,
        WOLF_JOLION;

    }

    class Sauvola
    implements Threshold {
        Sauvola() {
        }

        @Override
        public final float compute(float mean, float stdev) {
            return mean * (1.0f + ThresholdNiblackFamily.this.k * (stdev / ThresholdNiblackFamily.this.maxStdev - 1.0f));
        }
    }

    class Niblack
    implements Threshold {
        Niblack() {
        }

        @Override
        public final float compute(float mean, float stdev) {
            return mean + ThresholdNiblackFamily.this.k * stdev;
        }
    }

    class WolfJolion
    implements Threshold {
        WolfJolion() {
        }

        @Override
        public final float compute(float mean, float stdev) {
            return mean + ThresholdNiblackFamily.this.k * (stdev / ThresholdNiblackFamily.this.maxStdev - 1.0f) * (mean - ThresholdNiblackFamily.this.minItensity);
        }
    }

    static interface Threshold {
        public float compute(float var1, float var2);
    }
}

