/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General_SB;
import boofcv.alg.filter.convolve.noborder.ImplConvolveBox;
import boofcv.alg.filter.convolve.noborder.ImplConvolveBox_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.ImageBorderValue;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class ConvolveImageBox {
    public static void horizontal(GrayF32 input, GrayF32 output, int radius) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, false);
        ConvolveJustBorder_General_SB.horizontal(kernel, ImageBorderValue.wrap((GrayF32)input, (float)0.0f), output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvolveBox_MT.horizontal(input, output, radius);
        } else {
            ImplConvolveBox.horizontal(input, output, radius);
        }
    }

    public static void horizontal(GrayU8 input, GrayI16 output, int radius) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(radius);
        ConvolveJustBorder_General_SB.horizontal(kernel, ImageBorderValue.wrap((GrayI)input, (int)0), output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvolveBox_MT.horizontal(input, output, radius);
        } else {
            ImplConvolveBox.horizontal(input, output, radius);
        }
    }

    public static void horizontal(GrayU8 input, GrayS32 output, int radius) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(radius);
        ConvolveJustBorder_General_SB.horizontal(kernel, ImageBorderValue.wrap((GrayI)input, (int)0), output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvolveBox_MT.horizontal(input, output, radius);
        } else {
            ImplConvolveBox.horizontal(input, output, radius);
        }
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int radius) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(radius);
        ConvolveJustBorder_General_SB.horizontal(kernel, ImageBorderValue.wrap((GrayI)input, (int)0), output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvolveBox_MT.horizontal(input, output, radius);
        } else {
            ImplConvolveBox.horizontal(input, output, radius);
        }
    }

    public static void vertical(GrayF32 input, GrayF32 output, int radius, @Nullable GrowArray<DogArray_F32> work) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, false);
        ConvolveJustBorder_General_SB.vertical(kernel, ImageBorderValue.wrap((GrayF32)input, (float)0.0f), output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvolveBox_MT.vertical(input, output, radius, work);
        } else {
            ImplConvolveBox.vertical(input, output, radius, work);
        }
    }

    public static void vertical(GrayU8 input, GrayI16 output, int radius, @Nullable GrowArray<DogArray_I32> work) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(radius);
        ConvolveJustBorder_General_SB.vertical(kernel, ImageBorderValue.wrap((GrayI)input, (int)0), output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvolveBox_MT.vertical(input, output, radius, work);
        } else {
            ImplConvolveBox.vertical(input, output, radius, work);
        }
    }

    public static void vertical(GrayU8 input, GrayS32 output, int radius, @Nullable GrowArray<DogArray_I32> work) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(radius);
        ConvolveJustBorder_General_SB.vertical(kernel, ImageBorderValue.wrap((GrayI)input, (int)0), output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvolveBox_MT.vertical(input, output, radius, work);
        } else {
            ImplConvolveBox.vertical(input, output, radius, work);
        }
    }

    public static void vertical(GrayS16 input, GrayI16 output, int radius, @Nullable GrowArray<DogArray_I32> work) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
        Kernel1D_S32 kernel = FactoryKernel.table1D_S32(radius);
        ConvolveJustBorder_General_SB.vertical(kernel, ImageBorderValue.wrap((GrayI)input, (int)0), output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvolveBox_MT.vertical(input, output, radius, work);
        } else {
            ImplConvolveBox.vertical(input, output, radius, work);
        }
    }
}

