/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.derivative.DerivativeHelperFunctions;
import boofcv.alg.filter.derivative.impl.GradientThree_Standard;
import boofcv.alg.filter.derivative.impl.GradientThree_Standard_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public class GradientThree {
    public static Kernel1D_S32 kernelDeriv_I32 = new Kernel1D_S32(new int[]{-1, 0, 1}, 3);
    public static Kernel1D_F32 kernelDeriv_F32 = new Kernel1D_F32(new float[]{-0.5f, 0.0f, 0.5f}, 3);

    public static Kernel1D getKernelX(boolean isInteger) {
        if (isInteger) {
            return kernelDeriv_I32;
        }
        return kernelDeriv_F32;
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> void process(I input, D derivX, D derivY, @Nullable ImageBorder border) {
        switch (input.getImageType().getDataType()) {
            case U8: {
                GradientThree.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                break;
            }
            case S16: {
                GradientThree.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                break;
            }
            case F32: {
                GradientThree.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown input image type");
            }
        }
    }

    public static void process(GrayU8 orig, GrayS16 derivX, GrayS16 derivY, @Nullable ImageBorder_S32 border) {
        InputSanityCheck.reshapeOneIn((ImageBase)orig, (ImageBase)derivX, (ImageBase)derivY);
        if (BoofConcurrency.USE_CONCURRENT) {
            GradientThree_Standard_MT.process(orig, derivX, derivY);
        } else {
            GradientThree_Standard.process(orig, derivX, derivY);
        }
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_I32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_I32, border);
        }
    }

    public static void process(GrayU8 orig, GrayS32 derivX, GrayS32 derivY, @Nullable ImageBorder_S32 border) {
        InputSanityCheck.reshapeOneIn((ImageBase)orig, (ImageBase)derivX, (ImageBase)derivY);
        if (BoofConcurrency.USE_CONCURRENT) {
            GradientThree_Standard_MT.process(orig, derivX, derivY);
        } else {
            GradientThree_Standard.process(orig, derivX, derivY);
        }
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_I32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_I32, border);
        }
    }

    public static void process(GrayS16 orig, GrayS16 derivX, GrayS16 derivY, @Nullable ImageBorder_S32 border) {
        InputSanityCheck.reshapeOneIn((ImageBase)orig, (ImageBase)derivX, (ImageBase)derivY);
        if (BoofConcurrency.USE_CONCURRENT) {
            GradientThree_Standard_MT.process(orig, derivX, derivY);
        } else {
            GradientThree_Standard.process(orig, derivX, derivY);
        }
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_I32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_I32, border);
        }
    }

    public static void process(GrayF32 orig, GrayF32 derivX, GrayF32 derivY, @Nullable ImageBorder_F32 border) {
        InputSanityCheck.reshapeOneIn((ImageBase)orig, (ImageBase)derivX, (ImageBase)derivY);
        if (BoofConcurrency.USE_CONCURRENT) {
            GradientThree_Standard_MT.process(orig, derivX, derivY);
        } else {
            GradientThree_Standard.process(orig, derivX, derivY);
        }
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_F32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_F32, border);
        }
    }
}

