/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.ConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.lang.reflect.Method;

public class GConvertImage {
    public static void convert(ImageBase input, ImageBase output) {
        ImageType typeIn = input.getImageType();
        ImageType typeOut = output.getImageType();
        if (input instanceof ImageGray) {
            ImageGray sb = (ImageGray)input;
            if (output instanceof ImageGray) {
                if (input.getClass() == output.getClass()) {
                    output.setTo(input);
                } else {
                    try {
                        Method m = ConvertImage.class.getMethod("convert", input.getClass(), output.getClass());
                        m.invoke(null, input, output);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unknown conversion. " + input.getClass().getSimpleName() + " to " + output.getClass().getSimpleName());
                    }
                }
            } else if (output instanceof Planar) {
                Planar ms = (Planar)output;
                for (int i = 0; i < ms.getNumBands(); ++i) {
                    GConvertImage.convert(input, (ImageBase)ms.getBand(i));
                }
            } else if (output instanceof ImageInterleaved) {
                ImageInterleaved il = (ImageInterleaved)output;
                for (int i = 0; i < il.getNumBands(); ++i) {
                    GImageMiscOps.insertBand(sb, i, (ImageMultiBand)il);
                }
            }
        } else if (input instanceof ImageInterleaved && output instanceof ImageInterleaved) {
            if (input.getClass() == output.getClass()) {
                output.setTo(input);
            } else {
                try {
                    Method m = ConvertImage.class.getMethod("convert", input.getClass(), output.getClass());
                    m.invoke(null, input, output);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unknown conversion. " + input.getClass().getSimpleName() + " to " + output.getClass().getSimpleName());
                }
            }
        } else if (input instanceof Planar && output instanceof ImageGray) {
            Planar mi = (Planar)input;
            ImageGray so = (ImageGray)output;
            if (mi.getImageType().getDataType() != so.getDataType()) {
                int w = output.width;
                int h = output.height;
                ImageGray tmp = GeneralizedImageOps.createSingleBand((ImageDataType)mi.getImageType().getDataType(), (int)w, (int)h);
                GConvertImage.average(mi, tmp);
                GConvertImage.convert((ImageBase)tmp, (ImageBase)so);
            } else {
                GConvertImage.average(mi, so);
            }
        } else if (input instanceof Planar && output instanceof ImageInterleaved) {
            Object functionName = typeIn.getDataType() == typeOut.getDataType() ? "convert" : "convert" + typeIn.getDataType() + typeOut.getDataType();
            try {
                Method m = ConvertImage.class.getMethod((String)functionName, input.getClass(), output.getClass());
                m.invoke(null, input, output);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown conversion. " + input.getClass().getSimpleName() + " to " + output.getClass().getSimpleName());
            }
        } else if (input instanceof Planar && output instanceof Planar) {
            Planar mi = (Planar)input;
            Planar mo = (Planar)output;
            if (mi.getBandType() == mo.getBandType()) {
                mo.setTo(mi);
            } else {
                for (int i = 0; i < mi.getNumBands(); ++i) {
                    GConvertImage.convert((ImageBase)mi.getBand(i), (ImageBase)mo.getBand(i));
                }
            }
        } else if (input instanceof ImageInterleaved && output instanceof Planar) {
            Object functionName = typeIn.getDataType() == typeOut.getDataType() ? "convert" : "convert" + typeIn.getDataType() + typeOut.getDataType();
            try {
                Method m = ConvertImage.class.getMethod((String)functionName, input.getClass(), output.getClass());
                m.invoke(null, input, output);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown conversion. " + input.getClass().getSimpleName() + " to " + output.getClass().getSimpleName());
            }
        } else if (input instanceof ImageInterleaved && output instanceof ImageGray) {
            ImageInterleaved mb = (ImageInterleaved)input;
            ImageGray so = (ImageGray)output;
            if (mb.getImageType().getDataType() != so.getDataType()) {
                int w = output.width;
                int h = output.height;
                ImageGray tmp = GeneralizedImageOps.createSingleBand((ImageDataType)mb.getImageType().getDataType(), (int)w, (int)h);
                GConvertImage.average(mb, tmp);
                GConvertImage.convert((ImageBase)tmp, (ImageBase)so);
            } else {
                GConvertImage.average(mb, so);
            }
        } else {
            String nameInput = input.getClass().getSimpleName();
            String nameOutput = output.getClass().getSimpleName();
            throw new IllegalArgumentException("Don't know how to convert between input types. " + nameInput + " " + nameOutput);
        }
    }

    public static <T extends ImageGray<T>> T average(ImageMultiBand input, T output) {
        if (input instanceof Planar) {
            return GConvertImage.average((Planar)input, output);
        }
        if (input instanceof ImageInterleaved) {
            return GConvertImage.average((ImageInterleaved)input, output);
        }
        throw new RuntimeException("Unknown multiband image");
    }

    public static <T extends ImageGray<T>> T average(Planar<T> input, T output) {
        Class type = input.getBandType();
        if (type == GrayU8.class) {
            return (T)ConvertImage.average(input, (GrayU8)output);
        }
        if (type == GrayS8.class) {
            return (T)ConvertImage.average(input, (GrayS8)output);
        }
        if (type == GrayU16.class) {
            return (T)ConvertImage.average(input, (GrayU16)output);
        }
        if (type == GrayS16.class) {
            return (T)ConvertImage.average(input, (GrayS16)output);
        }
        if (type == GrayS32.class) {
            return (T)ConvertImage.average(input, (GrayS32)output);
        }
        if (type == GrayS64.class) {
            return (T)ConvertImage.average(input, (GrayS64)output);
        }
        if (type == GrayF32.class) {
            return (T)ConvertImage.average(input, (GrayF32)output);
        }
        if (type == GrayF64.class) {
            return (T)ConvertImage.average(input, (GrayF64)output);
        }
        throw new IllegalArgumentException("Unknown image type: " + type.getSimpleName());
    }

    public static <T extends ImageGray<T>> T average(ImageInterleaved input, T output) {
        ImageDataType type = input.getImageType().getDataType();
        if (type == ImageDataType.U8) {
            return (T)ConvertImage.average((InterleavedU8)input, (GrayU8)output);
        }
        if (type == ImageDataType.S8) {
            return (T)ConvertImage.average((InterleavedS8)input, (GrayS8)output);
        }
        if (type == ImageDataType.U16) {
            return (T)ConvertImage.average((InterleavedU16)input, (GrayU16)output);
        }
        if (type == ImageDataType.S16) {
            return (T)ConvertImage.average((InterleavedS16)input, (GrayS16)output);
        }
        if (type == ImageDataType.S32) {
            return (T)ConvertImage.average((InterleavedS32)input, (GrayS32)output);
        }
        if (type == ImageDataType.S64) {
            return (T)ConvertImage.average((InterleavedS64)input, (GrayS64)output);
        }
        if (type == ImageDataType.F32) {
            return (T)ConvertImage.average((InterleavedF32)input, (GrayF32)output);
        }
        if (type == ImageDataType.F64) {
            return (T)ConvertImage.average((InterleavedF64)input, (GrayF64)output);
        }
        throw new IllegalArgumentException("Unknown image type: " + type);
    }

    public static GrayU8 convert(ImageGray input, double min, double max, int numValues, GrayU8 output) {
        if (min == 0.0 && max == 255.0 && numValues == 256) {
            if (output == null) {
                output = new GrayU8(input.width, input.height);
            }
            GConvertImage.convert((ImageBase)input, (ImageBase)output);
            return output;
        }
        ImageDataType type = input.getImageType().getDataType();
        if (type == ImageDataType.U8) {
            return ConvertImage.convert((GrayU8)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.S8) {
            return ConvertImage.convert((GrayS8)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.U16) {
            return ConvertImage.convert((GrayU16)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.S16) {
            return ConvertImage.convert((GrayS16)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.S32) {
            return ConvertImage.convert((GrayS32)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.S64) {
            return ConvertImage.convert((GrayS64)input, (long)min, (long)max, numValues, output);
        }
        if (type == ImageDataType.F32) {
            return ConvertImage.convert((GrayF32)input, (float)min, (float)max, numValues, output);
        }
        if (type == ImageDataType.F64) {
            return ConvertImage.convert((GrayF64)input, min, max, numValues, output);
        }
        throw new IllegalArgumentException("Unknown image type: " + type);
    }

    public static <T extends ImageGray<T>> T convert(ImageGray<?> src, T dst, Class<T> typeDst) {
        if (dst == null) {
            dst = GeneralizedImageOps.createSingleBand(typeDst, (int)src.width, (int)src.height);
        } else {
            InputSanityCheck.checkSameShape(src, dst);
        }
        GConvertImage.convert(src, dst);
        return dst;
    }
}

