/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.border;

import boofcv.struct.border.ImageBorder_IL_F32;
import boofcv.struct.border.ImageBorder_IL_S32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedS32;
import java.util.Arrays;

public class ConvolveJustBorder_General_IL {
    public static void horizontal(Kernel1D_F32 kernel, ImageBorder_IL_F32 src, InterleavedF32 dst) {
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int borderRight = kernelWidth - offset - 1;
        int numBands = dst.getNumBands();
        float[] pixel = new float[numBands];
        float[] total = new float[numBands];
        for (int y = 0; y < height; ++y) {
            int band;
            int band2;
            float valueK;
            int k;
            int x;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offset; ++x) {
                Arrays.fill(total, 0.0f);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x + k - offset, y, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = total[band];
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - borderRight) * numBands;
            for (x = width - borderRight; x < width; ++x) {
                Arrays.fill(total, 0.0f);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x + k - offset, y, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = total[band];
                }
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, ImageBorder_IL_F32 src, InterleavedF32 dst) {
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int borderBottom = kernelWidth - offset - 1;
        int numBands = dst.getNumBands();
        float[] pixel = new float[numBands];
        float[] total = new float[numBands];
        for (int x = 0; x < width; ++x) {
            int band;
            int band2;
            float valueK;
            int k;
            int indexDst = dst.startIndex + x * numBands;
            int y = 0;
            while (y < offset) {
                Arrays.fill(total, 0.0f);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x, y + k - offset, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
            indexDst = dst.startIndex + (height - borderBottom) * dst.stride + x * numBands;
            y = height - borderBottom;
            while (y < height) {
                Arrays.fill(total, 0.0f);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x, y + k - offset, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, ImageBorder_IL_F32 src, InterleavedF32 dst) {
        int band;
        int band2;
        float valueK;
        int j;
        int i;
        int indexKer;
        int indexDst;
        int offsetL = kernel.getOffset();
        int offsetR = kernel.getWidth() - offsetL - 1;
        int width = dst.getWidth();
        int height = dst.getHeight();
        int numBands = dst.getNumBands();
        float[] pixel = new float[numBands];
        float[] total = new float[numBands];
        for (int y = 0; y < height; ++y) {
            int x;
            indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0.0f);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = total[band];
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                Arrays.fill(total, 0.0f);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = total[band];
                }
            }
        }
        for (int x = offsetL; x < width - offsetR; ++x) {
            indexDst = dst.startIndex + x * numBands;
            int y = 0;
            while (y < offsetL) {
                Arrays.fill(total, 0.0f);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
            indexDst = dst.startIndex + (height - offsetR) * dst.stride + x * numBands;
            y = height - offsetR;
            while (y < height) {
                Arrays.fill(total, 0.0f);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, ImageBorder_IL_S32 src, InterleavedI16 dst) {
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int borderRight = kernelWidth - offset - 1;
        int numBands = dst.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            int band;
            int band2;
            int valueK;
            int k;
            int x;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offset; ++x) {
                Arrays.fill(total, 0);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x + k - offset, y, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = (short)total[band];
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - borderRight) * numBands;
            for (x = width - borderRight; x < width; ++x) {
                Arrays.fill(total, 0);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x + k - offset, y, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = (short)total[band];
                }
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, ImageBorder_IL_S32 src, InterleavedI16 dst) {
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int borderBottom = kernelWidth - offset - 1;
        int numBands = dst.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int x = 0; x < width; ++x) {
            int band;
            int band2;
            int valueK;
            int k;
            int indexDst = dst.startIndex + x * numBands;
            int y = 0;
            while (y < offset) {
                Arrays.fill(total, 0);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x, y + k - offset, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = (short)total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
            indexDst = dst.startIndex + (height - borderBottom) * dst.stride + x * numBands;
            y = height - borderBottom;
            while (y < height) {
                Arrays.fill(total, 0);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x, y + k - offset, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = (short)total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, ImageBorder_IL_S32 src, InterleavedI16 dst) {
        int band;
        int band2;
        int valueK;
        int j;
        int i;
        int indexKer;
        int indexDst;
        int offsetL = kernel.getOffset();
        int offsetR = kernel.getWidth() - offsetL - 1;
        int width = dst.getWidth();
        int height = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            int x;
            indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = (short)total[band];
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                Arrays.fill(total, 0);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = (short)total[band];
                }
            }
        }
        for (int x = offsetL; x < width - offsetR; ++x) {
            indexDst = dst.startIndex + x * numBands;
            int y = 0;
            while (y < offsetL) {
                Arrays.fill(total, 0);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = (short)total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
            indexDst = dst.startIndex + (height - offsetR) * dst.stride + x * numBands;
            y = height - offsetR;
            while (y < height) {
                Arrays.fill(total, 0);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = (short)total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, ImageBorder_IL_S32 src, InterleavedS32 dst) {
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int borderRight = kernelWidth - offset - 1;
        int numBands = dst.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            int band;
            int band2;
            int valueK;
            int k;
            int x;
            int indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offset; ++x) {
                Arrays.fill(total, 0);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x + k - offset, y, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = total[band];
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - borderRight) * numBands;
            for (x = width - borderRight; x < width; ++x) {
                Arrays.fill(total, 0);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x + k - offset, y, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = total[band];
                }
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, ImageBorder_IL_S32 src, InterleavedS32 dst) {
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int borderBottom = kernelWidth - offset - 1;
        int numBands = dst.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int x = 0; x < width; ++x) {
            int band;
            int band2;
            int valueK;
            int k;
            int indexDst = dst.startIndex + x * numBands;
            int y = 0;
            while (y < offset) {
                Arrays.fill(total, 0);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x, y + k - offset, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
            indexDst = dst.startIndex + (height - borderBottom) * dst.stride + x * numBands;
            y = height - borderBottom;
            while (y < height) {
                Arrays.fill(total, 0);
                for (k = 0; k < kernelWidth; ++k) {
                    src.get(x, y + k - offset, pixel);
                    valueK = kernel.data[k];
                    for (band2 = 0; band2 < numBands; ++band2) {
                        int n = band2;
                        total[n] = total[n] + pixel[band2] * valueK;
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, ImageBorder_IL_S32 src, InterleavedS32 dst) {
        int band;
        int band2;
        int valueK;
        int j;
        int i;
        int indexKer;
        int indexDst;
        int offsetL = kernel.getOffset();
        int offsetR = kernel.getWidth() - offsetL - 1;
        int width = dst.getWidth();
        int height = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            int x;
            indexDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < offsetL; ++x) {
                Arrays.fill(total, 0);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = total[band];
                }
            }
            indexDst = dst.startIndex + y * dst.stride + (width - offsetR) * numBands;
            for (x = width - offsetR; x < width; ++x) {
                Arrays.fill(total, 0);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst++] = total[band];
                }
            }
        }
        for (int x = offsetL; x < width - offsetR; ++x) {
            indexDst = dst.startIndex + x * numBands;
            int y = 0;
            while (y < offsetL) {
                Arrays.fill(total, 0);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
            indexDst = dst.startIndex + (height - offsetR) * dst.stride + x * numBands;
            y = height - offsetR;
            while (y < height) {
                Arrays.fill(total, 0);
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        src.get(x + j, y + i, pixel);
                        valueK = kernel.data[indexKer++];
                        for (band2 = 0; band2 < numBands; ++band2) {
                            int n = band2;
                            total[n] = total[n] + pixel[band2] * valueK;
                        }
                    }
                }
                for (band = 0; band < numBands; ++band) {
                    dst.data[indexDst + band] = total[band];
                }
                ++y;
                indexDst += dst.stride;
            }
        }
    }
}

