/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.misc.BoofLambdas;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class FactoryFilterLambdas {
    public static <T extends ImageBase<T>> BoofLambdas.Transform<T> createDownSampleFilter(int maxImagePixels, ImageType<T> imageType) {
        if (maxImagePixels <= 0) {
            return img -> img;
        }
        ImageBase scaled = imageType.createImage(1, 1);
        return full -> {
            double scale = Math.sqrt(maxImagePixels) / Math.sqrt(full.width * full.height);
            if (scale < 1.0) {
                scaled.reshape((int)(scale * (double)full.width), (int)(scale * (double)full.height));
                AverageDownSampleOps.down(full, scaled);
                return scaled;
            }
            return full;
        };
    }
}

