/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.InterleavedF32;

public class InterleavedImageOps {
    public static void split2(InterleavedF32 interleaved, GrayF32 band0, GrayF32 band1) {
        if (interleaved.numBands != 2) {
            throw new IllegalArgumentException("Input interleaved image must have 2 bands");
        }
        InputSanityCheck.checkSameShape((ImageBase)band0, (ImageBase)interleaved);
        InputSanityCheck.checkSameShape((ImageBase)band1, (ImageBase)interleaved);
        for (int y = 0; y < interleaved.height; ++y) {
            int indexTran = interleaved.startIndex + y * interleaved.stride;
            int indexReal = band0.startIndex + y * band0.stride;
            int indexImg = band1.startIndex + y * band1.stride;
            int x = 0;
            while (x < interleaved.width) {
                band0.data[indexReal++] = interleaved.data[indexTran];
                band1.data[indexImg++] = interleaved.data[indexTran + 1];
                ++x;
                indexTran += 2;
            }
        }
    }

    public static void merge2(GrayF32 band0, GrayF32 band1, InterleavedF32 interleaved) {
        if (interleaved.numBands != 2) {
            throw new IllegalArgumentException("Output interleaved image must have 2 bands");
        }
        InputSanityCheck.checkSameShape((ImageBase)band0, (ImageBase)interleaved);
        InputSanityCheck.checkSameShape((ImageBase)band1, (ImageBase)interleaved);
        for (int y = 0; y < interleaved.height; ++y) {
            int indexTran = interleaved.startIndex + y * interleaved.stride;
            int indexReal = band0.startIndex + y * band0.stride;
            int indexImg = band1.startIndex + y * band1.stride;
            int x = 0;
            while (x < interleaved.width) {
                interleaved.data[indexTran] = band0.data[indexReal++];
                interleaved.data[indexTran + 1] = band1.data[indexImg++];
                ++x;
                indexTran += 2;
            }
        }
    }
}

