/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import java.util.Arrays;

public class Histogram2D_S32 {
    public int[] data = new int[0];
    public int rows;
    public int cols;

    public void reshape(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        int length = rows * cols;
        if (length > this.data.length) {
            this.data = new int[length];
        }
    }

    public void zero() {
        Arrays.fill(this.data, 0, this.size(), 0);
    }

    public void increment(int row, int col) {
        int n = row * this.cols + col;
        this.data[n] = this.data[n] + 1;
    }

    public int sumRow(int row) {
        int total = 0;
        for (int col = 0; col < this.cols; ++col) {
            total += this.data[row * this.cols + col];
        }
        return total;
    }

    public int sumCol(int col) {
        int total = 0;
        for (int row = 0; row < this.rows; ++row) {
            total += this.data[row * this.cols + col];
        }
        return total;
    }

    public int maximumColIdx(int row) {
        int best = 0;
        int bestIdx = -1;
        for (int col = 0; col < this.cols; ++col) {
            int v = this.data[row * this.cols + col];
            if (v <= best) continue;
            best = v;
            bestIdx = col;
        }
        return bestIdx;
    }

    public int maximumRowIdx(int col) {
        int best = 0;
        int bestIdx = -1;
        for (int row = 0; row < this.rows; ++row) {
            int v = this.data[row * this.cols + col];
            if (v <= best) continue;
            best = v;
            bestIdx = row;
        }
        return bestIdx;
    }

    public int sum() {
        int total = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            total += this.data[i];
        }
        return total;
    }

    public int get(int row, int col) {
        return this.data[row * this.cols + col];
    }

    public void set(int row, int col, int value) {
        this.data[row * this.cols + col] = value;
    }

    public int indexOf(int row, int col) {
        return row * this.cols + col;
    }

    public int size() {
        return this.rows * this.cols;
    }

    public void print(String format) {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                System.out.printf(format + " ", this.get(row, col));
            }
            System.out.println();
        }
    }
}

