/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayU8;

public class ContourTracerBase {
    protected final ConnectRule rule;
    protected final int ruleN;
    protected GrayU8 binary;
    protected int x;
    protected int y;
    protected int label;
    protected int dir;
    protected int indexBinary;
    protected int[] offsetsBinary;
    protected int[] nextDirection;

    public ContourTracerBase(ConnectRule rule) {
        this.rule = rule;
        if (ConnectRule.EIGHT == rule) {
            this.nextDirection = new int[8];
            for (int i = 0; i < 8; ++i) {
                this.nextDirection[i] = ((i + 4) % 8 + 2) % 8;
            }
            this.ruleN = 8;
        } else if (ConnectRule.FOUR == rule) {
            this.nextDirection = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.nextDirection[i] = ((i + 2) % 4 + 1) % 4;
            }
            this.ruleN = 4;
        } else {
            throw new IllegalArgumentException("Connectivity rule must be 4 or 8 not " + rule);
        }
        this.offsetsBinary = new int[this.ruleN];
    }

    public void setInputs(GrayU8 binary) {
        this.binary = binary;
        if (this.rule == ConnectRule.EIGHT) {
            this.setOffsets8(this.offsetsBinary, binary.stride);
        } else {
            this.setOffsets4(this.offsetsBinary, binary.stride);
        }
    }

    private void setOffsets8(int[] offsets, int stride) {
        int s = stride;
        offsets[0] = 1;
        offsets[1] = 1 + s;
        offsets[2] = s;
        offsets[3] = -1 + s;
        offsets[4] = -1;
        offsets[5] = -1 - s;
        offsets[6] = -s;
        offsets[7] = 1 - s;
    }

    private void setOffsets4(int[] offsets, int stride) {
        int s = stride;
        offsets[0] = 1;
        offsets[1] = s;
        offsets[2] = -1;
        offsets[3] = -s;
    }
}

