/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import org.jetbrains.annotations.Nullable;

public class ImageLambdaFilters {
    public static void filterRectCenterInner(GrayI8 src, int radiusX, int radiusY, GrayI8 dst, @Nullable Object workspace, RectCenter_S32 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        for (int y = y0; y < y1; ++y) {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = (byte)filter.apply(indexSrc++, workspace);
            }
        }
    }

    public static void filterRectCenterEdge(GrayI8 src, int radiusX, int radiusY, GrayI8 dst, @Nullable Object workspace, Rect_S32 filter) {
        int x1;
        int x0;
        int x;
        int indexDstRow;
        int y1;
        int y0;
        int y;
        for (y = 0; y < radiusY; ++y) {
            y0 = 0;
            y1 = Math.min(src.height, y + radiusY + 1);
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = (byte)filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = Math.max(0, src.height - radiusY); y < src.height; ++y) {
            y0 = Math.max(0, y - radiusY);
            y1 = src.height;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = (byte)filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = radiusY; y < Math.max(0, src.height - radiusY); ++y) {
            y0 = y - radiusY;
            y1 = y + radiusY + 1;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < radiusX; ++x) {
                int x12 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = (byte)filter.apply(x, y, 0, y0, x12, y1, workspace);
            }
            for (x = Math.max(0, src.width - radiusX); x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = (byte)filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
    }

    public static void filterRectCenterInner(GrayI16 src, int radiusX, int radiusY, GrayI16 dst, @Nullable Object workspace, RectCenter_S32 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        for (int y = y0; y < y1; ++y) {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = (short)filter.apply(indexSrc++, workspace);
            }
        }
    }

    public static void filterRectCenterEdge(GrayI16 src, int radiusX, int radiusY, GrayI16 dst, @Nullable Object workspace, Rect_S32 filter) {
        int x1;
        int x0;
        int x;
        int indexDstRow;
        int y1;
        int y0;
        int y;
        for (y = 0; y < radiusY; ++y) {
            y0 = 0;
            y1 = Math.min(src.height, y + radiusY + 1);
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = (short)filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = Math.max(0, src.height - radiusY); y < src.height; ++y) {
            y0 = Math.max(0, y - radiusY);
            y1 = src.height;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = (short)filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = radiusY; y < Math.max(0, src.height - radiusY); ++y) {
            y0 = y - radiusY;
            y1 = y + radiusY + 1;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < radiusX; ++x) {
                int x12 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = (short)filter.apply(x, y, 0, y0, x12, y1, workspace);
            }
            for (x = Math.max(0, src.width - radiusX); x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = (short)filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
    }

    public static void filterRectCenterInner(GrayS32 src, int radiusX, int radiusY, GrayS32 dst, @Nullable Object workspace, RectCenter_S32 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        for (int y = y0; y < y1; ++y) {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = filter.apply(indexSrc++, workspace);
            }
        }
    }

    public static void filterRectCenterEdge(GrayS32 src, int radiusX, int radiusY, GrayS32 dst, @Nullable Object workspace, Rect_S32 filter) {
        int x1;
        int x0;
        int x;
        int indexDstRow;
        int y1;
        int y0;
        int y;
        for (y = 0; y < radiusY; ++y) {
            y0 = 0;
            y1 = Math.min(src.height, y + radiusY + 1);
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = Math.max(0, src.height - radiusY); y < src.height; ++y) {
            y0 = Math.max(0, y - radiusY);
            y1 = src.height;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = radiusY; y < Math.max(0, src.height - radiusY); ++y) {
            y0 = y - radiusY;
            y1 = y + radiusY + 1;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < radiusX; ++x) {
                int x12 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, 0, y0, x12, y1, workspace);
            }
            for (x = Math.max(0, src.width - radiusX); x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
    }

    public static void filterRectCenterInner(GrayS64 src, int radiusX, int radiusY, GrayS64 dst, @Nullable Object workspace, RectCenter_S64 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        for (int y = y0; y < y1; ++y) {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = filter.apply(indexSrc++, workspace);
            }
        }
    }

    public static void filterRectCenterEdge(GrayS64 src, int radiusX, int radiusY, GrayS64 dst, @Nullable Object workspace, Rect_S64 filter) {
        int x1;
        int x0;
        int x;
        int indexDstRow;
        int y1;
        int y0;
        int y;
        for (y = 0; y < radiusY; ++y) {
            y0 = 0;
            y1 = Math.min(src.height, y + radiusY + 1);
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = Math.max(0, src.height - radiusY); y < src.height; ++y) {
            y0 = Math.max(0, y - radiusY);
            y1 = src.height;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = radiusY; y < Math.max(0, src.height - radiusY); ++y) {
            y0 = y - radiusY;
            y1 = y + radiusY + 1;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < radiusX; ++x) {
                int x12 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, 0, y0, x12, y1, workspace);
            }
            for (x = Math.max(0, src.width - radiusX); x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
    }

    public static void filterRectCenterInner(GrayF32 src, int radiusX, int radiusY, GrayF32 dst, @Nullable Object workspace, RectCenter_F32 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        for (int y = y0; y < y1; ++y) {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = filter.apply(indexSrc++, workspace);
            }
        }
    }

    public static void filterRectCenterEdge(GrayF32 src, int radiusX, int radiusY, GrayF32 dst, @Nullable Object workspace, Rect_F32 filter) {
        int x1;
        int x0;
        int x;
        int indexDstRow;
        int y1;
        int y0;
        int y;
        for (y = 0; y < radiusY; ++y) {
            y0 = 0;
            y1 = Math.min(src.height, y + radiusY + 1);
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = Math.max(0, src.height - radiusY); y < src.height; ++y) {
            y0 = Math.max(0, y - radiusY);
            y1 = src.height;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = radiusY; y < Math.max(0, src.height - radiusY); ++y) {
            y0 = y - radiusY;
            y1 = y + radiusY + 1;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < radiusX; ++x) {
                int x12 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, 0, y0, x12, y1, workspace);
            }
            for (x = Math.max(0, src.width - radiusX); x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
    }

    public static void filterRectCenterInner(GrayF64 src, int radiusX, int radiusY, GrayF64 dst, @Nullable Object workspace, RectCenter_F64 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        for (int y = y0; y < y1; ++y) {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = filter.apply(indexSrc++, workspace);
            }
        }
    }

    public static void filterRectCenterEdge(GrayF64 src, int radiusX, int radiusY, GrayF64 dst, @Nullable Object workspace, Rect_F64 filter) {
        int x1;
        int x0;
        int x;
        int indexDstRow;
        int y1;
        int y0;
        int y;
        for (y = 0; y < radiusY; ++y) {
            y0 = 0;
            y1 = Math.min(src.height, y + radiusY + 1);
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = Math.max(0, src.height - radiusY); y < src.height; ++y) {
            y0 = Math.max(0, y - radiusY);
            y1 = src.height;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
        for (y = radiusY; y < Math.max(0, src.height - radiusY); ++y) {
            y0 = y - radiusY;
            y1 = y + radiusY + 1;
            indexDstRow = dst.startIndex + y * dst.stride;
            for (x = 0; x < radiusX; ++x) {
                int x12 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, 0, y0, x12, y1, workspace);
            }
            for (x = Math.max(0, src.width - radiusX); x < src.width; ++x) {
                x0 = Math.max(0, x - radiusX);
                x1 = Math.min(src.width, x + radiusX + 1);
                dst.data[indexDstRow + x] = filter.apply(x, y, x0, y0, x1, y1, workspace);
            }
        }
    }

    @FunctionalInterface
    public static interface RectCenter_S32 {
        public int apply(int var1, Object var2);
    }

    @FunctionalInterface
    public static interface Rect_S32 {
        public int apply(int var1, int var2, int var3, int var4, int var5, int var6, Object var7);
    }

    @FunctionalInterface
    public static interface RectCenter_S64 {
        public long apply(int var1, Object var2);
    }

    @FunctionalInterface
    public static interface Rect_S64 {
        public long apply(int var1, int var2, int var3, int var4, int var5, int var6, Object var7);
    }

    @FunctionalInterface
    public static interface RectCenter_F32 {
        public float apply(int var1, Object var2);
    }

    @FunctionalInterface
    public static interface Rect_F32 {
        public float apply(int var1, int var2, int var3, int var4, int var5, int var6, Object var7);
    }

    @FunctionalInterface
    public static interface RectCenter_F64 {
        public double apply(int var1, Object var2);
    }

    @FunctionalInterface
    public static interface Rect_F64 {
        public double apply(int var1, int var2, int var3, int var4, int var5, int var6, Object var7);
    }
}

