/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ImplImageStatistics_MT {
    public static int minU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex] & 0xFF;
        return BoofConcurrency.min((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v >= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int maxU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex] & 0xFF;
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int maxAbsU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex] & 0xFF;
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static double meanDiffSqU(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFF) - (dataB[indexB] & 0xFF);
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static double meanDiffAbsU(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFF) - (dataB[indexB] & 0xFF);
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static int sum(GrayU8 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFF;
            }
            return total;
        }).intValue();
    }

    public static int sum(InterleavedU8 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFF;
            }
            return total;
        }).intValue();
    }

    public static double variance(GrayU8 img, double mean) {
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)(img.data[index] & 0xFF) - mean;
                total += d * d;
            }
            return total;
        }).intValue() / (img.width * img.height);
    }

    public static void histogram(GrayU8 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = (input.data[index++] & 0xFF) - minValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static void histogramScaled(GrayU8 input, int minValue, int maxValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int histLength = histogram.length;
        int rangeValue = maxValue - minValue + 1;
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = histLength * ((input.data[index++] & 0xFF) - minValue) / rangeValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static int min(byte[] array, int startIndex, int rows, int columns, int stride) {
        byte _output = array[startIndex];
        return BoofConcurrency.min((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v >= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int max(byte[] array, int startIndex, int rows, int columns, int stride) {
        byte _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int maxAbs(byte[] array, int startIndex, int rows, int columns, int stride) {
        byte _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static double meanDiffSq(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static double meanDiffAbs(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static int sum(GrayS8 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).intValue();
    }

    public static int sumAbs(GrayS8 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).intValue();
    }

    public static int sum(InterleavedS8 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).intValue();
    }

    public static int sumAbs(InterleavedS8 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).intValue();
    }

    public static double variance(GrayS8 img, double mean) {
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                total += d * d;
            }
            return total;
        }).intValue() / (img.width * img.height);
    }

    public static void histogram(GrayS8 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = input.data[index++] - minValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static void histogramScaled(GrayS8 input, int minValue, int maxValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int histLength = histogram.length;
        int rangeValue = maxValue - minValue + 1;
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = histLength * (input.data[index++] - minValue) / rangeValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static int minU(short[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex] & 0xFFFF;
        return BoofConcurrency.min((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v >= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int maxU(short[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex] & 0xFFFF;
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int maxAbsU(short[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex] & 0xFFFF;
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static double meanDiffSqU(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFFFF) - (dataB[indexB] & 0xFFFF);
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static double meanDiffAbsU(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFFFF) - (dataB[indexB] & 0xFFFF);
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static int sum(GrayU16 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFFFF;
            }
            return total;
        }).intValue();
    }

    public static int sum(InterleavedU16 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFFFF;
            }
            return total;
        }).intValue();
    }

    public static double variance(GrayU16 img, double mean) {
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)(img.data[index] & 0xFFFF) - mean;
                total += d * d;
            }
            return total;
        }).intValue() / (img.width * img.height);
    }

    public static void histogram(GrayU16 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = (input.data[index++] & 0xFFFF) - minValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static void histogramScaled(GrayU16 input, int minValue, int maxValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int histLength = histogram.length;
        int rangeValue = maxValue - minValue + 1;
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = histLength * ((input.data[index++] & 0xFFFF) - minValue) / rangeValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static int min(short[] array, int startIndex, int rows, int columns, int stride) {
        short _output = array[startIndex];
        return BoofConcurrency.min((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v >= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int max(short[] array, int startIndex, int rows, int columns, int stride) {
        short _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int maxAbs(short[] array, int startIndex, int rows, int columns, int stride) {
        short _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static double meanDiffSq(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static double meanDiffAbs(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static int sum(GrayS16 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).intValue();
    }

    public static int sumAbs(GrayS16 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).intValue();
    }

    public static int sum(InterleavedS16 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).intValue();
    }

    public static int sumAbs(InterleavedS16 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).intValue();
    }

    public static double variance(GrayS16 img, double mean) {
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                total += d * d;
            }
            return total;
        }).intValue() / (img.width * img.height);
    }

    public static void histogram(GrayS16 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = input.data[index++] - minValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static void histogramScaled(GrayS16 input, int minValue, int maxValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int histLength = histogram.length;
        int rangeValue = maxValue - minValue + 1;
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = histLength * (input.data[index++] - minValue) / rangeValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static int min(int[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex];
        return BoofConcurrency.min((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v >= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int max(int[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static int maxAbs(int[] array, int startIndex, int rows, int columns, int stride) {
        int _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Integer.TYPE, y -> {
            int index;
            int output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).intValue();
    }

    public static double meanDiffSq(int[] dataA, int startIndexA, int strideA, int[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static double meanDiffAbs(int[] dataA, int startIndexA, int strideA, int[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Integer.TYPE, y -> {
            int total = 0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
            return total;
        }).intValue() / (double)(rows * columns);
    }

    public static int sum(GrayS32 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).intValue();
    }

    public static int sumAbs(GrayS32 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).intValue();
    }

    public static int sum(InterleavedS32 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).intValue();
    }

    public static int sumAbs(InterleavedS32 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Integer.TYPE, y -> {
            int index;
            int total = 0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).intValue();
    }

    public static double variance(GrayS32 img, double mean) {
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                total += d * d;
            }
            return total;
        }).intValue() / (img.width * img.height);
    }

    public static void histogram(GrayS32 input, int minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = input.data[index++] - minValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static void histogramScaled(GrayS32 input, int minValue, int maxValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        int histLength = histogram.length;
        int rangeValue = maxValue - minValue + 1;
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = histLength * (input.data[index++] - minValue) / rangeValue;
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static long min(long[] array, int startIndex, int rows, int columns, int stride) {
        long _output = array[startIndex];
        return BoofConcurrency.min((int)0, (int)rows, Long.TYPE, y -> {
            int index;
            long output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = array[index];
                if (v >= output) continue;
                output = v;
            }
            return output;
        }).longValue();
    }

    public static long max(long[] array, int startIndex, int rows, int columns, int stride) {
        long _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Long.TYPE, y -> {
            int index;
            long output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = array[index];
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).longValue();
    }

    public static long maxAbs(long[] array, int startIndex, int rows, int columns, int stride) {
        long _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Long.TYPE, y -> {
            int index;
            long output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
            return output;
        }).longValue();
    }

    public static double meanDiffSq(long[] dataA, int startIndexA, int strideA, long[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Long.TYPE, y -> {
            long total = 0L;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                long difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
            return total;
        }).longValue() / (double)(rows * columns);
    }

    public static double meanDiffAbs(long[] dataA, int startIndexA, int strideA, long[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Long.TYPE, y -> {
            long total = 0L;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                long difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
            return total;
        }).longValue() / (double)(rows * columns);
    }

    public static long sum(GrayS64 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Long.TYPE, y -> {
            int index;
            long total = 0L;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).longValue();
    }

    public static long sumAbs(GrayS64 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Long.TYPE, y -> {
            int index;
            long total = 0L;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).longValue();
    }

    public static long sum(InterleavedS64 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Long.TYPE, y -> {
            int index;
            long total = 0L;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).longValue();
    }

    public static long sumAbs(InterleavedS64 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Long.TYPE, y -> {
            int index;
            long total = 0L;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).longValue();
    }

    public static double variance(GrayS64 img, double mean) {
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                total += d * d;
            }
            return total;
        }).longValue() / (long)(img.width * img.height);
    }

    public static void histogram(GrayS64 input, long minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = (int)(input.data[index++] - minValue);
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static void histogramScaled(GrayS64 input, long minValue, long maxValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        long histLength = histogram.length;
        long rangeValue = maxValue - minValue + 1L;
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = (int)(histLength * (input.data[index++] - minValue) / rangeValue);
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static float min(float[] array, int startIndex, int rows, int columns, int stride) {
        float _output = array[startIndex];
        return BoofConcurrency.min((int)0, (int)rows, Float.TYPE, y -> {
            int index;
            float output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = array[index];
                if (!(v < output)) continue;
                output = v;
            }
            return Float.valueOf(output);
        }).floatValue();
    }

    public static float max(float[] array, int startIndex, int rows, int columns, int stride) {
        float _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Float.TYPE, y -> {
            int index;
            float output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = array[index];
                if (!(v > output)) continue;
                output = v;
            }
            return Float.valueOf(output);
        }).floatValue();
    }

    public static float maxAbs(float[] array, int startIndex, int rows, int columns, int stride) {
        float _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Float.TYPE, y -> {
            int index;
            float output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = Math.abs(array[index]);
                if (!(v > output)) continue;
                output = v;
            }
            return Float.valueOf(output);
        }).floatValue();
    }

    public static double meanDiffSq(float[] dataA, int startIndexA, int strideA, float[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Float.TYPE, y -> {
            float total = 0.0f;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                float difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
            return Float.valueOf(total);
        }).floatValue() / (double)(rows * columns);
    }

    public static double meanDiffAbs(float[] dataA, int startIndexA, int strideA, float[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return (double)BoofConcurrency.sum((int)0, (int)rows, Float.TYPE, y -> {
            float total = 0.0f;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                float difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
            return Float.valueOf(total);
        }).floatValue() / (double)(rows * columns);
    }

    public static float sum(GrayF32 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Float.TYPE, y -> {
            int index;
            float total = 0.0f;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return Float.valueOf(total);
        }).floatValue();
    }

    public static float sumAbs(GrayF32 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Float.TYPE, y -> {
            int index;
            float total = 0.0f;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return Float.valueOf(total);
        }).floatValue();
    }

    public static float sum(InterleavedF32 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Float.TYPE, y -> {
            int index;
            float total = 0.0f;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return Float.valueOf(total);
        }).floatValue();
    }

    public static float sumAbs(InterleavedF32 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Float.TYPE, y -> {
            int index;
            float total = 0.0f;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return Float.valueOf(total);
        }).floatValue();
    }

    public static float variance(GrayF32 img, float mean) {
        return BoofConcurrency.sum((int)0, (int)img.height, Float.TYPE, y -> {
            int index;
            float total = 0.0f;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                float d = img.data[index] - mean;
                total += d * d;
            }
            return Float.valueOf(total);
        }).floatValue() / (float)(img.width * img.height);
    }

    public static void histogram(GrayF32 input, float minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = (int)(input.data[index++] - minValue);
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static void histogramScaled(GrayF32 input, float minValue, float maxValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        float histLength = histogram.length;
        float rangeValue = maxValue - minValue + 1.0f;
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = (int)(histLength * (input.data[index++] - minValue) / rangeValue);
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static double min(double[] array, int startIndex, int rows, int columns, int stride) {
        double _output = array[startIndex];
        return BoofConcurrency.min((int)0, (int)rows, Double.TYPE, y -> {
            int index;
            double output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = array[index];
                if (!(v < output)) continue;
                output = v;
            }
            return output;
        }).doubleValue();
    }

    public static double max(double[] array, int startIndex, int rows, int columns, int stride) {
        double _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Double.TYPE, y -> {
            int index;
            double output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = array[index];
                if (!(v > output)) continue;
                output = v;
            }
            return output;
        }).doubleValue();
    }

    public static double maxAbs(double[] array, int startIndex, int rows, int columns, int stride) {
        double _output = array[startIndex];
        return BoofConcurrency.max((int)0, (int)rows, Double.TYPE, y -> {
            int index;
            double output = _output;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = Math.abs(array[index]);
                if (!(v > output)) continue;
                output = v;
            }
            return output;
        }).doubleValue();
    }

    public static double meanDiffSq(double[] dataA, int startIndexA, int strideA, double[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return BoofConcurrency.sum((int)0, (int)rows, Double.TYPE, y -> {
            double total = 0.0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                double difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
            return total;
        }).doubleValue() / (double)(rows * columns);
    }

    public static double meanDiffAbs(double[] dataA, int startIndexA, int strideA, double[] dataB, int startIndexB, int strideB, int rows, int columns) {
        return BoofConcurrency.sum((int)0, (int)rows, Double.TYPE, y -> {
            double total = 0.0;
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                double difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
            return total;
        }).doubleValue() / (double)(rows * columns);
    }

    public static double sum(GrayF64 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).doubleValue();
    }

    public static double sumAbs(GrayF64 img) {
        int rows = img.height;
        int columns = img.width;
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).doubleValue();
    }

    public static double sum(InterleavedF64 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
            return total;
        }).doubleValue();
    }

    public static double sumAbs(InterleavedF64 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += Math.abs(img.data[index]);
            }
            return total;
        }).doubleValue();
    }

    public static double variance(GrayF64 img, double mean) {
        return BoofConcurrency.sum((int)0, (int)img.height, Double.TYPE, y -> {
            int index;
            double total = 0.0;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = img.data[index] - mean;
                total += d * d;
            }
            return total;
        }).doubleValue() / (double)(img.width * img.height);
    }

    public static void histogram(GrayF64 input, double minValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = (int)(input.data[index++] - minValue);
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }

    public static void histogramScaled(GrayF64 input, double minValue, double maxValue, int[] histogram) {
        Arrays.fill(histogram, 0);
        double histLength = histogram.length;
        double rangeValue = maxValue - minValue + 1.0;
        ArrayList list = new ArrayList();
        BoofConcurrency.loopBlocks((int)0, (int)input.height, (y0, y1) -> {
            int[] h = new int[histogram.length];
            for (int y = y0; y < y1; ++y) {
                int index = input.startIndex + y * input.stride;
                int end = index + input.width;
                while (index < end) {
                    int n = (int)(histLength * (input.data[index++] - minValue) / rangeValue);
                    h[n] = h[n] + 1;
                }
            }
            List list2 = list;
            synchronized (list2) {
                list.add(h);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            int[] h = (int[])list.get(i);
            for (int j = 0; j < histogram.length; ++j) {
                int n = j;
                histogram[n] = histogram[n] + h[j];
            }
        }
    }
}

