/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.binary.ThresholdBlock;
import boofcv.alg.filter.binary.ThresholdBlockMean;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;

public class ThresholdBlockMean_F32
extends ThresholdBlockMean<GrayF32> {
    float scale;

    public ThresholdBlockMean_F32(double scale, boolean down) {
        super(down);
        this.scale = (float)scale;
    }

    @Override
    public void thresholdBlock(int blockX0, int blockY0, GrayF32 input, GrayF32 stats, GrayU8 output) {
        int y;
        int blockY1;
        int blockX1;
        int y1;
        int x0 = blockX0 * this.blockWidth;
        int y0 = blockY0 * this.blockHeight;
        int x1 = blockX0 == stats.width - 1 ? input.width : (blockX0 + 1) * this.blockWidth;
        int n = y1 = blockY0 == stats.height - 1 ? input.height : (blockY0 + 1) * this.blockHeight;
        if (this.thresholdFromLocalBlocks) {
            blockX1 = Math.min(stats.width - 1, blockX0 + 1);
            blockY1 = Math.min(stats.height - 1, blockY0 + 1);
            blockX0 = Math.max(0, blockX0 - 1);
            blockY0 = Math.max(0, blockY0 - 1);
        } else {
            blockX1 = blockX0;
            blockY1 = blockY0;
        }
        float mean = 0.0f;
        for (y = blockY0; y <= blockY1; ++y) {
            for (int x = blockX0; x <= blockX1; ++x) {
                mean += stats.unsafe_get(x, y);
            }
        }
        mean /= (float)((blockY1 - blockY0 + 1) * (blockX1 - blockX0 + 1));
        for (y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            int end = indexOutput + (x1 - x0);
            while (indexOutput < end) {
                output.data[indexOutput] = input.data[indexInput] <= mean ? this.a : this.b;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    @Override
    public ThresholdBlock.BlockProcessor<GrayF32, GrayF32> copy() {
        return new ThresholdBlockMean_F32(this.scale, this.isDown());
    }

    @Override
    public GrayF32 createStats() {
        return new GrayF32(1, 1);
    }

    @Override
    public void computeBlockStatistics(int x0, int y0, int width, int height, int indexStats, GrayF32 input, GrayF32 stats) {
        float sum = 0.0f;
        for (int y = 0; y < height; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            for (int x = 0; x < width; ++x) {
                sum += input.data[indexInput++];
            }
        }
        stats.data[indexStats] = sum = this.scale * sum / (float)(width * height);
    }
}

