/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.convolve;

import boofcv.BoofTesting;
import boofcv.abst.filter.convolve.ConvolveDown;
import boofcv.abst.filter.convolve.GenericConvolveDown;
import boofcv.abst.filter.convolve.PlanarConvolveDown;
import boofcv.alg.filter.convolve.ConvolveImageDownNoBorder;
import boofcv.alg.filter.convolve.ConvolveImageDownNormalized;
import boofcv.struct.border.BorderType;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.lang.reflect.Method;

public class FactoryConvolveDown {
    public static <In extends ImageBase<In>, Out extends ImageBase<Out>> ConvolveDown<In, Out> convolve(Kernel1D kernel, BorderType border, boolean isHorizontal, int skip, ImageType<In> inputType, ImageType<Out> outputType) {
        ConvolveDown<Object, Object> convolveDown;
        switch (inputType.getFamily()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PLANAR: {
                convolveDown = FactoryConvolveDown.convolvePL(kernel, border, isHorizontal, skip, inputType.getNumBands(), inputType.getImageClass(), outputType.getImageClass());
                break;
            }
            case GRAY: {
                convolveDown = FactoryConvolveDown.convolveSB(kernel, border, isHorizontal, skip, inputType.getImageClass(), outputType.getImageClass());
                break;
            }
            case INTERLEAVED: {
                throw new IllegalArgumentException("Interleaved images are not yet supported");
            }
        }
        return convolveDown;
    }

    public static <In extends ImageBase<In>, Out extends ImageBase<Out>> ConvolveDown<In, Out> convolve(Kernel2D kernel, BorderType border, int skip, ImageType<In> inputType, ImageType<Out> outputType) {
        ConvolveDown<Object, Object> convolveDown;
        switch (inputType.getFamily()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PLANAR: {
                convolveDown = FactoryConvolveDown.convolvePL(kernel, border, skip, inputType.getNumBands(), inputType.getImageClass(), outputType.getImageClass());
                break;
            }
            case GRAY: {
                convolveDown = FactoryConvolveDown.convolveSB(kernel, border, skip, inputType.getImageClass(), outputType.getImageClass());
                break;
            }
            case INTERLEAVED: {
                throw new IllegalArgumentException("Interleaved images are not yet supported");
            }
        }
        return convolveDown;
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> GenericConvolveDown<Input, Output> convolveSB(Kernel1D kernel, BorderType border, boolean isHorizontal, int skip, Class<Input> inputType, Class<Output> outputType) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        String direction = isHorizontal ? "horizontal" : "vertical";
        try {
            Method method;
            switch (border) {
                case SKIP: {
                    method = ConvolveImageDownNoBorder.class.getMethod(direction, kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                case EXTENDED: {
                    throw new IllegalArgumentException("Extended border is currently not supported.");
                }
                case NORMALIZED: {
                    method = ConvolveImageDownNormalized.class.getMethod(direction, kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + border);
                }
            }
            m = method;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolveDown(m, (KernelBase)kernel, border, skip, ImageType.single(inputType), ImageType.single((Class)outputType));
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> GenericConvolveDown<Input, Output> convolveSB(Kernel2D kernel, BorderType border, int skip, Class<Input> inputType, Class<Output> outputType) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        try {
            Method method;
            switch (border) {
                case SKIP: {
                    method = ConvolveImageDownNoBorder.class.getMethod("convolve", kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                case EXTENDED: {
                    throw new IllegalArgumentException("Extended border is currently not supported.");
                }
                case NORMALIZED: {
                    method = ConvolveImageDownNormalized.class.getMethod("convolve", kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + border);
                }
            }
            m = method;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolveDown(m, (KernelBase)kernel, border, skip, ImageType.single(inputType), ImageType.single((Class)outputType));
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ConvolveDown<Planar<Input>, Planar<Output>> convolvePL(Kernel1D kernel, BorderType border, boolean isHorizontal, int skip, int numBands, Class<Input> inputType, Class<Output> outputType) {
        GenericConvolveDown<Input, Output> grayDown = FactoryConvolveDown.convolveSB(kernel, border, isHorizontal, skip, inputType, outputType);
        return new PlanarConvolveDown<Input, Output>(grayDown, numBands);
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ConvolveDown<Planar<Input>, Planar<Output>> convolvePL(Kernel2D kernel, BorderType border, int skip, int numBands, Class<Input> inputType, Class<Output> outputType) {
        GenericConvolveDown<Input, Output> grayDown = FactoryConvolveDown.convolveSB(kernel, border, skip, inputType, outputType);
        return new PlanarConvolveDown<Input, Output>(grayDown, numBands);
    }
}

