/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.filter.misc.ImageLambdaFilters;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class AdaptiveMeanFilter {
    int radiusX;
    int radiusY;
    double noiseVariance;

    public AdaptiveMeanFilter(int radiusX, int radiusY) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
    }

    public AdaptiveMeanFilter() {
    }

    public <T extends ImageGray<T>> void process(T src, T dst) {
        switch (src.getDataType()) {
            case U8: {
                this.process((GrayU8)src, (GrayU8)dst);
                break;
            }
            case U16: {
                this.process((GrayU16)src, (GrayU16)dst);
                break;
            }
            case F32: {
                this.process((GrayF32)src, (GrayF32)dst);
                break;
            }
            case F64: {
                this.process((GrayF64)src, (GrayF64)dst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type: " + String.valueOf(src.getDataType()));
            }
        }
    }

    public void process(GrayU8 src, GrayU8 dst) {
        BoofMiscOps.checkTrue((this.radiusX >= 0 ? 1 : 0) != 0, (String)"radiusX must not be negative");
        BoofMiscOps.checkTrue((this.radiusY >= 0 ? 1 : 0) != 0, (String)"radiusY must not be negative");
        dst.reshape(src.width, src.height);
        int regionX = this.radiusX * 2 + 1;
        int regionY = this.radiusY * 2 + 1;
        int[] localValues = new int[regionX * regionY];
        ImageLambdaFilters.filterRectCenterInner((GrayI8)src, this.radiusX, this.radiusY, (GrayI8)dst, (Object)localValues, (indexCenter, w) -> {
            int[] values = (int[])w;
            int valueIndex = 0;
            int pixelRowIndex = indexCenter - this.radiusX - this.radiusY * src.stride;
            for (int y = 0; y < regionY; ++y) {
                int pixelIndex = pixelRowIndex + y * src.stride;
                for (int x = 0; x < regionX; ++x) {
                    localValues[valueIndex++] = src.data[pixelIndex++] & 0xFF;
                }
            }
            int N = localValues.length;
            return AdaptiveMeanFilter.computeFilter(this.noiseVariance, localValues[N / 2], values, N);
        });
        ImageLambdaFilters.filterRectCenterEdge((GrayI8)src, this.radiusX, this.radiusY, (GrayI8)dst, (Object)localValues, (cx, cy, x0, y0, x1, y1, w) -> {
            int[] values = (int[])w;
            int valueIndex = 0;
            for (int y = y0; y < y1; ++y) {
                int indexSrc = src.startIndex + y * src.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    values[valueIndex++] = src.data[indexSrc++] & 0xFF;
                }
            }
            int indexCenter = (cy - y0) * (x1 - x0) + cx - x0;
            int N = (x1 - x0) * (y1 - y0);
            return AdaptiveMeanFilter.computeFilter(this.noiseVariance, values[indexCenter], values, N);
        });
    }

    public void process(GrayU16 src, GrayU16 dst) {
        BoofMiscOps.checkTrue((this.radiusX >= 0 ? 1 : 0) != 0, (String)"radiusX must not be negative");
        BoofMiscOps.checkTrue((this.radiusY >= 0 ? 1 : 0) != 0, (String)"radiusY must not be negative");
        dst.reshape(src.width, src.height);
        int regionX = this.radiusX * 2 + 1;
        int regionY = this.radiusY * 2 + 1;
        int[] localValues = new int[regionX * regionY];
        ImageLambdaFilters.filterRectCenterInner((GrayI16)src, this.radiusX, this.radiusY, (GrayI16)dst, (Object)localValues, (indexCenter, w) -> {
            int[] values = (int[])w;
            int valueIndex = 0;
            int pixelRowIndex = indexCenter - this.radiusX - this.radiusY * src.stride;
            for (int y = 0; y < regionY; ++y) {
                int pixelIndex = pixelRowIndex + y * src.stride;
                for (int x = 0; x < regionX; ++x) {
                    localValues[valueIndex++] = src.data[pixelIndex++] & 0xFFFF;
                }
            }
            int N = localValues.length;
            return AdaptiveMeanFilter.computeFilter(this.noiseVariance, localValues[N / 2], values, N);
        });
        ImageLambdaFilters.filterRectCenterEdge((GrayI16)src, this.radiusX, this.radiusY, (GrayI16)dst, (Object)localValues, (cx, cy, x0, y0, x1, y1, w) -> {
            int[] values = (int[])w;
            int valueIndex = 0;
            for (int y = y0; y < y1; ++y) {
                int indexSrc = src.startIndex + y * src.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    values[valueIndex++] = src.data[indexSrc++] & 0xFFFF;
                }
            }
            int indexCenter = (cy - y0) * (x1 - x0) + cx - x0;
            int N = (x1 - x0) * (y1 - y0);
            return AdaptiveMeanFilter.computeFilter(this.noiseVariance, values[indexCenter], values, N);
        });
    }

    public void process(GrayF32 src, GrayF32 dst) {
        BoofMiscOps.checkTrue((this.radiusX >= 0 ? 1 : 0) != 0, (String)"radiusX must not be negative");
        BoofMiscOps.checkTrue((this.radiusY >= 0 ? 1 : 0) != 0, (String)"radiusY must not be negative");
        dst.reshape(src.width, src.height);
        int regionX = this.radiusX * 2 + 1;
        int regionY = this.radiusY * 2 + 1;
        float[] localValues = new float[regionX * regionY];
        ImageLambdaFilters.filterRectCenterInner(src, this.radiusX, this.radiusY, dst, (Object)localValues, (indexCenter, w) -> {
            float[] values = (float[])w;
            int valueIndex = 0;
            int pixelRowIndex = indexCenter - this.radiusX - this.radiusY * src.stride;
            for (int y = 0; y < regionY; ++y) {
                int pixelIndex = pixelRowIndex + y * src.stride;
                for (int x = 0; x < regionX; ++x) {
                    localValues[valueIndex++] = src.data[pixelIndex++];
                }
            }
            int N = localValues.length;
            return AdaptiveMeanFilter.computeFilter((float)this.noiseVariance, localValues[N / 2], values, N);
        });
        ImageLambdaFilters.filterRectCenterEdge(src, this.radiusX, this.radiusY, dst, (Object)localValues, (cx, cy, x0, y0, x1, y1, w) -> {
            float[] values = (float[])w;
            int valueIndex = 0;
            for (int y = y0; y < y1; ++y) {
                int indexSrc = src.startIndex + y * src.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    values[valueIndex++] = src.data[indexSrc++];
                }
            }
            int indexCenter = (cy - y0) * (x1 - x0) + cx - x0;
            int N = (x1 - x0) * (y1 - y0);
            return AdaptiveMeanFilter.computeFilter((float)this.noiseVariance, values[indexCenter], values, N);
        });
    }

    public void process(GrayF64 src, GrayF64 dst) {
        BoofMiscOps.checkTrue((this.radiusX >= 0 ? 1 : 0) != 0, (String)"radiusX must not be negative");
        BoofMiscOps.checkTrue((this.radiusY >= 0 ? 1 : 0) != 0, (String)"radiusY must not be negative");
        dst.reshape(src.width, src.height);
        int regionX = this.radiusX * 2 + 1;
        int regionY = this.radiusY * 2 + 1;
        double[] localValues = new double[regionX * regionY];
        ImageLambdaFilters.filterRectCenterInner(src, this.radiusX, this.radiusY, dst, (Object)localValues, (indexCenter, w) -> {
            double[] values = (double[])w;
            int valueIndex = 0;
            int pixelRowIndex = indexCenter - this.radiusX - this.radiusY * src.stride;
            for (int y = 0; y < regionY; ++y) {
                int pixelIndex = pixelRowIndex + y * src.stride;
                for (int x = 0; x < regionX; ++x) {
                    localValues[valueIndex++] = src.data[pixelIndex++];
                }
            }
            int N = localValues.length;
            return AdaptiveMeanFilter.computeFilter(this.noiseVariance, localValues[N / 2], values, N);
        });
        ImageLambdaFilters.filterRectCenterEdge(src, this.radiusX, this.radiusY, dst, (Object)localValues, (cx, cy, x0, y0, x1, y1, w) -> {
            double[] values = (double[])w;
            int valueIndex = 0;
            for (int y = y0; y < y1; ++y) {
                int indexSrc = src.startIndex + y * src.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    values[valueIndex++] = src.data[indexSrc++];
                }
            }
            int indexCenter = (cy - y0) * (x1 - x0) + cx - x0;
            int N = (x1 - x0) * (y1 - y0);
            return AdaptiveMeanFilter.computeFilter(this.noiseVariance, values[indexCenter], values, N);
        });
    }

    static int computeFilter(double noiseVariance, int centerValue, int[] values, int N) {
        double localMean = 0.0;
        for (int i = 0; i < N; ++i) {
            localMean += (double)values[i];
        }
        localMean /= (double)N;
        double localVariance = 0.0;
        for (int i = 0; i < N; ++i) {
            double diff = (double)values[i] - localMean;
            localVariance += diff * diff;
        }
        if ((localVariance /= (double)N) == 0.0) {
            return centerValue;
        }
        return (int)((double)centerValue - Math.min(1.0, noiseVariance / localVariance) * ((double)centerValue - localMean) + 0.5);
    }

    static float computeFilter(float noiseVariance, float centerValue, float[] values, int N) {
        float localMean = 0.0f;
        for (int i = 0; i < N; ++i) {
            localMean += values[i];
        }
        localMean /= (float)N;
        float localVariance = 0.0f;
        for (int i = 0; i < N; ++i) {
            float diff = values[i] - localMean;
            localVariance += diff * diff;
        }
        if ((localVariance /= (float)N) == 0.0f) {
            return centerValue;
        }
        return centerValue - Math.min(1.0f, noiseVariance / localVariance) * (centerValue - localMean);
    }

    static double computeFilter(double noiseVariance, double centerValue, double[] values, int N) {
        double localMean = 0.0;
        for (int i = 0; i < N; ++i) {
            localMean += values[i];
        }
        localMean /= (double)N;
        double localVariance = 0.0;
        for (int i = 0; i < N; ++i) {
            double diff = values[i] - localMean;
            localVariance += diff * diff;
        }
        if ((localVariance /= (double)N) == 0.0) {
            return centerValue;
        }
        return centerValue - Math.min(1.0, noiseVariance / localVariance) * (centerValue - localMean);
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public void setRadiusX(int radiusX) {
        this.radiusX = radiusX;
    }

    public void setRadiusY(int radiusY) {
        this.radiusY = radiusY;
    }

    public double getNoiseVariance() {
        return this.noiseVariance;
    }
}

