/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.binary;

import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigThreshold
implements Configuration {
    public ThresholdType type;
    public double fixedThreshold;
    public double scale = 1.0;
    public boolean down = true;
    public ConfigLength width = ConfigLength.fixed((double)11.0);
    public float niblackK = 0.3f;
    public float nickK = -0.2f;
    public int minPixelValue = 0;
    public int maxPixelValue = 255;
    public boolean thresholdFromLocalBlocks = true;

    public static ConfigThreshold fixed(double value) {
        ConfigThreshold config = new ConfigThreshold();
        config.type = ThresholdType.FIXED;
        config.fixedThreshold = value;
        return config;
    }

    public static ConfigThreshold global(ThresholdType type) {
        if (!type.isAdaptive()) {
            throw new IllegalArgumentException("Type must be adaptive");
        }
        if (!type.isGlobal()) {
            throw new IllegalArgumentException("Type must be global");
        }
        ConfigThreshold config = new ConfigThreshold();
        config.type = type;
        return config;
    }

    public static <T extends ConfigThreshold> T local(ThresholdType type, int width) {
        return ConfigThreshold.local(type, ConfigLength.fixed((double)width));
    }

    public static <T extends ConfigThreshold> T local(ThresholdType type, ConfigLength width) {
        if (!type.isAdaptive()) {
            throw new IllegalArgumentException("Type must be adaptive");
        }
        if (type.isGlobal()) {
            throw new IllegalArgumentException("Type must be local");
        }
        ConfigThreshold config = type == ThresholdType.BLOCK_MIN_MAX ? new ConfigThresholdBlockMinMax(width, 10.0, true) : (type == ThresholdType.BLOCK_OTSU ? new ConfigThresholdLocalOtsu() : new ConfigThreshold());
        config.scale = 0.95;
        config.type = type;
        config.width = width;
        return (T)config;
    }

    public ConfigThreshold setTo(ConfigThreshold src) {
        this.type = src.type;
        this.fixedThreshold = src.fixedThreshold;
        this.scale = src.scale;
        this.down = src.down;
        this.width.setTo(src.width);
        this.niblackK = src.niblackK;
        this.nickK = src.nickK;
        this.minPixelValue = src.minPixelValue;
        this.maxPixelValue = src.maxPixelValue;
        this.thresholdFromLocalBlocks = src.thresholdFromLocalBlocks;
        return this;
    }

    public void checkValidity() {
    }

    public String toString() {
        return "ConfigThreshold{type=" + String.valueOf((Object)this.type) + ", fixedThreshold=" + this.fixedThreshold + ", scale=" + this.scale + ", down=" + this.down + ", width=" + String.valueOf(this.width) + ", savolaK=" + this.niblackK + ", minPixelValue=" + this.minPixelValue + ", maxPixelValue=" + this.maxPixelValue + "}";
    }

    public ThresholdType getType() {
        return this.type;
    }

    public double getFixedThreshold() {
        return this.fixedThreshold;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isDown() {
        return this.down;
    }

    public ConfigLength getWidth() {
        return this.width;
    }

    public float getNiblackK() {
        return this.niblackK;
    }

    public float getNickK() {
        return this.nickK;
    }

    public int getMinPixelValue() {
        return this.minPixelValue;
    }

    public int getMaxPixelValue() {
        return this.maxPixelValue;
    }

    public boolean isThresholdFromLocalBlocks() {
        return this.thresholdFromLocalBlocks;
    }

    public void setType(ThresholdType type) {
        this.type = type;
    }

    public void setFixedThreshold(double fixedThreshold) {
        this.fixedThreshold = fixedThreshold;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    public void setWidth(ConfigLength width) {
        this.width = width;
    }

    public void setNiblackK(float niblackK) {
        this.niblackK = niblackK;
    }

    public void setNickK(float nickK) {
        this.nickK = nickK;
    }

    public void setMinPixelValue(int minPixelValue) {
        this.minPixelValue = minPixelValue;
    }

    public void setMaxPixelValue(int maxPixelValue) {
        this.maxPixelValue = maxPixelValue;
    }

    public void setThresholdFromLocalBlocks(boolean thresholdFromLocalBlocks) {
        this.thresholdFromLocalBlocks = thresholdFromLocalBlocks;
    }
}

